package org.cloudfoundry.client.v3.roles;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Pagination;
import org.immutables.value.Generated;

/**
 * The response payload for the List Roles operation
 */
@Generated(from = "_ListRolesResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListRolesResponse extends org.cloudfoundry.client.v3.roles._ListRolesResponse {
  private final @Nullable Pagination pagination;
  private final @Nullable List<RoleResource> resources;

  private ListRolesResponse(ListRolesResponse.Builder builder) {
    this.pagination = builder.pagination;
    this.resources = builder.resources == null ? null : createUnmodifiableList(true, builder.resources);
  }

  /**
   * The pagination
   */
  @JsonProperty("pagination")
  @Override
  public @Nullable Pagination getPagination() {
    return pagination;
  }

  /**
   * The resources
   */
  @JsonProperty("resources")
  @Override
  public @Nullable List<RoleResource> getResources() {
    return resources;
  }

  /**
   * This instance is equal to all instances of {@code ListRolesResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListRolesResponse
        && equalTo((ListRolesResponse) another);
  }

  private boolean equalTo(ListRolesResponse another) {
    return Objects.equals(pagination, another.pagination)
        && Objects.equals(resources, another.resources);
  }

  /**
   * Computes a hash code from attributes: {@code pagination}, {@code resources}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(pagination);
    h += (h << 5) + Objects.hashCode(resources);
    return h;
  }

  /**
   * Prints the immutable value {@code ListRolesResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListRolesResponse{"
        + "pagination=" + pagination
        + ", resources=" + resources
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ListRolesResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.roles._ListRolesResponse {
    Pagination pagination;
    List<RoleResource> resources = null;
    @JsonProperty("pagination")
    public void setPagination(@Nullable Pagination pagination) {
      this.pagination = pagination;
    }
    @JsonProperty("resources")
    public void setResources(@Nullable List<RoleResource> resources) {
      this.resources = resources;
    }
    @Override
    public Pagination getPagination() { throw new UnsupportedOperationException(); }
    @Override
    public List<RoleResource> getResources() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ListRolesResponse fromJson(Json json) {
    ListRolesResponse.Builder builder = ListRolesResponse.builder();
    if (json.pagination != null) {
      builder.pagination(json.pagination);
    }
    if (json.resources != null) {
      builder.addAllResources(json.resources);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ListRolesResponse ListRolesResponse}.
   * <pre>
   * ListRolesResponse.builder()
   *    .pagination(org.cloudfoundry.client.v3.Pagination | null) // nullable {@link ListRolesResponse#getPagination() pagination}
   *    .resources(List&amp;lt;org.cloudfoundry.client.v3.roles.RoleResource&amp;gt; | null) // nullable {@link ListRolesResponse#getResources() resources}
   *    .build();
   * </pre>
   * @return A new ListRolesResponse builder
   */
  public static ListRolesResponse.Builder builder() {
    return new ListRolesResponse.Builder();
  }

  /**
   * Builds instances of type {@link ListRolesResponse ListRolesResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListRolesResponse", generator = "Immutables")
  public static final class Builder {
    private Pagination pagination;
    private List<RoleResource> resources = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListRolesResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListRolesResponse instance) {
      return from((_ListRolesResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ListRolesResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListRolesResponse instance) {
      Objects.requireNonNull(instance, "instance");
      Pagination paginationValue = instance.getPagination();
      if (paginationValue != null) {
        pagination(paginationValue);
      }
      List<RoleResource> resourcesValue = instance.getResources();
      if (resourcesValue != null) {
        addAllResources(resourcesValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListRolesResponse#getPagination() pagination} attribute.
     * @param pagination The value for pagination (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("pagination")
    public final Builder pagination(@Nullable Pagination pagination) {
      this.pagination = pagination;
      return this;
    }

    /**
     * Adds one element to {@link ListRolesResponse#getResources() resources} list.
     * @param element A resources element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resource(RoleResource element) {
      if (this.resources == null) {
        this.resources = new ArrayList<RoleResource>();
      }
      this.resources.add(Objects.requireNonNull(element, "resources element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRolesResponse#getResources() resources} list.
     * @param elements An array of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resources(RoleResource... elements) {
      if (this.resources == null) {
        this.resources = new ArrayList<RoleResource>();
      }
      for (RoleResource element : elements) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRolesResponse#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("resources")
    public final Builder resources(@Nullable Iterable<? extends RoleResource> elements) {
      if (elements == null) {
        this.resources = null;
        return this;
      }
      this.resources = new ArrayList<RoleResource>();
      return addAllResources(elements);
    }

    /**
     * Adds elements to {@link ListRolesResponse#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllResources(Iterable<? extends RoleResource> elements) {
      Objects.requireNonNull(elements, "resources element");
      if (this.resources == null) {
        this.resources = new ArrayList<RoleResource>();
      }
      for (RoleResource element : elements) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListRolesResponse ListRolesResponse}.
     * @return An immutable instance of ListRolesResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListRolesResponse build() {
      return new ListRolesResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
