package org.cloudfoundry.client.v3.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Insert Route Destinations operation
 */
@Generated(from = "_InsertRouteDestinationsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class InsertRouteDestinationsRequest
    extends org.cloudfoundry.client.v3.routes._InsertRouteDestinationsRequest {
  private final List<Destination> destinations;
  private final String routeId;

  private InsertRouteDestinationsRequest(InsertRouteDestinationsRequest.Builder builder) {
    this.destinations = createUnmodifiableList(true, builder.destinations);
    this.routeId = builder.routeId;
  }

  /**
   * The destinations to add to the route
   */
  @JsonProperty("destinations")
  @Override
  public List<Destination> getDestinations() {
    return destinations;
  }

  /**
   * The route id
   */
  @JsonProperty("routeId")
  @JsonIgnore
  @Override
  public String getRouteId() {
    return routeId;
  }

  /**
   * This instance is equal to all instances of {@code InsertRouteDestinationsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof InsertRouteDestinationsRequest
        && equalTo((InsertRouteDestinationsRequest) another);
  }

  private boolean equalTo(InsertRouteDestinationsRequest another) {
    return destinations.equals(another.destinations)
        && routeId.equals(another.routeId);
  }

  /**
   * Computes a hash code from attributes: {@code destinations}, {@code routeId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + destinations.hashCode();
    h += (h << 5) + routeId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InsertRouteDestinationsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InsertRouteDestinationsRequest{"
        + "destinations=" + destinations
        + ", routeId=" + routeId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_InsertRouteDestinationsRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.routes._InsertRouteDestinationsRequest {
    List<Destination> destinations = Collections.emptyList();
    String routeId;
    @JsonProperty("destinations")
    public void setDestinations(List<Destination> destinations) {
      this.destinations = destinations;
    }
    @JsonProperty("routeId")
    @JsonIgnore
    public void setRouteId(String routeId) {
      this.routeId = routeId;
    }
    @Override
    public List<Destination> getDestinations() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouteId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static InsertRouteDestinationsRequest fromJson(Json json) {
    InsertRouteDestinationsRequest.Builder builder = InsertRouteDestinationsRequest.builder();
    if (json.destinations != null) {
      builder.addAllDestinations(json.destinations);
    }
    if (json.routeId != null) {
      builder.routeId(json.routeId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link InsertRouteDestinationsRequest InsertRouteDestinationsRequest}.
   * <pre>
   * InsertRouteDestinationsRequest.builder()
   *    .destination|addAllDestinations(org.cloudfoundry.client.v3.routes.Destination) // {@link InsertRouteDestinationsRequest#getDestinations() destinations} elements
   *    .routeId(String) // required {@link InsertRouteDestinationsRequest#getRouteId() routeId}
   *    .build();
   * </pre>
   * @return A new InsertRouteDestinationsRequest builder
   */
  public static InsertRouteDestinationsRequest.Builder builder() {
    return new InsertRouteDestinationsRequest.Builder();
  }

  /**
   * Builds instances of type {@link InsertRouteDestinationsRequest InsertRouteDestinationsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_InsertRouteDestinationsRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ROUTE_ID = 0x1L;
    private long initBits = 0x1L;

    private List<Destination> destinations = new ArrayList<Destination>();
    private String routeId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InsertRouteDestinationsRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InsertRouteDestinationsRequest instance) {
      return from((_InsertRouteDestinationsRequest) instance);
    }

    /**
     * Copy abstract value type {@code _InsertRouteDestinationsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_InsertRouteDestinationsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      addAllDestinations(instance.getDestinations());
      routeId(instance.getRouteId());
      return this;
    }

    /**
     * Adds one element to {@link InsertRouteDestinationsRequest#getDestinations() destinations} list.
     * @param element A destinations element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder destination(Destination element) {
      this.destinations.add(Objects.requireNonNull(element, "destinations element"));
      return this;
    }

    /**
     * Adds elements to {@link InsertRouteDestinationsRequest#getDestinations() destinations} list.
     * @param elements An array of destinations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder destinations(Destination... elements) {
      for (Destination element : elements) {
        this.destinations.add(Objects.requireNonNull(element, "destinations element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link InsertRouteDestinationsRequest#getDestinations() destinations} list.
     * @param elements An iterable of destinations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder destinations(Iterable<? extends Destination> elements) {
      this.destinations.clear();
      return addAllDestinations(elements);
    }

    /**
     * Adds elements to {@link InsertRouteDestinationsRequest#getDestinations() destinations} list.
     * @param elements An iterable of destinations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDestinations(Iterable<? extends Destination> elements) {
      for (Destination element : elements) {
        this.destinations.add(Objects.requireNonNull(element, "destinations element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link InsertRouteDestinationsRequest#getRouteId() routeId} attribute.
     * @param routeId The value for routeId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeId(String routeId) {
      this.routeId = Objects.requireNonNull(routeId, "routeId");
      initBits &= ~INIT_BIT_ROUTE_ID;
      return this;
    }

    /**
     * Builds a new {@link InsertRouteDestinationsRequest InsertRouteDestinationsRequest}.
     * @return An immutable instance of InsertRouteDestinationsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public InsertRouteDestinationsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new InsertRouteDestinationsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ROUTE_ID) != 0) attributes.add("routeId");
      return "Cannot build InsertRouteDestinationsRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
