package org.cloudfoundry.client.v3.serviceofferings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.immutables.value.Generated;

/**
 * The Resource response payload for the List Service Offerings operation
 */
@Generated(from = "_ServiceOfferingResource", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ServiceOfferingResource
    extends org.cloudfoundry.client.v3.serviceofferings._ServiceOfferingResource {
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final @Nullable String updatedAt;
  private final Boolean available;
  private final BrokerCatalog brokerCatalog;
  private final String description;
  private final String documentationUrl;
  private final @Nullable Metadata metadata;
  private final String name;
  private final @Nullable ServiceOfferingRelationships relationships;
  private final @Nullable List<String> requires;
  private final Boolean shareable;
  private final @Nullable List<String> tags;

  private ServiceOfferingResource(ServiceOfferingResource.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
    this.available = builder.available;
    this.brokerCatalog = builder.brokerCatalog;
    this.description = builder.description;
    this.documentationUrl = builder.documentationUrl;
    this.metadata = builder.metadata;
    this.name = builder.name;
    this.relationships = builder.relationships;
    this.requires = builder.requires == null ? null : createUnmodifiableList(true, builder.requires);
    this.shareable = builder.shareable;
    this.tags = builder.tags == null ? null : createUnmodifiableList(true, builder.tags);
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * Whether the service offering is available
   */
  @JsonProperty("available")
  @Override
  public Boolean getAvailable() {
    return available;
  }

  /**
   * The broker catalog
   */
  @JsonProperty("broker_catalog")
  @Override
  public BrokerCatalog getBrokerCatalog() {
    return brokerCatalog;
  }

  /**
   * The description
   */
  @JsonProperty("description")
  @Override
  public String getDescription() {
    return description;
  }

  /**
   * The documentation url
   */
  @JsonProperty("documentation_url")
  @Override
  public String getDocumentationUrl() {
    return documentationUrl;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public @Nullable ServiceOfferingRelationships getRelationships() {
    return relationships;
  }

  /**
   * A list of permissions that the user would have to give the service
   */
  @JsonProperty("requires")
  @Override
  public @Nullable List<String> getRequires() {
    return requires;
  }

  /**
   * Whether or not service instances of this service offering can be shared across organizations and spaces
   */
  @JsonProperty("shareable")
  @Override
  public Boolean getShareable() {
    return shareable;
  }

  /**
   * A list of tags for the service offering
   */
  @JsonProperty("tags")
  @Override
  public @Nullable List<String> getTags() {
    return tags;
  }

  /**
   * This instance is equal to all instances of {@code ServiceOfferingResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceOfferingResource
        && equalTo((ServiceOfferingResource) another);
  }

  private boolean equalTo(ServiceOfferingResource another) {
    return createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && Objects.equals(updatedAt, another.updatedAt)
        && available.equals(another.available)
        && brokerCatalog.equals(another.brokerCatalog)
        && description.equals(another.description)
        && documentationUrl.equals(another.documentationUrl)
        && Objects.equals(metadata, another.metadata)
        && name.equals(another.name)
        && Objects.equals(relationships, another.relationships)
        && Objects.equals(requires, another.requires)
        && shareable.equals(another.shareable)
        && Objects.equals(tags, another.tags);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}, {@code available}, {@code brokerCatalog}, {@code description}, {@code documentationUrl}, {@code metadata}, {@code name}, {@code relationships}, {@code requires}, {@code shareable}, {@code tags}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + available.hashCode();
    h += (h << 5) + brokerCatalog.hashCode();
    h += (h << 5) + description.hashCode();
    h += (h << 5) + documentationUrl.hashCode();
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(relationships);
    h += (h << 5) + Objects.hashCode(requires);
    h += (h << 5) + shareable.hashCode();
    h += (h << 5) + Objects.hashCode(tags);
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceOfferingResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceOfferingResource{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + ", available=" + available
        + ", brokerCatalog=" + brokerCatalog
        + ", description=" + description
        + ", documentationUrl=" + documentationUrl
        + ", metadata=" + metadata
        + ", name=" + name
        + ", relationships=" + relationships
        + ", requires=" + requires
        + ", shareable=" + shareable
        + ", tags=" + tags
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ServiceOfferingResource", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.serviceofferings._ServiceOfferingResource {
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    Boolean available;
    BrokerCatalog brokerCatalog;
    String description;
    String documentationUrl;
    Metadata metadata;
    String name;
    ServiceOfferingRelationships relationships;
    List<String> requires = null;
    Boolean shareable;
    List<String> tags = null;
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("available")
    public void setAvailable(Boolean available) {
      this.available = available;
    }
    @JsonProperty("broker_catalog")
    public void setBrokerCatalog(BrokerCatalog brokerCatalog) {
      this.brokerCatalog = brokerCatalog;
    }
    @JsonProperty("description")
    public void setDescription(String description) {
      this.description = description;
    }
    @JsonProperty("documentation_url")
    public void setDocumentationUrl(String documentationUrl) {
      this.documentationUrl = documentationUrl;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("relationships")
    public void setRelationships(@Nullable ServiceOfferingRelationships relationships) {
      this.relationships = relationships;
    }
    @JsonProperty("requires")
    public void setRequires(@Nullable List<String> requires) {
      this.requires = requires;
    }
    @JsonProperty("shareable")
    public void setShareable(Boolean shareable) {
      this.shareable = shareable;
    }
    @JsonProperty("tags")
    public void setTags(@Nullable List<String> tags) {
      this.tags = tags;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getAvailable() { throw new UnsupportedOperationException(); }
    @Override
    public BrokerCatalog getBrokerCatalog() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getDocumentationUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public ServiceOfferingRelationships getRelationships() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getRequires() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getShareable() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getTags() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ServiceOfferingResource fromJson(Json json) {
    ServiceOfferingResource.Builder builder = ServiceOfferingResource.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.available != null) {
      builder.available(json.available);
    }
    if (json.brokerCatalog != null) {
      builder.brokerCatalog(json.brokerCatalog);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.documentationUrl != null) {
      builder.documentationUrl(json.documentationUrl);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    if (json.requires != null) {
      builder.addAllRequires(json.requires);
    }
    if (json.shareable != null) {
      builder.shareable(json.shareable);
    }
    if (json.tags != null) {
      builder.addAllTags(json.tags);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ServiceOfferingResource ServiceOfferingResource}.
   * <pre>
   * ServiceOfferingResource.builder()
   *    .createdAt(String) // required {@link ServiceOfferingResource#getCreatedAt() createdAt}
   *    .id(String) // required {@link ServiceOfferingResource#getId() id}
   *    .link|putAllLinks(String =&gt; org.cloudfoundry.client.v3.Link) // {@link ServiceOfferingResource#getLinks() links} mappings
   *    .updatedAt(String | null) // nullable {@link ServiceOfferingResource#getUpdatedAt() updatedAt}
   *    .available(Boolean) // required {@link ServiceOfferingResource#getAvailable() available}
   *    .brokerCatalog(org.cloudfoundry.client.v3.serviceofferings.BrokerCatalog) // required {@link ServiceOfferingResource#getBrokerCatalog() brokerCatalog}
   *    .description(String) // required {@link ServiceOfferingResource#getDescription() description}
   *    .documentationUrl(String) // required {@link ServiceOfferingResource#getDocumentationUrl() documentationUrl}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link ServiceOfferingResource#getMetadata() metadata}
   *    .name(String) // required {@link ServiceOfferingResource#getName() name}
   *    .relationships(org.cloudfoundry.client.v3.serviceofferings.ServiceOfferingRelationships | null) // nullable {@link ServiceOfferingResource#getRelationships() relationships}
   *    .requires(List&amp;lt;String&amp;gt; | null) // nullable {@link ServiceOfferingResource#getRequires() requires}
   *    .shareable(Boolean) // required {@link ServiceOfferingResource#getShareable() shareable}
   *    .tags(List&amp;lt;String&amp;gt; | null) // nullable {@link ServiceOfferingResource#getTags() tags}
   *    .build();
   * </pre>
   * @return A new ServiceOfferingResource builder
   */
  public static ServiceOfferingResource.Builder builder() {
    return new ServiceOfferingResource.Builder();
  }

  /**
   * Builds instances of type {@link ServiceOfferingResource ServiceOfferingResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ServiceOfferingResource", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_AVAILABLE = 0x4L;
    private static final long INIT_BIT_BROKER_CATALOG = 0x8L;
    private static final long INIT_BIT_DESCRIPTION = 0x10L;
    private static final long INIT_BIT_DOCUMENTATION_URL = 0x20L;
    private static final long INIT_BIT_NAME = 0x40L;
    private static final long INIT_BIT_SHAREABLE = 0x80L;
    private long initBits = 0xffL;

    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;
    private Boolean available;
    private BrokerCatalog brokerCatalog;
    private String description;
    private String documentationUrl;
    private Metadata metadata;
    private String name;
    private ServiceOfferingRelationships relationships;
    private List<String> requires = null;
    private Boolean shareable;
    private List<String> tags = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.serviceofferings.ServiceOffering} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceOffering instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceOfferingResource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceOfferingResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ServiceOfferingResource} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ServiceOfferingResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ServiceOffering) {
        ServiceOffering instance = (ServiceOffering) object;
        shareable(instance.getShareable());
        documentationUrl(instance.getDocumentationUrl());
        ServiceOfferingRelationships relationshipsValue = instance.getRelationships();
        if (relationshipsValue != null) {
          relationships(relationshipsValue);
        }
        Metadata metadataValue = instance.getMetadata();
        if (metadataValue != null) {
          metadata(metadataValue);
        }
        available(instance.getAvailable());
        name(instance.getName());
        description(instance.getDescription());
        brokerCatalog(instance.getBrokerCatalog());
        List<String> tagsValue = instance.getTags();
        if (tagsValue != null) {
          addAllTags(tagsValue);
        }
        List<String> requiresValue = instance.getRequires();
        if (requiresValue != null) {
          addAllRequires(requiresValue);
        }
      }
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        createdAt(instance.getCreatedAt());
        putAllLinks(instance.getLinks());
        id(instance.getId());
        String updatedAtValue = instance.getUpdatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ServiceOfferingResource#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceOfferingResource#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link ServiceOfferingResource#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ServiceOfferingResource#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ServiceOfferingResource#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ServiceOfferingResource#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceOfferingResource#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceOfferingResource#getAvailable() available} attribute.
     * @param available The value for available 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("available")
    public final Builder available(Boolean available) {
      this.available = Objects.requireNonNull(available, "available");
      initBits &= ~INIT_BIT_AVAILABLE;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceOfferingResource#getBrokerCatalog() brokerCatalog} attribute.
     * @param brokerCatalog The value for brokerCatalog 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("broker_catalog")
    public final Builder brokerCatalog(BrokerCatalog brokerCatalog) {
      this.brokerCatalog = Objects.requireNonNull(brokerCatalog, "brokerCatalog");
      initBits &= ~INIT_BIT_BROKER_CATALOG;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceOfferingResource#getDescription() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceOfferingResource#getDocumentationUrl() documentationUrl} attribute.
     * @param documentationUrl The value for documentationUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("documentation_url")
    public final Builder documentationUrl(String documentationUrl) {
      this.documentationUrl = Objects.requireNonNull(documentationUrl, "documentationUrl");
      initBits &= ~INIT_BIT_DOCUMENTATION_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceOfferingResource#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceOfferingResource#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceOfferingResource#getRelationships() relationships} attribute.
     * @param relationships The value for relationships (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("relationships")
    public final Builder relationships(@Nullable ServiceOfferingRelationships relationships) {
      this.relationships = relationships;
      return this;
    }

    /**
     * Adds one element to {@link ServiceOfferingResource#getRequires() requires} list.
     * @param element A requires element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder require(String element) {
      if (this.requires == null) {
        this.requires = new ArrayList<String>();
      }
      this.requires.add(Objects.requireNonNull(element, "requires element"));
      return this;
    }

    /**
     * Adds elements to {@link ServiceOfferingResource#getRequires() requires} list.
     * @param elements An array of requires elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder requires(String... elements) {
      if (this.requires == null) {
        this.requires = new ArrayList<String>();
      }
      for (String element : elements) {
        this.requires.add(Objects.requireNonNull(element, "requires element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ServiceOfferingResource#getRequires() requires} list.
     * @param elements An iterable of requires elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("requires")
    public final Builder requires(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.requires = null;
        return this;
      }
      this.requires = new ArrayList<String>();
      return addAllRequires(elements);
    }

    /**
     * Adds elements to {@link ServiceOfferingResource#getRequires() requires} list.
     * @param elements An iterable of requires elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRequires(Iterable<String> elements) {
      Objects.requireNonNull(elements, "requires element");
      if (this.requires == null) {
        this.requires = new ArrayList<String>();
      }
      for (String element : elements) {
        this.requires.add(Objects.requireNonNull(element, "requires element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceOfferingResource#getShareable() shareable} attribute.
     * @param shareable The value for shareable 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("shareable")
    public final Builder shareable(Boolean shareable) {
      this.shareable = Objects.requireNonNull(shareable, "shareable");
      initBits &= ~INIT_BIT_SHAREABLE;
      return this;
    }

    /**
     * Adds one element to {@link ServiceOfferingResource#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(String element) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      this.tags.add(Objects.requireNonNull(element, "tags element"));
      return this;
    }

    /**
     * Adds elements to {@link ServiceOfferingResource#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(String... elements) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ServiceOfferingResource#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tags")
    public final Builder tags(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.tags = null;
        return this;
      }
      this.tags = new ArrayList<String>();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link ServiceOfferingResource#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTags(Iterable<String> elements) {
      Objects.requireNonNull(elements, "tags element");
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ServiceOfferingResource ServiceOfferingResource}.
     * @return An immutable instance of ServiceOfferingResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceOfferingResource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ServiceOfferingResource(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_AVAILABLE) != 0) attributes.add("available");
      if ((initBits & INIT_BIT_BROKER_CATALOG) != 0) attributes.add("brokerCatalog");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      if ((initBits & INIT_BIT_DOCUMENTATION_URL) != 0) attributes.add("documentationUrl");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_SHAREABLE) != 0) attributes.add("shareable");
      return "Cannot build ServiceOfferingResource, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
