package org.cloudfoundry.client.v3.tasks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.immutables.value.Generated;

/**
 * The Resource response payload for the List Tasks operation
 */
@Generated(from = "_TaskResource", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class TaskResource extends org.cloudfoundry.client.v3.tasks._TaskResource {
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final @Nullable String updatedAt;
  private final @Nullable String command;
  private final Integer diskInMb;
  private final String dropletId;
  private final Integer memoryInMb;
  private final @Nullable Metadata metadata;
  private final String name;
  private final @Nullable Result result;
  private final Integer sequenceId;
  private final TaskState state;
  private final @Nullable TaskRelationships taskRelationships;

  private TaskResource(TaskResource.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
    this.command = builder.command;
    this.diskInMb = builder.diskInMb;
    this.dropletId = builder.dropletId;
    this.memoryInMb = builder.memoryInMb;
    this.metadata = builder.metadata;
    this.name = builder.name;
    this.result = builder.result;
    this.sequenceId = builder.sequenceId;
    this.state = builder.state;
    this.taskRelationships = builder.taskRelationships;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * The command that will be executed
   */
  @JsonProperty("command")
  @Override
  public @Nullable String getCommand() {
    return command;
  }

  /**
   * The amount of disk to allocate for the task in MB
   */
  @JsonProperty("disk_in_mb")
  @Override
  public Integer getDiskInMb() {
    return diskInMb;
  }

  /**
   * The id of the droplet that will be used to run the command
   */
  @JsonProperty("droplet_guid")
  @Override
  public String getDropletId() {
    return dropletId;
  }

  /**
   * The amount of memory to allocate for the task in MB
   */
  @JsonProperty("memory_in_mb")
  @Override
  public Integer getMemoryInMb() {
    return memoryInMb;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The task's name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The task result
   */
  @JsonProperty("result")
  @Override
  public @Nullable Result getResult() {
    return result;
  }

  /**
   * The user-facing id of the task
   */
  @JsonProperty("sequence_id")
  @Override
  public Integer getSequenceId() {
    return sequenceId;
  }

  /**
   * The state of the task
   */
  @JsonProperty("state")
  @Override
  public TaskState getState() {
    return state;
  }

  /**
   * The task relationships
   */
  @JsonProperty("relationships")
  @Override
  public @Nullable TaskRelationships getTaskRelationships() {
    return taskRelationships;
  }

  /**
   * This instance is equal to all instances of {@code TaskResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof TaskResource
        && equalTo((TaskResource) another);
  }

  private boolean equalTo(TaskResource another) {
    return createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(command, another.command)
        && diskInMb.equals(another.diskInMb)
        && dropletId.equals(another.dropletId)
        && memoryInMb.equals(another.memoryInMb)
        && Objects.equals(metadata, another.metadata)
        && name.equals(another.name)
        && Objects.equals(result, another.result)
        && sequenceId.equals(another.sequenceId)
        && state.equals(another.state)
        && Objects.equals(taskRelationships, another.taskRelationships);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}, {@code command}, {@code diskInMb}, {@code dropletId}, {@code memoryInMb}, {@code metadata}, {@code name}, {@code result}, {@code sequenceId}, {@code state}, {@code taskRelationships}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(command);
    h += (h << 5) + diskInMb.hashCode();
    h += (h << 5) + dropletId.hashCode();
    h += (h << 5) + memoryInMb.hashCode();
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(result);
    h += (h << 5) + sequenceId.hashCode();
    h += (h << 5) + state.hashCode();
    h += (h << 5) + Objects.hashCode(taskRelationships);
    return h;
  }

  /**
   * Prints the immutable value {@code TaskResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TaskResource{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + ", command=" + command
        + ", diskInMb=" + diskInMb
        + ", dropletId=" + dropletId
        + ", memoryInMb=" + memoryInMb
        + ", metadata=" + metadata
        + ", name=" + name
        + ", result=" + result
        + ", sequenceId=" + sequenceId
        + ", state=" + state
        + ", taskRelationships=" + taskRelationships
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_TaskResource", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.tasks._TaskResource {
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    String command;
    Integer diskInMb;
    String dropletId;
    Integer memoryInMb;
    Metadata metadata;
    String name;
    Result result;
    Integer sequenceId;
    TaskState state;
    TaskRelationships taskRelationships;
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("command")
    public void setCommand(@Nullable String command) {
      this.command = command;
    }
    @JsonProperty("disk_in_mb")
    public void setDiskInMb(Integer diskInMb) {
      this.diskInMb = diskInMb;
    }
    @JsonProperty("droplet_guid")
    public void setDropletId(String dropletId) {
      this.dropletId = dropletId;
    }
    @JsonProperty("memory_in_mb")
    public void setMemoryInMb(Integer memoryInMb) {
      this.memoryInMb = memoryInMb;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("result")
    public void setResult(@Nullable Result result) {
      this.result = result;
    }
    @JsonProperty("sequence_id")
    public void setSequenceId(Integer sequenceId) {
      this.sequenceId = sequenceId;
    }
    @JsonProperty("state")
    public void setState(TaskState state) {
      this.state = state;
    }
    @JsonProperty("relationships")
    public void setTaskRelationships(@Nullable TaskRelationships taskRelationships) {
      this.taskRelationships = taskRelationships;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getCommand() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getDiskInMb() { throw new UnsupportedOperationException(); }
    @Override
    public String getDropletId() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemoryInMb() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Result getResult() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getSequenceId() { throw new UnsupportedOperationException(); }
    @Override
    public TaskState getState() { throw new UnsupportedOperationException(); }
    @Override
    public TaskRelationships getTaskRelationships() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static TaskResource fromJson(Json json) {
    TaskResource.Builder builder = TaskResource.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.command != null) {
      builder.command(json.command);
    }
    if (json.diskInMb != null) {
      builder.diskInMb(json.diskInMb);
    }
    if (json.dropletId != null) {
      builder.dropletId(json.dropletId);
    }
    if (json.memoryInMb != null) {
      builder.memoryInMb(json.memoryInMb);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.result != null) {
      builder.result(json.result);
    }
    if (json.sequenceId != null) {
      builder.sequenceId(json.sequenceId);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.taskRelationships != null) {
      builder.taskRelationships(json.taskRelationships);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link TaskResource TaskResource}.
   * <pre>
   * TaskResource.builder()
   *    .createdAt(String) // required {@link TaskResource#getCreatedAt() createdAt}
   *    .id(String) // required {@link TaskResource#getId() id}
   *    .link|putAllLinks(String =&gt; org.cloudfoundry.client.v3.Link) // {@link TaskResource#getLinks() links} mappings
   *    .updatedAt(String | null) // nullable {@link TaskResource#getUpdatedAt() updatedAt}
   *    .command(String | null) // nullable {@link TaskResource#getCommand() command}
   *    .diskInMb(Integer) // required {@link TaskResource#getDiskInMb() diskInMb}
   *    .dropletId(String) // required {@link TaskResource#getDropletId() dropletId}
   *    .memoryInMb(Integer) // required {@link TaskResource#getMemoryInMb() memoryInMb}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link TaskResource#getMetadata() metadata}
   *    .name(String) // required {@link TaskResource#getName() name}
   *    .result(org.cloudfoundry.client.v3.tasks.Result | null) // nullable {@link TaskResource#getResult() result}
   *    .sequenceId(Integer) // required {@link TaskResource#getSequenceId() sequenceId}
   *    .state(org.cloudfoundry.client.v3.tasks.TaskState) // required {@link TaskResource#getState() state}
   *    .taskRelationships(org.cloudfoundry.client.v3.tasks.TaskRelationships | null) // nullable {@link TaskResource#getTaskRelationships() taskRelationships}
   *    .build();
   * </pre>
   * @return A new TaskResource builder
   */
  public static TaskResource.Builder builder() {
    return new TaskResource.Builder();
  }

  /**
   * Builds instances of type {@link TaskResource TaskResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_TaskResource", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_DISK_IN_MB = 0x4L;
    private static final long INIT_BIT_DROPLET_ID = 0x8L;
    private static final long INIT_BIT_MEMORY_IN_MB = 0x10L;
    private static final long INIT_BIT_NAME = 0x20L;
    private static final long INIT_BIT_SEQUENCE_ID = 0x40L;
    private static final long INIT_BIT_STATE = 0x80L;
    private long initBits = 0xffL;

    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;
    private String command;
    private Integer diskInMb;
    private String dropletId;
    private Integer memoryInMb;
    private Metadata metadata;
    private String name;
    private Result result;
    private Integer sequenceId;
    private TaskState state;
    private TaskRelationships taskRelationships;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.tasks.Task} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Task instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code TaskResource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TaskResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _TaskResource} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_TaskResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        createdAt(instance.getCreatedAt());
        putAllLinks(instance.getLinks());
        id(instance.getId());
        String updatedAtValue = instance.getUpdatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
      if (object instanceof Task) {
        Task instance = (Task) object;
        diskInMb(instance.getDiskInMb());
        Result resultValue = instance.getResult();
        if (resultValue != null) {
          result(resultValue);
        }
        Metadata metadataValue = instance.getMetadata();
        if (metadataValue != null) {
          metadata(metadataValue);
        }
        dropletId(instance.getDropletId());
        memoryInMb(instance.getMemoryInMb());
        name(instance.getName());
        state(instance.getState());
        sequenceId(instance.getSequenceId());
        TaskRelationships taskRelationshipsValue = instance.getTaskRelationships();
        if (taskRelationshipsValue != null) {
          taskRelationships(taskRelationshipsValue);
        }
        String commandValue = instance.getCommand();
        if (commandValue != null) {
          command(commandValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link TaskResource#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link TaskResource#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link TaskResource#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link TaskResource#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link TaskResource#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link TaskResource#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link TaskResource#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link TaskResource#getCommand() command} attribute.
     * @param command The value for command (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("command")
    public final Builder command(@Nullable String command) {
      this.command = command;
      return this;
    }

    /**
     * Initializes the value for the {@link TaskResource#getDiskInMb() diskInMb} attribute.
     * @param diskInMb The value for diskInMb 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("disk_in_mb")
    public final Builder diskInMb(Integer diskInMb) {
      this.diskInMb = Objects.requireNonNull(diskInMb, "diskInMb");
      initBits &= ~INIT_BIT_DISK_IN_MB;
      return this;
    }

    /**
     * Initializes the value for the {@link TaskResource#getDropletId() dropletId} attribute.
     * @param dropletId The value for dropletId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("droplet_guid")
    public final Builder dropletId(String dropletId) {
      this.dropletId = Objects.requireNonNull(dropletId, "dropletId");
      initBits &= ~INIT_BIT_DROPLET_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link TaskResource#getMemoryInMb() memoryInMb} attribute.
     * @param memoryInMb The value for memoryInMb 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("memory_in_mb")
    public final Builder memoryInMb(Integer memoryInMb) {
      this.memoryInMb = Objects.requireNonNull(memoryInMb, "memoryInMb");
      initBits &= ~INIT_BIT_MEMORY_IN_MB;
      return this;
    }

    /**
     * Initializes the value for the {@link TaskResource#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link TaskResource#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link TaskResource#getResult() result} attribute.
     * @param result The value for result (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("result")
    public final Builder result(@Nullable Result result) {
      this.result = result;
      return this;
    }

    /**
     * Initializes the value for the {@link TaskResource#getSequenceId() sequenceId} attribute.
     * @param sequenceId The value for sequenceId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("sequence_id")
    public final Builder sequenceId(Integer sequenceId) {
      this.sequenceId = Objects.requireNonNull(sequenceId, "sequenceId");
      initBits &= ~INIT_BIT_SEQUENCE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link TaskResource#getState() state} attribute.
     * @param state The value for state 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("state")
    public final Builder state(TaskState state) {
      this.state = Objects.requireNonNull(state, "state");
      initBits &= ~INIT_BIT_STATE;
      return this;
    }

    /**
     * Initializes the value for the {@link TaskResource#getTaskRelationships() taskRelationships} attribute.
     * @param taskRelationships The value for taskRelationships (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("relationships")
    public final Builder taskRelationships(@Nullable TaskRelationships taskRelationships) {
      this.taskRelationships = taskRelationships;
      return this;
    }

    /**
     * Builds a new {@link TaskResource TaskResource}.
     * @return An immutable instance of TaskResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public TaskResource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new TaskResource(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_DISK_IN_MB) != 0) attributes.add("diskInMb");
      if ((initBits & INIT_BIT_DROPLET_ID) != 0) attributes.add("dropletId");
      if ((initBits & INIT_BIT_MEMORY_IN_MB) != 0) attributes.add("memoryInMb");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_SEQUENCE_ID) != 0) attributes.add("sequenceId");
      if ((initBits & INIT_BIT_STATE) != 0) attributes.add("state");
      return "Cannot build TaskResource, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
