package org.cloudfoundry.routing.v1.tcproutes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The response payload for the List TCP Routes operation
 */
@Generated(from = "_ListTcpRoutesResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListTcpRoutesResponse extends org.cloudfoundry.routing.v1.tcproutes._ListTcpRoutesResponse {
  private final List<TcpRoute> tcpRoutes;

  private ListTcpRoutesResponse(ListTcpRoutesResponse.Builder builder) {
    this.tcpRoutes = createUnmodifiableList(true, builder.tcpRoutes);
  }

  /**
   * The TCP Routes
   */
  @JsonProperty("tcpRoutes")
  @Override
  public List<TcpRoute> getTcpRoutes() {
    return tcpRoutes;
  }

  /**
   * This instance is equal to all instances of {@code ListTcpRoutesResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListTcpRoutesResponse
        && equalTo((ListTcpRoutesResponse) another);
  }

  private boolean equalTo(ListTcpRoutesResponse another) {
    return tcpRoutes.equals(another.tcpRoutes);
  }

  /**
   * Computes a hash code from attributes: {@code tcpRoutes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + tcpRoutes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListTcpRoutesResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListTcpRoutesResponse{"
        + "tcpRoutes=" + tcpRoutes
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ListTcpRoutesResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.routing.v1.tcproutes._ListTcpRoutesResponse {
    List<TcpRoute> tcpRoutes = Collections.emptyList();
    @JsonProperty("tcpRoutes")
    public void setTcpRoutes(List<TcpRoute> tcpRoutes) {
      this.tcpRoutes = tcpRoutes;
    }
    @Override
    public List<TcpRoute> getTcpRoutes() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ListTcpRoutesResponse fromJson(Json json) {
    ListTcpRoutesResponse.Builder builder = ListTcpRoutesResponse.builder();
    if (json.tcpRoutes != null) {
      builder.addAllTcpRoutes(json.tcpRoutes);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ListTcpRoutesResponse ListTcpRoutesResponse}.
   * <pre>
   * ListTcpRoutesResponse.builder()
   *    .tcpRoute|addAllTcpRoutes(org.cloudfoundry.routing.v1.tcproutes.TcpRoute) // {@link ListTcpRoutesResponse#getTcpRoutes() tcpRoutes} elements
   *    .build();
   * </pre>
   * @return A new ListTcpRoutesResponse builder
   */
  public static ListTcpRoutesResponse.Builder builder() {
    return new ListTcpRoutesResponse.Builder();
  }

  /**
   * Builds instances of type {@link ListTcpRoutesResponse ListTcpRoutesResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListTcpRoutesResponse", generator = "Immutables")
  public static final class Builder {
    private List<TcpRoute> tcpRoutes = new ArrayList<TcpRoute>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListTcpRoutesResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListTcpRoutesResponse instance) {
      return from((_ListTcpRoutesResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ListTcpRoutesResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListTcpRoutesResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllTcpRoutes(instance.getTcpRoutes());
      return this;
    }

    /**
     * Adds one element to {@link ListTcpRoutesResponse#getTcpRoutes() tcpRoutes} list.
     * @param element A tcpRoutes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tcpRoute(TcpRoute element) {
      this.tcpRoutes.add(Objects.requireNonNull(element, "tcpRoutes element"));
      return this;
    }

    /**
     * Adds elements to {@link ListTcpRoutesResponse#getTcpRoutes() tcpRoutes} list.
     * @param elements An array of tcpRoutes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tcpRoutes(TcpRoute... elements) {
      for (TcpRoute element : elements) {
        this.tcpRoutes.add(Objects.requireNonNull(element, "tcpRoutes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListTcpRoutesResponse#getTcpRoutes() tcpRoutes} list.
     * @param elements An iterable of tcpRoutes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tcpRoutes")
    public final Builder tcpRoutes(Iterable<? extends TcpRoute> elements) {
      this.tcpRoutes.clear();
      return addAllTcpRoutes(elements);
    }

    /**
     * Adds elements to {@link ListTcpRoutesResponse#getTcpRoutes() tcpRoutes} list.
     * @param elements An iterable of tcpRoutes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTcpRoutes(Iterable<? extends TcpRoute> elements) {
      for (TcpRoute element : elements) {
        this.tcpRoutes.add(Objects.requireNonNull(element, "tcpRoutes element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListTcpRoutesResponse ListTcpRoutesResponse}.
     * @return An immutable instance of ListTcpRoutesResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListTcpRoutesResponse build() {
      return new ListTcpRoutesResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
