package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.immutables.value.Generated;

/**
 * The request payload for the Batch Update Clients operation
 */
@Generated(from = "_BatchUpdateClientsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class BatchUpdateClientsRequest extends org.cloudfoundry.uaa.clients._BatchUpdateClientsRequest {
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;
  private final List<UpdateClient> clients;

  private BatchUpdateClientsRequest(BatchUpdateClientsRequest.Builder builder) {
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
    this.clients = createUnmodifiableList(true, builder.clients);
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @JsonProperty("identityZoneId")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @JsonProperty("identityZoneSubdomain")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * A list of clients to update
   */
  @JsonProperty("clients")
  @JsonIgnore
  @Override
  public List<UpdateClient> getClients() {
    return clients;
  }

  /**
   * This instance is equal to all instances of {@code BatchUpdateClientsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BatchUpdateClientsRequest
        && equalTo((BatchUpdateClientsRequest) another);
  }

  private boolean equalTo(BatchUpdateClientsRequest another) {
    return Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain)
        && clients.equals(another.clients);
  }

  /**
   * Computes a hash code from attributes: {@code identityZoneId}, {@code identityZoneSubdomain}, {@code clients}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    h += (h << 5) + clients.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BatchUpdateClientsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BatchUpdateClientsRequest{"
        + "identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + ", clients=" + clients
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_BatchUpdateClientsRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.clients._BatchUpdateClientsRequest {
    String identityZoneId;
    String identityZoneSubdomain;
    List<UpdateClient> clients = Collections.emptyList();
    @JsonProperty("identityZoneId")
    @JsonIgnore
    public void setIdentityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @JsonProperty("identityZoneSubdomain")
    @JsonIgnore
    public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
    }
    @JsonProperty("clients")
    @JsonIgnore
    public void setClients(List<UpdateClient> clients) {
      this.clients = clients;
    }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneSubdomain() { throw new UnsupportedOperationException(); }
    @Override
    public List<UpdateClient> getClients() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static BatchUpdateClientsRequest fromJson(Json json) {
    BatchUpdateClientsRequest.Builder builder = BatchUpdateClientsRequest.builder();
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    if (json.identityZoneSubdomain != null) {
      builder.identityZoneSubdomain(json.identityZoneSubdomain);
    }
    if (json.clients != null) {
      builder.addAllClients(json.clients);
    }
    return builder.build();
  }

  private static BatchUpdateClientsRequest validate(BatchUpdateClientsRequest instance) {
    instance.checkClients();
    return instance;
  }

  /**
   * Creates a builder for {@link BatchUpdateClientsRequest BatchUpdateClientsRequest}.
   * <pre>
   * BatchUpdateClientsRequest.builder()
   *    .identityZoneId(String | null) // nullable {@link BatchUpdateClientsRequest#getIdentityZoneId() identityZoneId}
   *    .identityZoneSubdomain(String | null) // nullable {@link BatchUpdateClientsRequest#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .client|addAllClients(org.cloudfoundry.uaa.clients.UpdateClient) // {@link BatchUpdateClientsRequest#getClients() clients} elements
   *    .build();
   * </pre>
   * @return A new BatchUpdateClientsRequest builder
   */
  public static BatchUpdateClientsRequest.Builder builder() {
    return new BatchUpdateClientsRequest.Builder();
  }

  /**
   * Builds instances of type {@link BatchUpdateClientsRequest BatchUpdateClientsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_BatchUpdateClientsRequest", generator = "Immutables")
  public static final class Builder {
    private String identityZoneId;
    private String identityZoneSubdomain;
    private List<UpdateClient> clients = new ArrayList<UpdateClient>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code BatchUpdateClientsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BatchUpdateClientsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _BatchUpdateClientsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_BatchUpdateClientsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.clients._BatchUpdateClientsRequest) {
        org.cloudfoundry.uaa.clients._BatchUpdateClientsRequest instance = (org.cloudfoundry.uaa.clients._BatchUpdateClientsRequest) object;
        addAllClients(instance.getClients());
      }
    }

    /**
     * Initializes the value for the {@link BatchUpdateClientsRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link BatchUpdateClientsRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Adds one element to {@link BatchUpdateClientsRequest#getClients() clients} list.
     * @param element A clients element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder client(UpdateClient element) {
      this.clients.add(Objects.requireNonNull(element, "clients element"));
      return this;
    }

    /**
     * Adds elements to {@link BatchUpdateClientsRequest#getClients() clients} list.
     * @param elements An array of clients elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clients(UpdateClient... elements) {
      for (UpdateClient element : elements) {
        this.clients.add(Objects.requireNonNull(element, "clients element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BatchUpdateClientsRequest#getClients() clients} list.
     * @param elements An iterable of clients elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clients(Iterable<? extends UpdateClient> elements) {
      this.clients.clear();
      return addAllClients(elements);
    }

    /**
     * Adds elements to {@link BatchUpdateClientsRequest#getClients() clients} list.
     * @param elements An iterable of clients elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllClients(Iterable<? extends UpdateClient> elements) {
      for (UpdateClient element : elements) {
        this.clients.add(Objects.requireNonNull(element, "clients element"));
      }
      return this;
    }

    /**
     * Builds a new {@link BatchUpdateClientsRequest BatchUpdateClientsRequest}.
     * @return An immutable instance of BatchUpdateClientsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BatchUpdateClientsRequest build() {
      return BatchUpdateClientsRequest.validate(new BatchUpdateClientsRequest(this));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
