package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.Versioned;
import org.immutables.value.Generated;

/**
 * The request payload for the update group
 */
@Generated(from = "_UpdateGroupRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateGroupRequest extends org.cloudfoundry.uaa.groups._UpdateGroupRequest {
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;
  private final String version;
  private final @Nullable String description;
  private final String displayName;
  private final String groupId;
  private final List<MemberSummary> members;

  private UpdateGroupRequest(UpdateGroupRequest.Builder builder) {
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
    this.version = builder.version;
    this.description = builder.description;
    this.displayName = builder.displayName;
    this.groupId = builder.groupId;
    this.members = createUnmodifiableList(true, builder.members);
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @JsonProperty("identityZoneId")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @JsonProperty("identityZoneSubdomain")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * The version
   */
  @JsonProperty("version")
  @JsonIgnore
  @Override
  public String getVersion() {
    return version;
  }

  /**
   * Human readable description of the group, displayed e.g. when approving scopes
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The identifier specified upon creation of the group, unique within the identity zone
   */
  @JsonProperty("displayName")
  @Override
  public String getDisplayName() {
    return displayName;
  }

  /**
   * The group id
   */
  @JsonProperty("groupId")
  @JsonIgnore
  @Override
  public String getGroupId() {
    return groupId;
  }

  /**
   * Array of group members
   */
  @JsonProperty("members")
  @Override
  public List<MemberSummary> getMembers() {
    return members;
  }

  /**
   * This instance is equal to all instances of {@code UpdateGroupRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateGroupRequest
        && equalTo((UpdateGroupRequest) another);
  }

  private boolean equalTo(UpdateGroupRequest another) {
    return Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain)
        && version.equals(another.version)
        && Objects.equals(description, another.description)
        && displayName.equals(another.displayName)
        && groupId.equals(another.groupId)
        && members.equals(another.members);
  }

  /**
   * Computes a hash code from attributes: {@code identityZoneId}, {@code identityZoneSubdomain}, {@code version}, {@code description}, {@code displayName}, {@code groupId}, {@code members}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    h += (h << 5) + version.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + displayName.hashCode();
    h += (h << 5) + groupId.hashCode();
    h += (h << 5) + members.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateGroupRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateGroupRequest{"
        + "identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + ", version=" + version
        + ", description=" + description
        + ", displayName=" + displayName
        + ", groupId=" + groupId
        + ", members=" + members
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateGroupRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.groups._UpdateGroupRequest {
    String identityZoneId;
    String identityZoneSubdomain;
    String version;
    String description;
    String displayName;
    String groupId;
    List<MemberSummary> members = Collections.emptyList();
    @JsonProperty("identityZoneId")
    @JsonIgnore
    public void setIdentityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @JsonProperty("identityZoneSubdomain")
    @JsonIgnore
    public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
    }
    @JsonProperty("version")
    @JsonIgnore
    public void setVersion(String version) {
      this.version = version;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
      this.displayName = displayName;
    }
    @JsonProperty("groupId")
    @JsonIgnore
    public void setGroupId(String groupId) {
      this.groupId = groupId;
    }
    @JsonProperty("members")
    public void setMembers(List<MemberSummary> members) {
      this.members = members;
    }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneSubdomain() { throw new UnsupportedOperationException(); }
    @Override
    public String getVersion() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getDisplayName() { throw new UnsupportedOperationException(); }
    @Override
    public String getGroupId() { throw new UnsupportedOperationException(); }
    @Override
    public List<MemberSummary> getMembers() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateGroupRequest fromJson(Json json) {
    UpdateGroupRequest.Builder builder = UpdateGroupRequest.builder();
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    if (json.identityZoneSubdomain != null) {
      builder.identityZoneSubdomain(json.identityZoneSubdomain);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.displayName != null) {
      builder.displayName(json.displayName);
    }
    if (json.groupId != null) {
      builder.groupId(json.groupId);
    }
    if (json.members != null) {
      builder.addAllMembers(json.members);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateGroupRequest UpdateGroupRequest}.
   * <pre>
   * UpdateGroupRequest.builder()
   *    .identityZoneId(String | null) // nullable {@link UpdateGroupRequest#getIdentityZoneId() identityZoneId}
   *    .identityZoneSubdomain(String | null) // nullable {@link UpdateGroupRequest#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .version(String) // required {@link UpdateGroupRequest#getVersion() version}
   *    .description(String | null) // nullable {@link UpdateGroupRequest#getDescription() description}
   *    .displayName(String) // required {@link UpdateGroupRequest#getDisplayName() displayName}
   *    .groupId(String) // required {@link UpdateGroupRequest#getGroupId() groupId}
   *    .member|addAllMembers(org.cloudfoundry.uaa.groups.MemberSummary) // {@link UpdateGroupRequest#getMembers() members} elements
   *    .build();
   * </pre>
   * @return A new UpdateGroupRequest builder
   */
  public static UpdateGroupRequest.Builder builder() {
    return new UpdateGroupRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateGroupRequest UpdateGroupRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateGroupRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_VERSION = 0x1L;
    private static final long INIT_BIT_DISPLAY_NAME = 0x2L;
    private static final long INIT_BIT_GROUP_ID = 0x4L;
    private long initBits = 0x7L;

    private String identityZoneId;
    private String identityZoneSubdomain;
    private String version;
    private String description;
    private String displayName;
    private String groupId;
    private List<MemberSummary> members = new ArrayList<MemberSummary>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateGroupRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UpdateGroupRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_UpdateGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.Versioned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Versioned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.groups._UpdateGroupRequest) {
        org.cloudfoundry.uaa.groups._UpdateGroupRequest instance = (org.cloudfoundry.uaa.groups._UpdateGroupRequest) object;
        String descriptionValue = instance.getDescription();
        if (descriptionValue != null) {
          description(descriptionValue);
        }
        if ((bits & 0x1L) == 0) {
          String versionValue = instance.getVersion();
          if (versionValue != null) {
            version(versionValue);
          }
          bits |= 0x1L;
        }
        displayName(instance.getDisplayName());
        groupId(instance.getGroupId());
        addAllMembers(instance.getMembers());
      }
      if (object instanceof Versioned) {
        Versioned instance = (Versioned) object;
        if ((bits & 0x1L) == 0) {
          String versionValue = instance.getVersion();
          if (versionValue != null) {
            version(versionValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link UpdateGroupRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateGroupRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateGroupRequest#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateGroupRequest#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateGroupRequest#getDisplayName() displayName} attribute.
     * @param displayName The value for displayName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder displayName(String displayName) {
      this.displayName = Objects.requireNonNull(displayName, "displayName");
      initBits &= ~INIT_BIT_DISPLAY_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateGroupRequest#getGroupId() groupId} attribute.
     * @param groupId The value for groupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupId(String groupId) {
      this.groupId = Objects.requireNonNull(groupId, "groupId");
      initBits &= ~INIT_BIT_GROUP_ID;
      return this;
    }

    /**
     * Adds one element to {@link UpdateGroupRequest#getMembers() members} list.
     * @param element A members element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder member(MemberSummary element) {
      this.members.add(Objects.requireNonNull(element, "members element"));
      return this;
    }

    /**
     * Adds elements to {@link UpdateGroupRequest#getMembers() members} list.
     * @param elements An array of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder members(MemberSummary... elements) {
      for (MemberSummary element : elements) {
        this.members.add(Objects.requireNonNull(element, "members element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateGroupRequest#getMembers() members} list.
     * @param elements An iterable of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder members(Iterable<? extends MemberSummary> elements) {
      this.members.clear();
      return addAllMembers(elements);
    }

    /**
     * Adds elements to {@link UpdateGroupRequest#getMembers() members} list.
     * @param elements An iterable of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMembers(Iterable<? extends MemberSummary> elements) {
      for (MemberSummary element : elements) {
        this.members.add(Objects.requireNonNull(element, "members element"));
      }
      return this;
    }

    /**
     * Builds a new {@link UpdateGroupRequest UpdateGroupRequest}.
     * @return An immutable instance of UpdateGroupRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateGroupRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateGroupRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_DISPLAY_NAME) != 0) attributes.add("displayName");
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      return "Cannot build UpdateGroupRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
