package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The response from the list identity zones request
 */
@Generated(from = "_ListIdentityZonesResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListIdentityZonesResponse
    extends org.cloudfoundry.uaa.identityzones._ListIdentityZonesResponse {
  private final List<IdentityZone> identityZones;

  private ListIdentityZonesResponse(ListIdentityZonesResponse.Builder builder) {
    this.identityZones = createUnmodifiableList(true, builder.identityZones);
  }

  /**
   * The identity zones
   */
  @JsonProperty("identityZones")
  @Override
  public List<IdentityZone> getIdentityZones() {
    return identityZones;
  }

  /**
   * This instance is equal to all instances of {@code ListIdentityZonesResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListIdentityZonesResponse
        && equalTo((ListIdentityZonesResponse) another);
  }

  private boolean equalTo(ListIdentityZonesResponse another) {
    return identityZones.equals(another.identityZones);
  }

  /**
   * Computes a hash code from attributes: {@code identityZones}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + identityZones.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListIdentityZonesResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListIdentityZonesResponse{"
        + "identityZones=" + identityZones
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ListIdentityZonesResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._ListIdentityZonesResponse {
    List<IdentityZone> identityZones = Collections.emptyList();
    @JsonProperty("identityZones")
    public void setIdentityZones(List<IdentityZone> identityZones) {
      this.identityZones = identityZones;
    }
    @Override
    public List<IdentityZone> getIdentityZones() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ListIdentityZonesResponse fromJson(Json json) {
    ListIdentityZonesResponse.Builder builder = ListIdentityZonesResponse.builder();
    if (json.identityZones != null) {
      builder.addAllIdentityZones(json.identityZones);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ListIdentityZonesResponse ListIdentityZonesResponse}.
   * <pre>
   * ListIdentityZonesResponse.builder()
   *    .identityZone|addAllIdentityZones(org.cloudfoundry.uaa.identityzones.IdentityZone) // {@link ListIdentityZonesResponse#getIdentityZones() identityZones} elements
   *    .build();
   * </pre>
   * @return A new ListIdentityZonesResponse builder
   */
  public static ListIdentityZonesResponse.Builder builder() {
    return new ListIdentityZonesResponse.Builder();
  }

  /**
   * Builds instances of type {@link ListIdentityZonesResponse ListIdentityZonesResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListIdentityZonesResponse", generator = "Immutables")
  public static final class Builder {
    private List<IdentityZone> identityZones = new ArrayList<IdentityZone>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListIdentityZonesResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListIdentityZonesResponse instance) {
      return from((_ListIdentityZonesResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ListIdentityZonesResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListIdentityZonesResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllIdentityZones(instance.getIdentityZones());
      return this;
    }

    /**
     * Adds one element to {@link ListIdentityZonesResponse#getIdentityZones() identityZones} list.
     * @param element A identityZones element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZone(IdentityZone element) {
      this.identityZones.add(Objects.requireNonNull(element, "identityZones element"));
      return this;
    }

    /**
     * Adds elements to {@link ListIdentityZonesResponse#getIdentityZones() identityZones} list.
     * @param elements An array of identityZones elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZones(IdentityZone... elements) {
      for (IdentityZone element : elements) {
        this.identityZones.add(Objects.requireNonNull(element, "identityZones element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListIdentityZonesResponse#getIdentityZones() identityZones} list.
     * @param elements An iterable of identityZones elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("identityZones")
    public final Builder identityZones(Iterable<? extends IdentityZone> elements) {
      this.identityZones.clear();
      return addAllIdentityZones(elements);
    }

    /**
     * Adds elements to {@link ListIdentityZonesResponse#getIdentityZones() identityZones} list.
     * @param elements An iterable of identityZones elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllIdentityZones(Iterable<? extends IdentityZone> elements) {
      for (IdentityZone element : elements) {
        this.identityZones.add(Objects.requireNonNull(element, "identityZones element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListIdentityZonesResponse ListIdentityZonesResponse}.
     * @return An immutable instance of ListIdentityZonesResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListIdentityZonesResponse build() {
      return new ListIdentityZonesResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
