package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _User}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code User.builder()}.
 */
@Generated(from = "_User", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class User extends org.cloudfoundry.uaa.users._User {
  private final String id;
  private final String origin;
  private final String userName;
  private final Boolean active;
  private final List<Email> email;
  private final @Nullable Long lastLogonTime;
  private final Meta meta;
  private final Name name;
  private final String passwordLastModified;
  private final List<PhoneNumber> phoneNumbers;
  private final @Nullable Long previousLoginTime;
  private final List<String> schemas;
  private final Boolean verified;
  private final String zoneId;
  private final List<Approval> approvals;
  private final @Nullable String externalId;
  private final List<Group> groups;

  private User(User.Builder builder) {
    this.id = builder.id;
    this.origin = builder.origin;
    this.userName = builder.userName;
    this.active = builder.active;
    this.email = createUnmodifiableList(true, builder.email);
    this.lastLogonTime = builder.lastLogonTime;
    this.meta = builder.meta;
    this.name = builder.name;
    this.passwordLastModified = builder.passwordLastModified;
    this.phoneNumbers = createUnmodifiableList(true, builder.phoneNumbers);
    this.previousLoginTime = builder.previousLoginTime;
    this.schemas = createUnmodifiableList(true, builder.schemas);
    this.verified = builder.verified;
    this.zoneId = builder.zoneId;
    this.approvals = createUnmodifiableList(true, builder.approvals);
    this.externalId = builder.externalId;
    this.groups = createUnmodifiableList(true, builder.groups);
  }

  /**
   * The id
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * The identity provider that authenticated this user
   */
  @JsonProperty("origin")
  @Override
  public String getOrigin() {
    return origin;
  }

  /**
   * The user name
   */
  @JsonProperty("userName")
  @Override
  public String getUserName() {
    return userName;
  }

  /**
   * Whether the user is active
   */
  @JsonProperty("active")
  @Override
  public Boolean getActive() {
    return active;
  }

  /**
   * The emails for the user
   */
  @JsonProperty("emails")
  @Override
  public List<Email> getEmail() {
    return email;
  }

  /**
   * The unix epoch timestamp of when the user last authenticated
   */
  @JsonProperty("lastLogonTime")
  @Override
  public @Nullable Long getLastLogonTime() {
    return lastLogonTime;
  }

  /**
   * Metadata for the result
   */
  @JsonProperty("meta")
  @Override
  public Meta getMeta() {
    return meta;
  }

  /**
   * The user's name
   */
  @JsonProperty("name")
  @Override
  public Name getName() {
    return name;
  }

  /**
   * The timestamp when the user's password was last modified
   */
  @JsonProperty("passwordLastModified")
  @Override
  public String getPasswordLastModified() {
    return passwordLastModified;
  }

  /**
   * The phone numbers for the user
   */
  @JsonProperty("phoneNumbers")
  @Override
  public List<PhoneNumber> getPhoneNumbers() {
    return phoneNumbers;
  }

  /**
   * The unix epoch timestamp of when the user last authenticated
   */
  @JsonProperty("previousLogonTime")
  @Override
  public @Nullable Long getPreviousLoginTime() {
    return previousLoginTime;
  }

  /**
   * The schemas
   */
  @JsonProperty("schemas")
  @Override
  public List<String> getSchemas() {
    return schemas;
  }

  /**
   * Whether the user's email is verified
   */
  @JsonProperty("verified")
  @Override
  public Boolean getVerified() {
    return verified;
  }

  /**
   * The zone id the user belongs to
   */
  @JsonProperty("zoneId")
  @Override
  public String getZoneId() {
    return zoneId;
  }

  /**
   * The approvals for the user
   */
  @JsonProperty("approvals")
  @Override
  public List<Approval> getApprovals() {
    return approvals;
  }

  /**
   * The external id
   */
  @JsonProperty("externalId")
  @Override
  public @Nullable String getExternalId() {
    return externalId;
  }

  /**
   * The groups for the user
   */
  @JsonProperty("groups")
  @Override
  public List<Group> getGroups() {
    return groups;
  }

  /**
   * This instance is equal to all instances of {@code User} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof User
        && equalTo((User) another);
  }

  private boolean equalTo(User another) {
    return id.equals(another.id)
        && origin.equals(another.origin)
        && userName.equals(another.userName)
        && active.equals(another.active)
        && email.equals(another.email)
        && Objects.equals(lastLogonTime, another.lastLogonTime)
        && meta.equals(another.meta)
        && name.equals(another.name)
        && passwordLastModified.equals(another.passwordLastModified)
        && phoneNumbers.equals(another.phoneNumbers)
        && Objects.equals(previousLoginTime, another.previousLoginTime)
        && schemas.equals(another.schemas)
        && verified.equals(another.verified)
        && zoneId.equals(another.zoneId)
        && approvals.equals(another.approvals)
        && Objects.equals(externalId, another.externalId)
        && groups.equals(another.groups);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code origin}, {@code userName}, {@code active}, {@code email}, {@code lastLogonTime}, {@code meta}, {@code name}, {@code passwordLastModified}, {@code phoneNumbers}, {@code previousLoginTime}, {@code schemas}, {@code verified}, {@code zoneId}, {@code approvals}, {@code externalId}, {@code groups}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + origin.hashCode();
    h += (h << 5) + userName.hashCode();
    h += (h << 5) + active.hashCode();
    h += (h << 5) + email.hashCode();
    h += (h << 5) + Objects.hashCode(lastLogonTime);
    h += (h << 5) + meta.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + passwordLastModified.hashCode();
    h += (h << 5) + phoneNumbers.hashCode();
    h += (h << 5) + Objects.hashCode(previousLoginTime);
    h += (h << 5) + schemas.hashCode();
    h += (h << 5) + verified.hashCode();
    h += (h << 5) + zoneId.hashCode();
    h += (h << 5) + approvals.hashCode();
    h += (h << 5) + Objects.hashCode(externalId);
    h += (h << 5) + groups.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code User} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "User{"
        + "id=" + id
        + ", origin=" + origin
        + ", userName=" + userName
        + ", active=" + active
        + ", email=" + email
        + ", lastLogonTime=" + lastLogonTime
        + ", meta=" + meta
        + ", name=" + name
        + ", passwordLastModified=" + passwordLastModified
        + ", phoneNumbers=" + phoneNumbers
        + ", previousLoginTime=" + previousLoginTime
        + ", schemas=" + schemas
        + ", verified=" + verified
        + ", zoneId=" + zoneId
        + ", approvals=" + approvals
        + ", externalId=" + externalId
        + ", groups=" + groups
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_User", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.users._User {
    String id;
    String origin;
    String userName;
    Boolean active;
    List<Email> email = Collections.emptyList();
    Long lastLogonTime;
    Meta meta;
    Name name;
    String passwordLastModified;
    List<PhoneNumber> phoneNumbers = Collections.emptyList();
    Long previousLoginTime;
    List<String> schemas = Collections.emptyList();
    Boolean verified;
    String zoneId;
    List<Approval> approvals = Collections.emptyList();
    String externalId;
    List<Group> groups = Collections.emptyList();
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("origin")
    public void setOrigin(String origin) {
      this.origin = origin;
    }
    @JsonProperty("userName")
    public void setUserName(String userName) {
      this.userName = userName;
    }
    @JsonProperty("active")
    public void setActive(Boolean active) {
      this.active = active;
    }
    @JsonProperty("emails")
    public void setEmail(List<Email> email) {
      this.email = email;
    }
    @JsonProperty("lastLogonTime")
    public void setLastLogonTime(@Nullable Long lastLogonTime) {
      this.lastLogonTime = lastLogonTime;
    }
    @JsonProperty("meta")
    public void setMeta(Meta meta) {
      this.meta = meta;
    }
    @JsonProperty("name")
    public void setName(Name name) {
      this.name = name;
    }
    @JsonProperty("passwordLastModified")
    public void setPasswordLastModified(String passwordLastModified) {
      this.passwordLastModified = passwordLastModified;
    }
    @JsonProperty("phoneNumbers")
    public void setPhoneNumbers(List<PhoneNumber> phoneNumbers) {
      this.phoneNumbers = phoneNumbers;
    }
    @JsonProperty("previousLogonTime")
    public void setPreviousLoginTime(@Nullable Long previousLoginTime) {
      this.previousLoginTime = previousLoginTime;
    }
    @JsonProperty("schemas")
    public void setSchemas(List<String> schemas) {
      this.schemas = schemas;
    }
    @JsonProperty("verified")
    public void setVerified(Boolean verified) {
      this.verified = verified;
    }
    @JsonProperty("zoneId")
    public void setZoneId(String zoneId) {
      this.zoneId = zoneId;
    }
    @JsonProperty("approvals")
    public void setApprovals(List<Approval> approvals) {
      this.approvals = approvals;
    }
    @JsonProperty("externalId")
    public void setExternalId(@Nullable String externalId) {
      this.externalId = externalId;
    }
    @JsonProperty("groups")
    public void setGroups(List<Group> groups) {
      this.groups = groups;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrigin() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserName() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getActive() { throw new UnsupportedOperationException(); }
    @Override
    public List<Email> getEmail() { throw new UnsupportedOperationException(); }
    @Override
    public Long getLastLogonTime() { throw new UnsupportedOperationException(); }
    @Override
    public Meta getMeta() { throw new UnsupportedOperationException(); }
    @Override
    public Name getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getPasswordLastModified() { throw new UnsupportedOperationException(); }
    @Override
    public List<PhoneNumber> getPhoneNumbers() { throw new UnsupportedOperationException(); }
    @Override
    public Long getPreviousLoginTime() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSchemas() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getVerified() { throw new UnsupportedOperationException(); }
    @Override
    public String getZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public List<Approval> getApprovals() { throw new UnsupportedOperationException(); }
    @Override
    public String getExternalId() { throw new UnsupportedOperationException(); }
    @Override
    public List<Group> getGroups() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static User fromJson(Json json) {
    User.Builder builder = User.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.origin != null) {
      builder.origin(json.origin);
    }
    if (json.userName != null) {
      builder.userName(json.userName);
    }
    if (json.active != null) {
      builder.active(json.active);
    }
    if (json.email != null) {
      builder.addAllEmail(json.email);
    }
    if (json.lastLogonTime != null) {
      builder.lastLogonTime(json.lastLogonTime);
    }
    if (json.meta != null) {
      builder.meta(json.meta);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.passwordLastModified != null) {
      builder.passwordLastModified(json.passwordLastModified);
    }
    if (json.phoneNumbers != null) {
      builder.addAllPhoneNumbers(json.phoneNumbers);
    }
    if (json.previousLoginTime != null) {
      builder.previousLoginTime(json.previousLoginTime);
    }
    if (json.schemas != null) {
      builder.addAllSchemas(json.schemas);
    }
    if (json.verified != null) {
      builder.verified(json.verified);
    }
    if (json.zoneId != null) {
      builder.zoneId(json.zoneId);
    }
    if (json.approvals != null) {
      builder.addAllApprovals(json.approvals);
    }
    if (json.externalId != null) {
      builder.externalId(json.externalId);
    }
    if (json.groups != null) {
      builder.addAllGroups(json.groups);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link User User}.
   * <pre>
   * User.builder()
   *    .id(String) // required {@link User#getId() id}
   *    .origin(String) // required {@link User#getOrigin() origin}
   *    .userName(String) // required {@link User#getUserName() userName}
   *    .active(Boolean) // required {@link User#getActive() active}
   *    .email|addAllEmail(org.cloudfoundry.uaa.users.Email) // {@link User#getEmail() email} elements
   *    .lastLogonTime(Long | null) // nullable {@link User#getLastLogonTime() lastLogonTime}
   *    .meta(org.cloudfoundry.uaa.users.Meta) // required {@link User#getMeta() meta}
   *    .name(org.cloudfoundry.uaa.users.Name) // required {@link User#getName() name}
   *    .passwordLastModified(String) // required {@link User#getPasswordLastModified() passwordLastModified}
   *    .phoneNumber|addAllPhoneNumbers(org.cloudfoundry.uaa.users.PhoneNumber) // {@link User#getPhoneNumbers() phoneNumbers} elements
   *    .previousLoginTime(Long | null) // nullable {@link User#getPreviousLoginTime() previousLoginTime}
   *    .schema|addAllSchemas(String) // {@link User#getSchemas() schemas} elements
   *    .verified(Boolean) // required {@link User#getVerified() verified}
   *    .zoneId(String) // required {@link User#getZoneId() zoneId}
   *    .approval|addAllApprovals(org.cloudfoundry.uaa.users.Approval) // {@link User#getApprovals() approvals} elements
   *    .externalId(String | null) // nullable {@link User#getExternalId() externalId}
   *    .group|addAllGroups(org.cloudfoundry.uaa.users.Group) // {@link User#getGroups() groups} elements
   *    .build();
   * </pre>
   * @return A new User builder
   */
  public static User.Builder builder() {
    return new User.Builder();
  }

  /**
   * Builds instances of type {@link User User}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_User", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_ORIGIN = 0x2L;
    private static final long INIT_BIT_USER_NAME = 0x4L;
    private static final long INIT_BIT_ACTIVE = 0x8L;
    private static final long INIT_BIT_META = 0x10L;
    private static final long INIT_BIT_NAME = 0x20L;
    private static final long INIT_BIT_PASSWORD_LAST_MODIFIED = 0x40L;
    private static final long INIT_BIT_VERIFIED = 0x80L;
    private static final long INIT_BIT_ZONE_ID = 0x100L;
    private long initBits = 0x1ffL;

    private String id;
    private String origin;
    private String userName;
    private Boolean active;
    private List<Email> email = new ArrayList<Email>();
    private Long lastLogonTime;
    private Meta meta;
    private Name name;
    private String passwordLastModified;
    private List<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>();
    private Long previousLoginTime;
    private List<String> schemas = new ArrayList<String>();
    private Boolean verified;
    private String zoneId;
    private List<Approval> approvals = new ArrayList<Approval>();
    private String externalId;
    private List<Group> groups = new ArrayList<Group>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.users.AbstractUserSummary} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractUserSummary instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.users.AbstractUserId} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractUserId instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.users.AbstractUser} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractUser instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code User} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(User instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _User} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_User instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractUserSummary) {
        AbstractUserSummary instance = (AbstractUserSummary) object;
        Long lastLogonTimeValue = instance.getLastLogonTime();
        if (lastLogonTimeValue != null) {
          lastLogonTime(lastLogonTimeValue);
        }
        meta(instance.getMeta());
        addAllSchemas(instance.getSchemas());
        verified(instance.getVerified());
        name(instance.getName());
        active(instance.getActive());
        zoneId(instance.getZoneId());
        passwordLastModified(instance.getPasswordLastModified());
        addAllPhoneNumbers(instance.getPhoneNumbers());
        Long previousLoginTimeValue = instance.getPreviousLoginTime();
        if (previousLoginTimeValue != null) {
          previousLoginTime(previousLoginTimeValue);
        }
        addAllEmail(instance.getEmail());
      }
      if (object instanceof AbstractUserId) {
        AbstractUserId instance = (AbstractUserId) object;
        userName(instance.getUserName());
        origin(instance.getOrigin());
        id(instance.getId());
      }
      if (object instanceof AbstractUser) {
        AbstractUser instance = (AbstractUser) object;
        String externalIdValue = instance.getExternalId();
        if (externalIdValue != null) {
          externalId(externalIdValue);
        }
        addAllGroups(instance.getGroups());
        addAllApprovals(instance.getApprovals());
      }
    }

    /**
     * Initializes the value for the {@link User#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link User#getOrigin() origin} attribute.
     * @param origin The value for origin 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("origin")
    public final Builder origin(String origin) {
      this.origin = Objects.requireNonNull(origin, "origin");
      initBits &= ~INIT_BIT_ORIGIN;
      return this;
    }

    /**
     * Initializes the value for the {@link User#getUserName() userName} attribute.
     * @param userName The value for userName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("userName")
    public final Builder userName(String userName) {
      this.userName = Objects.requireNonNull(userName, "userName");
      initBits &= ~INIT_BIT_USER_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link User#getActive() active} attribute.
     * @param active The value for active 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("active")
    public final Builder active(Boolean active) {
      this.active = Objects.requireNonNull(active, "active");
      initBits &= ~INIT_BIT_ACTIVE;
      return this;
    }

    /**
     * Adds one element to {@link User#getEmail() email} list.
     * @param element A email element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(Email element) {
      this.email.add(Objects.requireNonNull(element, "email element"));
      return this;
    }

    /**
     * Adds elements to {@link User#getEmail() email} list.
     * @param elements An array of email elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(Email... elements) {
      for (Email element : elements) {
        this.email.add(Objects.requireNonNull(element, "email element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link User#getEmail() email} list.
     * @param elements An iterable of email elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("emails")
    public final Builder email(Iterable<? extends Email> elements) {
      this.email.clear();
      return addAllEmail(elements);
    }

    /**
     * Adds elements to {@link User#getEmail() email} list.
     * @param elements An iterable of email elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEmail(Iterable<? extends Email> elements) {
      for (Email element : elements) {
        this.email.add(Objects.requireNonNull(element, "email element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link User#getLastLogonTime() lastLogonTime} attribute.
     * @param lastLogonTime The value for lastLogonTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lastLogonTime")
    public final Builder lastLogonTime(@Nullable Long lastLogonTime) {
      this.lastLogonTime = lastLogonTime;
      return this;
    }

    /**
     * Initializes the value for the {@link User#getMeta() meta} attribute.
     * @param meta The value for meta 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("meta")
    public final Builder meta(Meta meta) {
      this.meta = Objects.requireNonNull(meta, "meta");
      initBits &= ~INIT_BIT_META;
      return this;
    }

    /**
     * Initializes the value for the {@link User#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(Name name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link User#getPasswordLastModified() passwordLastModified} attribute.
     * @param passwordLastModified The value for passwordLastModified 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("passwordLastModified")
    public final Builder passwordLastModified(String passwordLastModified) {
      this.passwordLastModified = Objects.requireNonNull(passwordLastModified, "passwordLastModified");
      initBits &= ~INIT_BIT_PASSWORD_LAST_MODIFIED;
      return this;
    }

    /**
     * Adds one element to {@link User#getPhoneNumbers() phoneNumbers} list.
     * @param element A phoneNumbers element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder phoneNumber(PhoneNumber element) {
      this.phoneNumbers.add(Objects.requireNonNull(element, "phoneNumbers element"));
      return this;
    }

    /**
     * Adds elements to {@link User#getPhoneNumbers() phoneNumbers} list.
     * @param elements An array of phoneNumbers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder phoneNumbers(PhoneNumber... elements) {
      for (PhoneNumber element : elements) {
        this.phoneNumbers.add(Objects.requireNonNull(element, "phoneNumbers element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link User#getPhoneNumbers() phoneNumbers} list.
     * @param elements An iterable of phoneNumbers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("phoneNumbers")
    public final Builder phoneNumbers(Iterable<? extends PhoneNumber> elements) {
      this.phoneNumbers.clear();
      return addAllPhoneNumbers(elements);
    }

    /**
     * Adds elements to {@link User#getPhoneNumbers() phoneNumbers} list.
     * @param elements An iterable of phoneNumbers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPhoneNumbers(Iterable<? extends PhoneNumber> elements) {
      for (PhoneNumber element : elements) {
        this.phoneNumbers.add(Objects.requireNonNull(element, "phoneNumbers element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link User#getPreviousLoginTime() previousLoginTime} attribute.
     * @param previousLoginTime The value for previousLoginTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("previousLogonTime")
    public final Builder previousLoginTime(@Nullable Long previousLoginTime) {
      this.previousLoginTime = previousLoginTime;
      return this;
    }

    /**
     * Adds one element to {@link User#getSchemas() schemas} list.
     * @param element A schemas element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schema(String element) {
      this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      return this;
    }

    /**
     * Adds elements to {@link User#getSchemas() schemas} list.
     * @param elements An array of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schemas(String... elements) {
      for (String element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link User#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schemas")
    public final Builder schemas(Iterable<String> elements) {
      this.schemas.clear();
      return addAllSchemas(elements);
    }

    /**
     * Adds elements to {@link User#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSchemas(Iterable<String> elements) {
      for (String element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link User#getVerified() verified} attribute.
     * @param verified The value for verified 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("verified")
    public final Builder verified(Boolean verified) {
      this.verified = Objects.requireNonNull(verified, "verified");
      initBits &= ~INIT_BIT_VERIFIED;
      return this;
    }

    /**
     * Initializes the value for the {@link User#getZoneId() zoneId} attribute.
     * @param zoneId The value for zoneId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("zoneId")
    public final Builder zoneId(String zoneId) {
      this.zoneId = Objects.requireNonNull(zoneId, "zoneId");
      initBits &= ~INIT_BIT_ZONE_ID;
      return this;
    }

    /**
     * Adds one element to {@link User#getApprovals() approvals} list.
     * @param element A approvals element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder approval(Approval element) {
      this.approvals.add(Objects.requireNonNull(element, "approvals element"));
      return this;
    }

    /**
     * Adds elements to {@link User#getApprovals() approvals} list.
     * @param elements An array of approvals elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder approvals(Approval... elements) {
      for (Approval element : elements) {
        this.approvals.add(Objects.requireNonNull(element, "approvals element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link User#getApprovals() approvals} list.
     * @param elements An iterable of approvals elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("approvals")
    public final Builder approvals(Iterable<? extends Approval> elements) {
      this.approvals.clear();
      return addAllApprovals(elements);
    }

    /**
     * Adds elements to {@link User#getApprovals() approvals} list.
     * @param elements An iterable of approvals elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApprovals(Iterable<? extends Approval> elements) {
      for (Approval element : elements) {
        this.approvals.add(Objects.requireNonNull(element, "approvals element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link User#getExternalId() externalId} attribute.
     * @param externalId The value for externalId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("externalId")
    public final Builder externalId(@Nullable String externalId) {
      this.externalId = externalId;
      return this;
    }

    /**
     * Adds one element to {@link User#getGroups() groups} list.
     * @param element A groups element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder group(Group element) {
      this.groups.add(Objects.requireNonNull(element, "groups element"));
      return this;
    }

    /**
     * Adds elements to {@link User#getGroups() groups} list.
     * @param elements An array of groups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groups(Group... elements) {
      for (Group element : elements) {
        this.groups.add(Objects.requireNonNull(element, "groups element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link User#getGroups() groups} list.
     * @param elements An iterable of groups elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groups")
    public final Builder groups(Iterable<? extends Group> elements) {
      this.groups.clear();
      return addAllGroups(elements);
    }

    /**
     * Adds elements to {@link User#getGroups() groups} list.
     * @param elements An iterable of groups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllGroups(Iterable<? extends Group> elements) {
      for (Group element : elements) {
        this.groups.add(Objects.requireNonNull(element, "groups element"));
      }
      return this;
    }

    /**
     * Builds a new {@link User User}.
     * @return An immutable instance of User
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public User build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new User(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_ORIGIN) != 0) attributes.add("origin");
      if ((initBits & INIT_BIT_USER_NAME) != 0) attributes.add("userName");
      if ((initBits & INIT_BIT_ACTIVE) != 0) attributes.add("active");
      if ((initBits & INIT_BIT_META) != 0) attributes.add("meta");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_PASSWORD_LAST_MODIFIED) != 0) attributes.add("passwordLastModified");
      if ((initBits & INIT_BIT_VERIFIED) != 0) attributes.add("verified");
      if ((initBits & INIT_BIT_ZONE_ID) != 0) attributes.add("zoneId");
      return "Cannot build User, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
