package org.cloudfoundry.client.v2.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Events operation
 */
@Generated(from = "_ListEventsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListEventsRequest extends org.cloudfoundry.client.v2.events._ListEventsRequest {
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;
  private final @Nullable List<String> actees;
  private final @Nullable List<String> organizationIds;
  private final @Nullable List<String> spaceIds;
  private final @Nullable List<String> timestamps;
  private final @Nullable List<String> types;

  private ListEventsRequest(ListEventsRequest.Builder builder) {
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
    this.actees = builder.actees == null ? null : createUnmodifiableList(true, builder.actees);
    this.organizationIds = builder.organizationIds == null ? null : createUnmodifiableList(true, builder.organizationIds);
    this.spaceIds = builder.spaceIds == null ? null : createUnmodifiableList(true, builder.spaceIds);
    this.timestamps = builder.timestamps == null ? null : createUnmodifiableList(true, builder.timestamps);
    this.types = builder.types == null ? null : createUnmodifiableList(true, builder.types);
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * The actees
   */
  @Override
  public @Nullable List<String> getActees() {
    return actees;
  }

  /**
   * The organization ids
   */
  @Override
  public @Nullable List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * The space ids
   */
  @Override
  public @Nullable List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * The timestamps
   */
  @Override
  public @Nullable List<String> getTimestamps() {
    return timestamps;
  }

  /**
   * The types
   */
  @Override
  public @Nullable List<String> getTypes() {
    return types;
  }

  /**
   * This instance is equal to all instances of {@code ListEventsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListEventsRequest
        && equalTo((ListEventsRequest) another);
  }

  private boolean equalTo(ListEventsRequest another) {
    return Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage)
        && Objects.equals(actees, another.actees)
        && Objects.equals(organizationIds, another.organizationIds)
        && Objects.equals(spaceIds, another.spaceIds)
        && Objects.equals(timestamps, another.timestamps)
        && Objects.equals(types, another.types);
  }

  /**
   * Computes a hash code from attributes: {@code orderDirection}, {@code page}, {@code resultsPerPage}, {@code actees}, {@code organizationIds}, {@code spaceIds}, {@code timestamps}, {@code types}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    h += (h << 5) + Objects.hashCode(actees);
    h += (h << 5) + Objects.hashCode(organizationIds);
    h += (h << 5) + Objects.hashCode(spaceIds);
    h += (h << 5) + Objects.hashCode(timestamps);
    h += (h << 5) + Objects.hashCode(types);
    return h;
  }

  /**
   * Prints the immutable value {@code ListEventsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListEventsRequest{"
        + "orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + ", actees=" + actees
        + ", organizationIds=" + organizationIds
        + ", spaceIds=" + spaceIds
        + ", timestamps=" + timestamps
        + ", types=" + types
        + "}";
  }

  /**
   * Creates a builder for {@link ListEventsRequest ListEventsRequest}.
   * <pre>
   * ListEventsRequest.builder()
   *    .orderDirection(org.cloudfoundry.client.v2.OrderDirection | null) // nullable {@link ListEventsRequest#getOrderDirection() orderDirection}
   *    .page(Integer | null) // nullable {@link ListEventsRequest#getPage() page}
   *    .resultsPerPage(Integer | null) // nullable {@link ListEventsRequest#getResultsPerPage() resultsPerPage}
   *    .actees(List&amp;lt;String&amp;gt; | null) // nullable {@link ListEventsRequest#getActees() actees}
   *    .organizationIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListEventsRequest#getOrganizationIds() organizationIds}
   *    .spaceIds(List&amp;lt;String&amp;gt; | null) // nullable {@link ListEventsRequest#getSpaceIds() spaceIds}
   *    .timestamps(List&amp;lt;String&amp;gt; | null) // nullable {@link ListEventsRequest#getTimestamps() timestamps}
   *    .types(List&amp;lt;String&amp;gt; | null) // nullable {@link ListEventsRequest#getTypes() types}
   *    .build();
   * </pre>
   * @return A new ListEventsRequest builder
   */
  public static ListEventsRequest.Builder builder() {
    return new ListEventsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListEventsRequest ListEventsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListEventsRequest", generator = "Immutables")
  public static final class Builder {
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;
    private List<String> actees = null;
    private List<String> organizationIds = null;
    private List<String> spaceIds = null;
    private List<String> timestamps = null;
    private List<String> types = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListEventsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListEventsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListEventsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListEventsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v2.events._ListEventsRequest) {
        org.cloudfoundry.client.v2.events._ListEventsRequest instance = (org.cloudfoundry.client.v2.events._ListEventsRequest) object;
        List<String> typesValue = instance.getTypes();
        if (typesValue != null) {
          addAllTypes(typesValue);
        }
        List<String> spaceIdsValue = instance.getSpaceIds();
        if (spaceIdsValue != null) {
          addAllSpaceIds(spaceIdsValue);
        }
        List<String> organizationIdsValue = instance.getOrganizationIds();
        if (organizationIdsValue != null) {
          addAllOrganizationIds(organizationIdsValue);
        }
        List<String> timestampsValue = instance.getTimestamps();
        if (timestampsValue != null) {
          addAllTimestamps(timestampsValue);
        }
        List<String> acteesValue = instance.getActees();
        if (acteesValue != null) {
          addAllActees(acteesValue);
        }
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListEventsRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListEventsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListEventsRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Adds one element to {@link ListEventsRequest#getActees() actees} list.
     * @param element A actees element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder actee(String element) {
      if (this.actees == null) {
        this.actees = new ArrayList<String>();
      }
      this.actees.add(Objects.requireNonNull(element, "actees element"));
      return this;
    }

    /**
     * Adds elements to {@link ListEventsRequest#getActees() actees} list.
     * @param elements An array of actees elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder actees(String... elements) {
      if (this.actees == null) {
        this.actees = new ArrayList<String>();
      }
      for (String element : elements) {
        this.actees.add(Objects.requireNonNull(element, "actees element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListEventsRequest#getActees() actees} list.
     * @param elements An iterable of actees elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder actees(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.actees = null;
        return this;
      }
      this.actees = new ArrayList<String>();
      return addAllActees(elements);
    }

    /**
     * Adds elements to {@link ListEventsRequest#getActees() actees} list.
     * @param elements An iterable of actees elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllActees(Iterable<String> elements) {
      Objects.requireNonNull(elements, "actees element");
      if (this.actees == null) {
        this.actees = new ArrayList<String>();
      }
      for (String element : elements) {
        this.actees.add(Objects.requireNonNull(element, "actees element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListEventsRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListEventsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(String... elements) {
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListEventsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.organizationIds = null;
        return this;
      }
      this.organizationIds = new ArrayList<String>();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListEventsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "organizationIds element");
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListEventsRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListEventsRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(String... elements) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListEventsRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.spaceIds = null;
        return this;
      }
      this.spaceIds = new ArrayList<String>();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link ListEventsRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "spaceIds element");
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListEventsRequest#getTimestamps() timestamps} list.
     * @param element A timestamps element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timestamp(String element) {
      if (this.timestamps == null) {
        this.timestamps = new ArrayList<String>();
      }
      this.timestamps.add(Objects.requireNonNull(element, "timestamps element"));
      return this;
    }

    /**
     * Adds elements to {@link ListEventsRequest#getTimestamps() timestamps} list.
     * @param elements An array of timestamps elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timestamps(String... elements) {
      if (this.timestamps == null) {
        this.timestamps = new ArrayList<String>();
      }
      for (String element : elements) {
        this.timestamps.add(Objects.requireNonNull(element, "timestamps element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListEventsRequest#getTimestamps() timestamps} list.
     * @param elements An iterable of timestamps elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timestamps(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.timestamps = null;
        return this;
      }
      this.timestamps = new ArrayList<String>();
      return addAllTimestamps(elements);
    }

    /**
     * Adds elements to {@link ListEventsRequest#getTimestamps() timestamps} list.
     * @param elements An iterable of timestamps elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTimestamps(Iterable<String> elements) {
      Objects.requireNonNull(elements, "timestamps element");
      if (this.timestamps == null) {
        this.timestamps = new ArrayList<String>();
      }
      for (String element : elements) {
        this.timestamps.add(Objects.requireNonNull(element, "timestamps element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListEventsRequest#getTypes() types} list.
     * @param element A types element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(String element) {
      if (this.types == null) {
        this.types = new ArrayList<String>();
      }
      this.types.add(Objects.requireNonNull(element, "types element"));
      return this;
    }

    /**
     * Adds elements to {@link ListEventsRequest#getTypes() types} list.
     * @param elements An array of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder types(String... elements) {
      if (this.types == null) {
        this.types = new ArrayList<String>();
      }
      for (String element : elements) {
        this.types.add(Objects.requireNonNull(element, "types element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListEventsRequest#getTypes() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder types(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.types = null;
        return this;
      }
      this.types = new ArrayList<String>();
      return addAllTypes(elements);
    }

    /**
     * Adds elements to {@link ListEventsRequest#getTypes() types} list.
     * @param elements An iterable of types elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTypes(Iterable<String> elements) {
      Objects.requireNonNull(elements, "types element");
      if (this.types == null) {
        this.types = new ArrayList<String>();
      }
      for (String element : elements) {
        this.types.add(Objects.requireNonNull(element, "types element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListEventsRequest ListEventsRequest}.
     * @return An immutable instance of ListEventsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListEventsRequest build() {
      return new ListEventsRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
