package org.cloudfoundry.logcache.v1;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _Gauge}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Gauge.builder()}.
 */
@Generated(from = "_Gauge", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Gauge extends org.cloudfoundry.logcache.v1._Gauge {
  private final Map<String, Metric> metrics;

  private Gauge(Gauge.Builder builder) {
    this.metrics = createUnmodifiableMap(false, false, builder.metrics);
  }

  /**
   * The gauge metrics
   */
  @JsonProperty("metrics")
  @Override
  public Map<String, Metric> getMetrics() {
    return metrics;
  }

  /**
   * This instance is equal to all instances of {@code Gauge} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Gauge
        && equalTo((Gauge) another);
  }

  private boolean equalTo(Gauge another) {
    return metrics.equals(another.metrics);
  }

  /**
   * Computes a hash code from attributes: {@code metrics}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + metrics.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Gauge} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Gauge{"
        + "metrics=" + metrics
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Gauge", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.logcache.v1._Gauge {
    Map<String, Metric> metrics = Collections.emptyMap();
    @JsonProperty("metrics")
    public void setMetrics(Map<String, Metric> metrics) {
      this.metrics = metrics;
    }
    @Override
    public Map<String, Metric> getMetrics() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Gauge fromJson(Json json) {
    Gauge.Builder builder = Gauge.builder();
    if (json.metrics != null) {
      builder.putAllMetrics(json.metrics);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Gauge Gauge}.
   * <pre>
   * Gauge.builder()
   *    .metric|putAllMetrics(String =&gt; Metric) // {@link Gauge#getMetrics() metrics} mappings
   *    .build();
   * </pre>
   * @return A new Gauge builder
   */
  public static Gauge.Builder builder() {
    return new Gauge.Builder();
  }

  /**
   * Builds instances of type {@link Gauge Gauge}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Gauge", generator = "Immutables")
  public static final class Builder {
    private Map<String, Metric> metrics = new LinkedHashMap<String, Metric>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Gauge} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Gauge instance) {
      return from((_Gauge) instance);
    }

    /**
     * Copy abstract value type {@code _Gauge} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Gauge instance) {
      Objects.requireNonNull(instance, "instance");
      putAllMetrics(instance.getMetrics());
      return this;
    }

    /**
     * Put one entry to the {@link Gauge#getMetrics() metrics} map.
     * @param key The key in the metrics map
     * @param value The associated value in the metrics map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metric(String key, Metric value) {
      this.metrics.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Gauge#getMetrics() metrics} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metric(Map.Entry<String, ? extends Metric> entry) {
      String k = entry.getKey();
      Metric v = entry.getValue();
      this.metrics.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Gauge#getMetrics() metrics} map. Nulls are not permitted
     * @param entries The entries that will be added to the metrics map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metrics")
    public final Builder metrics(Map<String, ? extends Metric> entries) {
      this.metrics.clear();
      return putAllMetrics(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Gauge#getMetrics() metrics} map. Nulls are not permitted
     * @param entries The entries that will be added to the metrics map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllMetrics(Map<String, ? extends Metric> entries) {
      for (Map.Entry<String, ? extends Metric> e : entries.entrySet()) {
        String k = e.getKey();
        Metric v = e.getValue();
        this.metrics.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link Gauge Gauge}.
     * @return An immutable instance of Gauge
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Gauge build() {
      return new Gauge(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
