package org.cloudfoundry.logcache.v1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _ReadRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ReadRequest.builder()}.
 */
@Generated(from = "_ReadRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ReadRequest extends org.cloudfoundry.logcache.v1._ReadRequest {
  private final @Nullable Boolean descending;
  private final @Nullable Long endTime;
  private final @Nullable List<EnvelopeType> envelopeTypes;
  private final @Nullable Integer limit;
  private final @Nullable String nameFilter;
  private final String sourceId;
  private final @Nullable Long startTime;

  private ReadRequest(ReadRequest.Builder builder) {
    this.descending = builder.descending;
    this.endTime = builder.endTime;
    this.envelopeTypes = builder.envelopeTypes == null ? null : createUnmodifiableList(true, builder.envelopeTypes);
    this.limit = builder.limit;
    this.nameFilter = builder.nameFilter;
    this.sourceId = builder.sourceId;
    this.startTime = builder.startTime;
  }

  /**
   * @return The value of the {@code descending} attribute
   */
  @Override
  public @Nullable Boolean getDescending() {
    return descending;
  }

  /**
   * @return The value of the {@code endTime} attribute
   */
  @Override
  public @Nullable Long getEndTime() {
    return endTime;
  }

  /**
   * @return The value of the {@code envelopeTypes} attribute
   */
  @Override
  public @Nullable List<EnvelopeType> getEnvelopeTypes() {
    return envelopeTypes;
  }

  /**
   * @return The value of the {@code limit} attribute
   */
  @Override
  public @Nullable Integer getLimit() {
    return limit;
  }

  /**
   * @return The value of the {@code nameFilter} attribute
   */
  @Override
  public @Nullable String getNameFilter() {
    return nameFilter;
  }

  /**
   * The source id
   */
  @Override
  public String getSourceId() {
    return sourceId;
  }

  /**
   * @return The value of the {@code startTime} attribute
   */
  @Override
  public @Nullable Long getStartTime() {
    return startTime;
  }

  /**
   * This instance is equal to all instances of {@code ReadRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ReadRequest
        && equalTo((ReadRequest) another);
  }

  private boolean equalTo(ReadRequest another) {
    return Objects.equals(descending, another.descending)
        && Objects.equals(endTime, another.endTime)
        && Objects.equals(envelopeTypes, another.envelopeTypes)
        && Objects.equals(limit, another.limit)
        && Objects.equals(nameFilter, another.nameFilter)
        && sourceId.equals(another.sourceId)
        && Objects.equals(startTime, another.startTime);
  }

  /**
   * Computes a hash code from attributes: {@code descending}, {@code endTime}, {@code envelopeTypes}, {@code limit}, {@code nameFilter}, {@code sourceId}, {@code startTime}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(descending);
    h += (h << 5) + Objects.hashCode(endTime);
    h += (h << 5) + Objects.hashCode(envelopeTypes);
    h += (h << 5) + Objects.hashCode(limit);
    h += (h << 5) + Objects.hashCode(nameFilter);
    h += (h << 5) + sourceId.hashCode();
    h += (h << 5) + Objects.hashCode(startTime);
    return h;
  }

  /**
   * Prints the immutable value {@code ReadRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ReadRequest{"
        + "descending=" + descending
        + ", endTime=" + endTime
        + ", envelopeTypes=" + envelopeTypes
        + ", limit=" + limit
        + ", nameFilter=" + nameFilter
        + ", sourceId=" + sourceId
        + ", startTime=" + startTime
        + "}";
  }

  /**
   * Creates a builder for {@link ReadRequest ReadRequest}.
   * <pre>
   * ReadRequest.builder()
   *    .descending(Boolean | null) // nullable {@link ReadRequest#getDescending() descending}
   *    .endTime(Long | null) // nullable {@link ReadRequest#getEndTime() endTime}
   *    .envelopeTypes(List&amp;lt;org.cloudfoundry.logcache.v1.EnvelopeType&amp;gt; | null) // nullable {@link ReadRequest#getEnvelopeTypes() envelopeTypes}
   *    .limit(Integer | null) // nullable {@link ReadRequest#getLimit() limit}
   *    .nameFilter(String | null) // nullable {@link ReadRequest#getNameFilter() nameFilter}
   *    .sourceId(String) // required {@link ReadRequest#getSourceId() sourceId}
   *    .startTime(Long | null) // nullable {@link ReadRequest#getStartTime() startTime}
   *    .build();
   * </pre>
   * @return A new ReadRequest builder
   */
  public static ReadRequest.Builder builder() {
    return new ReadRequest.Builder();
  }

  /**
   * Builds instances of type {@link ReadRequest ReadRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ReadRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SOURCE_ID = 0x1L;
    private long initBits = 0x1L;

    private Boolean descending;
    private Long endTime;
    private List<EnvelopeType> envelopeTypes = null;
    private Integer limit;
    private String nameFilter;
    private String sourceId;
    private Long startTime;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReadRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ReadRequest instance) {
      return from((_ReadRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ReadRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ReadRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean descendingValue = instance.getDescending();
      if (descendingValue != null) {
        descending(descendingValue);
      }
      Long endTimeValue = instance.getEndTime();
      if (endTimeValue != null) {
        endTime(endTimeValue);
      }
      List<EnvelopeType> envelopeTypesValue = instance.getEnvelopeTypes();
      if (envelopeTypesValue != null) {
        addAllEnvelopeTypes(envelopeTypesValue);
      }
      Integer limitValue = instance.getLimit();
      if (limitValue != null) {
        limit(limitValue);
      }
      String nameFilterValue = instance.getNameFilter();
      if (nameFilterValue != null) {
        nameFilter(nameFilterValue);
      }
      sourceId(instance.getSourceId());
      Long startTimeValue = instance.getStartTime();
      if (startTimeValue != null) {
        startTime(startTimeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ReadRequest#getDescending() descending} attribute.
     * @param descending The value for descending (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder descending(@Nullable Boolean descending) {
      this.descending = descending;
      return this;
    }

    /**
     * Initializes the value for the {@link ReadRequest#getEndTime() endTime} attribute.
     * @param endTime The value for endTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder endTime(@Nullable Long endTime) {
      this.endTime = endTime;
      return this;
    }

    /**
     * Adds one element to {@link ReadRequest#getEnvelopeTypes() envelopeTypes} list.
     * @param element A envelopeTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder envelopeType(EnvelopeType element) {
      if (this.envelopeTypes == null) {
        this.envelopeTypes = new ArrayList<EnvelopeType>();
      }
      this.envelopeTypes.add(Objects.requireNonNull(element, "envelopeTypes element"));
      return this;
    }

    /**
     * Adds elements to {@link ReadRequest#getEnvelopeTypes() envelopeTypes} list.
     * @param elements An array of envelopeTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder envelopeTypes(EnvelopeType... elements) {
      if (this.envelopeTypes == null) {
        this.envelopeTypes = new ArrayList<EnvelopeType>();
      }
      for (EnvelopeType element : elements) {
        this.envelopeTypes.add(Objects.requireNonNull(element, "envelopeTypes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ReadRequest#getEnvelopeTypes() envelopeTypes} list.
     * @param elements An iterable of envelopeTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder envelopeTypes(@Nullable Iterable<? extends EnvelopeType> elements) {
      if (elements == null) {
        this.envelopeTypes = null;
        return this;
      }
      this.envelopeTypes = new ArrayList<EnvelopeType>();
      return addAllEnvelopeTypes(elements);
    }

    /**
     * Adds elements to {@link ReadRequest#getEnvelopeTypes() envelopeTypes} list.
     * @param elements An iterable of envelopeTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEnvelopeTypes(Iterable<? extends EnvelopeType> elements) {
      Objects.requireNonNull(elements, "envelopeTypes element");
      if (this.envelopeTypes == null) {
        this.envelopeTypes = new ArrayList<EnvelopeType>();
      }
      for (EnvelopeType element : elements) {
        this.envelopeTypes.add(Objects.requireNonNull(element, "envelopeTypes element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ReadRequest#getLimit() limit} attribute.
     * @param limit The value for limit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder limit(@Nullable Integer limit) {
      this.limit = limit;
      return this;
    }

    /**
     * Initializes the value for the {@link ReadRequest#getNameFilter() nameFilter} attribute.
     * @param nameFilter The value for nameFilter (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nameFilter(@Nullable String nameFilter) {
      this.nameFilter = nameFilter;
      return this;
    }

    /**
     * Initializes the value for the {@link ReadRequest#getSourceId() sourceId} attribute.
     * @param sourceId The value for sourceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sourceId(String sourceId) {
      this.sourceId = Objects.requireNonNull(sourceId, "sourceId");
      initBits &= ~INIT_BIT_SOURCE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ReadRequest#getStartTime() startTime} attribute.
     * @param startTime The value for startTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder startTime(@Nullable Long startTime) {
      this.startTime = startTime;
      return this;
    }

    /**
     * Builds a new {@link ReadRequest ReadRequest}.
     * @return An immutable instance of ReadRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ReadRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ReadRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SOURCE_ID) != 0) attributes.add("sourceId");
      return "Cannot build ReadRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
