package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.immutables.value.Generated;

/**
 * The request payload for the Batch Create Clients operation
 */
@Generated(from = "_BatchCreateClientsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class BatchCreateClientsRequest extends org.cloudfoundry.uaa.clients._BatchCreateClientsRequest {
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;
  private final List<CreateClient> clients;

  private BatchCreateClientsRequest(BatchCreateClientsRequest.Builder builder) {
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
    this.clients = createUnmodifiableList(true, builder.clients);
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @JsonProperty("identityZoneId")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @JsonProperty("identityZoneSubdomain")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * A list of clients to create
   */
  @JsonProperty("clients")
  @JsonIgnore
  @Override
  public List<CreateClient> getClients() {
    return clients;
  }

  /**
   * This instance is equal to all instances of {@code BatchCreateClientsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BatchCreateClientsRequest
        && equalTo((BatchCreateClientsRequest) another);
  }

  private boolean equalTo(BatchCreateClientsRequest another) {
    return Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain)
        && clients.equals(another.clients);
  }

  /**
   * Computes a hash code from attributes: {@code identityZoneId}, {@code identityZoneSubdomain}, {@code clients}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    h += (h << 5) + clients.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BatchCreateClientsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BatchCreateClientsRequest{"
        + "identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + ", clients=" + clients
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_BatchCreateClientsRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.clients._BatchCreateClientsRequest {
    String identityZoneId;
    String identityZoneSubdomain;
    List<CreateClient> clients = Collections.emptyList();
    @JsonProperty("identityZoneId")
    @JsonIgnore
    public void setIdentityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @JsonProperty("identityZoneSubdomain")
    @JsonIgnore
    public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
    }
    @JsonProperty("clients")
    @JsonIgnore
    public void setClients(List<CreateClient> clients) {
      this.clients = clients;
    }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneSubdomain() { throw new UnsupportedOperationException(); }
    @Override
    public List<CreateClient> getClients() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static BatchCreateClientsRequest fromJson(Json json) {
    BatchCreateClientsRequest.Builder builder = BatchCreateClientsRequest.builder();
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    if (json.identityZoneSubdomain != null) {
      builder.identityZoneSubdomain(json.identityZoneSubdomain);
    }
    if (json.clients != null) {
      builder.addAllClients(json.clients);
    }
    return builder.build();
  }

  private static BatchCreateClientsRequest validate(BatchCreateClientsRequest instance) {
    instance.checkClients();
    return instance;
  }

  /**
   * Creates a builder for {@link BatchCreateClientsRequest BatchCreateClientsRequest}.
   * <pre>
   * BatchCreateClientsRequest.builder()
   *    .identityZoneId(String | null) // nullable {@link BatchCreateClientsRequest#getIdentityZoneId() identityZoneId}
   *    .identityZoneSubdomain(String | null) // nullable {@link BatchCreateClientsRequest#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .client|addAllClients(CreateClient) // {@link BatchCreateClientsRequest#getClients() clients} elements
   *    .build();
   * </pre>
   * @return A new BatchCreateClientsRequest builder
   */
  public static BatchCreateClientsRequest.Builder builder() {
    return new BatchCreateClientsRequest.Builder();
  }

  /**
   * Builds instances of type {@link BatchCreateClientsRequest BatchCreateClientsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_BatchCreateClientsRequest", generator = "Immutables")
  public static final class Builder {
    private String identityZoneId;
    private String identityZoneSubdomain;
    private List<CreateClient> clients = new ArrayList<CreateClient>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code BatchCreateClientsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BatchCreateClientsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _BatchCreateClientsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_BatchCreateClientsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.clients._BatchCreateClientsRequest) {
        org.cloudfoundry.uaa.clients._BatchCreateClientsRequest instance = (org.cloudfoundry.uaa.clients._BatchCreateClientsRequest) object;
        addAllClients(instance.getClients());
      }
    }

    /**
     * Initializes the value for the {@link BatchCreateClientsRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link BatchCreateClientsRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Adds one element to {@link BatchCreateClientsRequest#getClients() clients} list.
     * @param element A clients element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder client(CreateClient element) {
      this.clients.add(Objects.requireNonNull(element, "clients element"));
      return this;
    }

    /**
     * Adds elements to {@link BatchCreateClientsRequest#getClients() clients} list.
     * @param elements An array of clients elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clients(CreateClient... elements) {
      for (CreateClient element : elements) {
        this.clients.add(Objects.requireNonNull(element, "clients element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BatchCreateClientsRequest#getClients() clients} list.
     * @param elements An iterable of clients elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clients(Iterable<? extends CreateClient> elements) {
      this.clients.clear();
      return addAllClients(elements);
    }

    /**
     * Adds elements to {@link BatchCreateClientsRequest#getClients() clients} list.
     * @param elements An iterable of clients elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllClients(Iterable<? extends CreateClient> elements) {
      for (CreateClient element : elements) {
        this.clients.add(Objects.requireNonNull(element, "clients element"));
      }
      return this;
    }

    /**
     * Builds a new {@link BatchCreateClientsRequest BatchCreateClientsRequest}.
     * @return An immutable instance of BatchCreateClientsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BatchCreateClientsRequest build() {
      return BatchCreateClientsRequest.validate(new BatchCreateClientsRequest(this));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
