package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.Metadata;
import org.immutables.value.Generated;

/**
 * The response from the create group request
 */
@Generated(from = "_CreateGroupResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateGroupResponse extends org.cloudfoundry.uaa.groups._CreateGroupResponse {
  private final @Nullable String description;
  private final String displayName;
  private final String id;
  private final List<MemberSummary> members;
  private final Metadata metadata;
  private final List<String> schemas;
  private final String zoneId;

  private CreateGroupResponse(CreateGroupResponse.Builder builder) {
    this.description = builder.description;
    this.displayName = builder.displayName;
    this.id = builder.id;
    this.members = createUnmodifiableList(true, builder.members);
    this.metadata = builder.metadata;
    this.schemas = createUnmodifiableList(true, builder.schemas);
    this.zoneId = builder.zoneId;
  }

  /**
   * Human readable description of the group, displayed e.g. when approving scopes
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The identifier specified upon creation of the group, unique within the identity zone
   */
  @JsonProperty("displayName")
  @Override
  public String getDisplayName() {
    return displayName;
  }

  /**
   * The globally unique group ID
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Array of group members
   */
  @JsonProperty("members")
  @Override
  public List<MemberSummary> getMembers() {
    return members;
  }

  /**
   * The group's metadata
   */
  @JsonProperty("meta")
  @Override
  public Metadata getMetadata() {
    return metadata;
  }

  /**
   * The group's schemas
   */
  @JsonProperty("schemas")
  @Override
  public List<String> getSchemas() {
    return schemas;
  }

  /**
   * Identifier for the identity zone to which the group belongs
   */
  @JsonProperty("zoneId")
  @Override
  public String getZoneId() {
    return zoneId;
  }

  /**
   * This instance is equal to all instances of {@code CreateGroupResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateGroupResponse
        && equalTo((CreateGroupResponse) another);
  }

  private boolean equalTo(CreateGroupResponse another) {
    return Objects.equals(description, another.description)
        && displayName.equals(another.displayName)
        && id.equals(another.id)
        && members.equals(another.members)
        && metadata.equals(another.metadata)
        && schemas.equals(another.schemas)
        && zoneId.equals(another.zoneId);
  }

  /**
   * Computes a hash code from attributes: {@code description}, {@code displayName}, {@code id}, {@code members}, {@code metadata}, {@code schemas}, {@code zoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + displayName.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + members.hashCode();
    h += (h << 5) + metadata.hashCode();
    h += (h << 5) + schemas.hashCode();
    h += (h << 5) + zoneId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateGroupResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateGroupResponse{"
        + "description=" + description
        + ", displayName=" + displayName
        + ", id=" + id
        + ", members=" + members
        + ", metadata=" + metadata
        + ", schemas=" + schemas
        + ", zoneId=" + zoneId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateGroupResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.groups._CreateGroupResponse {
    String description;
    String displayName;
    String id;
    List<MemberSummary> members = Collections.emptyList();
    Metadata metadata;
    List<String> schemas = Collections.emptyList();
    String zoneId;
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
      this.displayName = displayName;
    }
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("members")
    public void setMembers(List<MemberSummary> members) {
      this.members = members;
    }
    @JsonProperty("meta")
    public void setMetadata(Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("schemas")
    public void setSchemas(List<String> schemas) {
      this.schemas = schemas;
    }
    @JsonProperty("zoneId")
    public void setZoneId(String zoneId) {
      this.zoneId = zoneId;
    }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getDisplayName() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public List<MemberSummary> getMembers() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSchemas() { throw new UnsupportedOperationException(); }
    @Override
    public String getZoneId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateGroupResponse fromJson(Json json) {
    CreateGroupResponse.Builder builder = CreateGroupResponse.builder();
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.displayName != null) {
      builder.displayName(json.displayName);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.members != null) {
      builder.addAllMembers(json.members);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.schemas != null) {
      builder.addAllSchemas(json.schemas);
    }
    if (json.zoneId != null) {
      builder.zoneId(json.zoneId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateGroupResponse CreateGroupResponse}.
   * <pre>
   * CreateGroupResponse.builder()
   *    .description(String | null) // nullable {@link CreateGroupResponse#getDescription() description}
   *    .displayName(String) // required {@link CreateGroupResponse#getDisplayName() displayName}
   *    .id(String) // required {@link CreateGroupResponse#getId() id}
   *    .member|addAllMembers(MemberSummary) // {@link CreateGroupResponse#getMembers() members} elements
   *    .metadata(org.cloudfoundry.uaa.Metadata) // required {@link CreateGroupResponse#getMetadata() metadata}
   *    .schema|addAllSchemas(String) // {@link CreateGroupResponse#getSchemas() schemas} elements
   *    .zoneId(String) // required {@link CreateGroupResponse#getZoneId() zoneId}
   *    .build();
   * </pre>
   * @return A new CreateGroupResponse builder
   */
  public static CreateGroupResponse.Builder builder() {
    return new CreateGroupResponse.Builder();
  }

  /**
   * Builds instances of type {@link CreateGroupResponse CreateGroupResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateGroupResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DISPLAY_NAME = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_METADATA = 0x4L;
    private static final long INIT_BIT_ZONE_ID = 0x8L;
    private long initBits = 0xfL;

    private String description;
    private String displayName;
    private String id;
    private List<MemberSummary> members = new ArrayList<MemberSummary>();
    private Metadata metadata;
    private List<String> schemas = new ArrayList<String>();
    private String zoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.groups.AbstractGroup} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractGroup instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateGroupResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateGroupResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _CreateGroupResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_CreateGroupResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractGroup) {
        AbstractGroup instance = (AbstractGroup) object;
        metadata(instance.getMetadata());
        displayName(instance.getDisplayName());
        addAllMembers(instance.getMembers());
        addAllSchemas(instance.getSchemas());
        String descriptionValue = instance.getDescription();
        if (descriptionValue != null) {
          description(descriptionValue);
        }
        zoneId(instance.getZoneId());
        id(instance.getId());
      }
    }

    /**
     * Initializes the value for the {@link CreateGroupResponse#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateGroupResponse#getDisplayName() displayName} attribute.
     * @param displayName The value for displayName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("displayName")
    public final Builder displayName(String displayName) {
      this.displayName = Objects.requireNonNull(displayName, "displayName");
      initBits &= ~INIT_BIT_DISPLAY_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateGroupResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Adds one element to {@link CreateGroupResponse#getMembers() members} list.
     * @param element A members element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder member(MemberSummary element) {
      this.members.add(Objects.requireNonNull(element, "members element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateGroupResponse#getMembers() members} list.
     * @param elements An array of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder members(MemberSummary... elements) {
      for (MemberSummary element : elements) {
        this.members.add(Objects.requireNonNull(element, "members element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateGroupResponse#getMembers() members} list.
     * @param elements An iterable of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("members")
    public final Builder members(Iterable<? extends MemberSummary> elements) {
      this.members.clear();
      return addAllMembers(elements);
    }

    /**
     * Adds elements to {@link CreateGroupResponse#getMembers() members} list.
     * @param elements An iterable of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMembers(Iterable<? extends MemberSummary> elements) {
      for (MemberSummary element : elements) {
        this.members.add(Objects.requireNonNull(element, "members element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateGroupResponse#getMetadata() metadata} attribute.
     * @param metadata The value for metadata 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("meta")
    public final Builder metadata(Metadata metadata) {
      this.metadata = Objects.requireNonNull(metadata, "metadata");
      initBits &= ~INIT_BIT_METADATA;
      return this;
    }

    /**
     * Adds one element to {@link CreateGroupResponse#getSchemas() schemas} list.
     * @param element A schemas element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schema(String element) {
      this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateGroupResponse#getSchemas() schemas} list.
     * @param elements An array of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schemas(String... elements) {
      for (String element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateGroupResponse#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schemas")
    public final Builder schemas(Iterable<String> elements) {
      this.schemas.clear();
      return addAllSchemas(elements);
    }

    /**
     * Adds elements to {@link CreateGroupResponse#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSchemas(Iterable<String> elements) {
      for (String element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateGroupResponse#getZoneId() zoneId} attribute.
     * @param zoneId The value for zoneId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("zoneId")
    public final Builder zoneId(String zoneId) {
      this.zoneId = Objects.requireNonNull(zoneId, "zoneId");
      initBits &= ~INIT_BIT_ZONE_ID;
      return this;
    }

    /**
     * Builds a new {@link CreateGroupResponse CreateGroupResponse}.
     * @return An immutable instance of CreateGroupResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateGroupResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateGroupResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DISPLAY_NAME) != 0) attributes.add("displayName");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_METADATA) != 0) attributes.add("metadata");
      if ((initBits & INIT_BIT_ZONE_ID) != 0) attributes.add("zoneId");
      return "Cannot build CreateGroupResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
