/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.cloudfoundry.client.v3.applications._ScaleApplicationResponse;
import org.cloudfoundry.client.v3.processes.HealthCheck;
import org.cloudfoundry.client.v3.processes.Process;
import org.cloudfoundry.client.v3.processes.ProcessRelationships;
import org.immutables.value.Generated;

@Generated(from="_ScaleApplicationResponse", generator="Immutables")
public final class ScaleApplicationResponse
extends _ScaleApplicationResponse {
    private final String createdAt;
    private final String id;
    private final Map<String, Link> links;
    @Nullable
    private final String updatedAt;
    private final String command;
    private final Integer diskInMb;
    private final HealthCheck healthCheck;
    private final Integer instances;
    private final Integer memoryInMb;
    private final Metadata metadata;
    private final ProcessRelationships relationships;
    private final String type;

    private ScaleApplicationResponse(Builder builder) {
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.links = ScaleApplicationResponse.createUnmodifiableMap(false, false, builder.links);
        this.updatedAt = builder.updatedAt;
        this.command = builder.command;
        this.diskInMb = builder.diskInMb;
        this.healthCheck = builder.healthCheck;
        this.instances = builder.instances;
        this.memoryInMb = builder.memoryInMb;
        this.metadata = builder.metadata;
        this.relationships = builder.relationships;
        this.type = builder.type;
    }

    @Override
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="guid")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="links")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="updated_at")
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="command")
    public String getCommand() {
        return this.command;
    }

    @Override
    @JsonProperty(value="disk_in_mb")
    public Integer getDiskInMb() {
        return this.diskInMb;
    }

    @Override
    @JsonProperty(value="health_check")
    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    @Override
    @JsonProperty(value="instances")
    public Integer getInstances() {
        return this.instances;
    }

    @Override
    @JsonProperty(value="memory_in_mb")
    public Integer getMemoryInMb() {
        return this.memoryInMb;
    }

    @Override
    @JsonProperty(value="metadata")
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="relationships")
    public ProcessRelationships getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ScaleApplicationResponse && this.equalTo((ScaleApplicationResponse)another);
    }

    private boolean equalTo(ScaleApplicationResponse another) {
        return this.createdAt.equals(another.createdAt) && this.id.equals(another.id) && this.links.equals(another.links) && Objects.equals(this.updatedAt, another.updatedAt) && this.command.equals(another.command) && this.diskInMb.equals(another.diskInMb) && this.healthCheck.equals(another.healthCheck) && this.instances.equals(another.instances) && this.memoryInMb.equals(another.memoryInMb) && this.metadata.equals(another.metadata) && this.relationships.equals(another.relationships) && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + this.command.hashCode();
        h += (h << 5) + this.diskInMb.hashCode();
        h += (h << 5) + this.healthCheck.hashCode();
        h += (h << 5) + this.instances.hashCode();
        h += (h << 5) + this.memoryInMb.hashCode();
        h += (h << 5) + this.metadata.hashCode();
        h += (h << 5) + this.relationships.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "ScaleApplicationResponse{createdAt=" + this.createdAt + ", id=" + this.id + ", links=" + this.links + ", updatedAt=" + this.updatedAt + ", command=" + this.command + ", diskInMb=" + this.diskInMb + ", healthCheck=" + this.healthCheck + ", instances=" + this.instances + ", memoryInMb=" + this.memoryInMb + ", metadata=" + this.metadata + ", relationships=" + this.relationships + ", type=" + this.type + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ScaleApplicationResponse fromJson(Json json) {
        Builder builder = ScaleApplicationResponse.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.command != null) {
            builder.command(json.command);
        }
        if (json.diskInMb != null) {
            builder.diskInMb(json.diskInMb);
        }
        if (json.healthCheck != null) {
            builder.healthCheck(json.healthCheck);
        }
        if (json.instances != null) {
            builder.instances(json.instances);
        }
        if (json.memoryInMb != null) {
            builder.memoryInMb(json.memoryInMb);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.relationships != null) {
            builder.relationships(json.relationships);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_ScaleApplicationResponse", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CREATED_AT = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_COMMAND = 4L;
        private static final long INIT_BIT_DISK_IN_MB = 8L;
        private static final long INIT_BIT_HEALTH_CHECK = 16L;
        private static final long INIT_BIT_INSTANCES = 32L;
        private static final long INIT_BIT_MEMORY_IN_MB = 64L;
        private static final long INIT_BIT_METADATA = 128L;
        private static final long INIT_BIT_RELATIONSHIPS = 256L;
        private static final long INIT_BIT_TYPE = 512L;
        private long initBits = 1023L;
        private String createdAt;
        private String id;
        private Map<String, Link> links = new LinkedHashMap<String, Link>();
        private String updatedAt;
        private String command;
        private Integer diskInMb;
        private HealthCheck healthCheck;
        private Integer instances;
        private Integer memoryInMb;
        private Metadata metadata;
        private ProcessRelationships relationships;
        private String type;

        private Builder() {
        }

        public final Builder from(Process instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Resource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ScaleApplicationResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ScaleApplicationResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Resource instance;
            if (object instanceof Process) {
                instance = (Process)object;
                this.diskInMb(((Process)instance).getDiskInMb());
                this.relationships(((Process)instance).getRelationships());
                this.metadata(((Process)instance).getMetadata());
                this.instances(((Process)instance).getInstances());
                this.memoryInMb(((Process)instance).getMemoryInMb());
                this.healthCheck(((Process)instance).getHealthCheck());
                this.type(((Process)instance).getType());
                this.command(((Process)instance).getCommand());
            }
            if (object instanceof Resource) {
                instance = (Resource)object;
                this.createdAt(instance.getCreatedAt());
                this.putAllLinks(instance.getLinks());
                this.id(instance.getId());
                String updatedAtValue = instance.getUpdatedAt();
                if (updatedAtValue != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
        }

        @JsonProperty(value="created_at")
        public final Builder createdAt(String createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder link(String key, Link value) {
            this.links.put(key, value);
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(k, v);
            return this;
        }

        @JsonProperty(value="links")
        public final Builder links(Map<String, ? extends Link> entries) {
            this.links.clear();
            return this.putAllLinks(entries);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> entries) {
            for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
                String k = e.getKey();
                Link v = e.getValue();
                this.links.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="updated_at")
        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty(value="command")
        public final Builder command(String command) {
            this.command = Objects.requireNonNull(command, "command");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="disk_in_mb")
        public final Builder diskInMb(Integer diskInMb) {
            this.diskInMb = Objects.requireNonNull(diskInMb, "diskInMb");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="health_check")
        public final Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = Objects.requireNonNull(healthCheck, "healthCheck");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="instances")
        public final Builder instances(Integer instances) {
            this.instances = Objects.requireNonNull(instances, "instances");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="memory_in_mb")
        public final Builder memoryInMb(Integer memoryInMb) {
            this.memoryInMb = Objects.requireNonNull(memoryInMb, "memoryInMb");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="metadata")
        public final Builder metadata(Metadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="relationships")
        public final Builder relationships(ProcessRelationships relationships) {
            this.relationships = Objects.requireNonNull(relationships, "relationships");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public ScaleApplicationResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ScaleApplicationResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("command");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("diskInMb");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("healthCheck");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("instances");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("memoryInMb");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("metadata");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("relationships");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build ScaleApplicationResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_ScaleApplicationResponse", generator="Immutables")
    static final class Json
    extends _ScaleApplicationResponse {
        String createdAt;
        String id;
        Map<String, Link> links = Collections.emptyMap();
        String updatedAt;
        String command;
        Integer diskInMb;
        HealthCheck healthCheck;
        Integer instances;
        Integer memoryInMb;
        Metadata metadata;
        ProcessRelationships relationships;
        String type;

        Json() {
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="guid")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="links")
        public void setLinks(Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="command")
        public void setCommand(String command) {
            this.command = command;
        }

        @JsonProperty(value="disk_in_mb")
        public void setDiskInMb(Integer diskInMb) {
            this.diskInMb = diskInMb;
        }

        @JsonProperty(value="health_check")
        public void setHealthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
        }

        @JsonProperty(value="instances")
        public void setInstances(Integer instances) {
            this.instances = instances;
        }

        @JsonProperty(value="memory_in_mb")
        public void setMemoryInMb(Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(Metadata metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="relationships")
        public void setRelationships(ProcessRelationships relationships) {
            this.relationships = relationships;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCommand() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getDiskInMb() {
            throw new UnsupportedOperationException();
        }

        @Override
        public HealthCheck getHealthCheck() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getInstances() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getMemoryInMb() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProcessRelationships getRelationships() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }
    }
}

