/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.spaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.spaces._ListSpacesRequest;
import org.immutables.value.Generated;

@Generated(from="_ListSpacesRequest", generator="Immutables")
public final class ListSpacesRequest
extends _ListSpacesRequest {
    @Nullable
    private final String orderBy;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;
    private final List<String> names;
    private final List<String> organizationIds;

    private ListSpacesRequest(Builder builder) {
        this.orderBy = builder.orderBy;
        this.page = builder.page;
        this.perPage = builder.perPage;
        this.names = ListSpacesRequest.createUnmodifiableList(true, builder.names);
        this.organizationIds = ListSpacesRequest.createUnmodifiableList(true, builder.organizationIds);
    }

    @Override
    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListSpacesRequest && this.equalTo((ListSpacesRequest)another);
    }

    private boolean equalTo(ListSpacesRequest another) {
        return Objects.equals(this.orderBy, another.orderBy) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage) && this.names.equals(another.names) && this.organizationIds.equals(another.organizationIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.orderBy);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.perPage);
        h += (h << 5) + this.names.hashCode();
        h += (h << 5) + this.organizationIds.hashCode();
        return h;
    }

    public String toString() {
        return "ListSpacesRequest{orderBy=" + this.orderBy + ", page=" + this.page + ", perPage=" + this.perPage + ", names=" + this.names + ", organizationIds=" + this.organizationIds + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListSpacesRequest", generator="Immutables")
    public static final class Builder {
        private String orderBy;
        private Integer page;
        private Integer perPage;
        private List<String> names = new ArrayList<String>();
        private List<String> organizationIds = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListSpacesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ListSpacesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer perPageValue;
                instance = (PaginatedRequest)object;
                String orderByValue = instance.getOrderBy();
                if (orderByValue != null) {
                    this.orderBy(orderByValue);
                }
                if ((perPageValue = instance.getPerPage()) != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListSpacesRequest) {
                instance = (_ListSpacesRequest)object;
                this.addAllOrganizationIds(((_ListSpacesRequest)instance).getOrganizationIds());
                this.addAllNames(((_ListSpacesRequest)instance).getNames());
            }
        }

        public final Builder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public final Builder name(String element) {
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder names(String ... elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(Iterable<String> elements) {
            this.names.clear();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder organizationId(String element) {
            this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            return this;
        }

        public final Builder organizationIds(String ... elements) {
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder organizationIds(Iterable<String> elements) {
            this.organizationIds.clear();
            return this.addAllOrganizationIds(elements);
        }

        public final Builder addAllOrganizationIds(Iterable<String> elements) {
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public ListSpacesRequest build() {
            return new ListSpacesRequest(this);
        }
    }
}

