package org.cloudfoundry.client.v3.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _GetManagedServiceParametersResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GetManagedServiceParametersResponse.builder()}.
 */
@Generated(from = "_GetManagedServiceParametersResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetManagedServiceParametersResponse
    extends org.cloudfoundry.client.v3.serviceinstances._GetManagedServiceParametersResponse {
  private final Map<String, Object> parameters;

  private GetManagedServiceParametersResponse(GetManagedServiceParametersResponse.Builder builder) {
    this.parameters = createUnmodifiableMap(false, false, builder.parameters);
  }

  /**
   * 
   * @return parameters as map
   */
  @JsonProperty("parameters")
  @JsonAnyGetter
  @Override
  public Map<String, Object> getParameters() {
    return parameters;
  }

  /**
   * This instance is equal to all instances of {@code GetManagedServiceParametersResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetManagedServiceParametersResponse
        && equalTo((GetManagedServiceParametersResponse) another);
  }

  private boolean equalTo(GetManagedServiceParametersResponse another) {
    return parameters.equals(another.parameters);
  }

  /**
   * Computes a hash code from attributes: {@code parameters}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + parameters.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetManagedServiceParametersResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetManagedServiceParametersResponse{"
        + "parameters=" + parameters
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetManagedServiceParametersResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v3.serviceinstances._GetManagedServiceParametersResponse {
    final Map<String, Object> parameters = new HashMap<String, Object>();

    @JsonAnySetter
    public void setParameters(String key, Object value) {
      this.parameters.put(key, value);
    }
    @Override
    public Map<String, Object> getParameters() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetManagedServiceParametersResponse fromJson(Json json) {
    GetManagedServiceParametersResponse.Builder builder = GetManagedServiceParametersResponse.builder();
    if (json.parameters != null) {
      builder.putAllParameters(json.parameters);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetManagedServiceParametersResponse GetManagedServiceParametersResponse}.
   * <pre>
   * GetManagedServiceParametersResponse.builder()
   *    .parameter|putAllParameters(String =&gt; Object) // {@link GetManagedServiceParametersResponse#getParameters() parameters} mappings
   *    .build();
   * </pre>
   * @return A new GetManagedServiceParametersResponse builder
   */
  public static GetManagedServiceParametersResponse.Builder builder() {
    return new GetManagedServiceParametersResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetManagedServiceParametersResponse GetManagedServiceParametersResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetManagedServiceParametersResponse", generator = "Immutables")
  public static final class Builder {
    private Map<String, Object> parameters = new LinkedHashMap<String, Object>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetManagedServiceParametersResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetManagedServiceParametersResponse instance) {
      return from((_GetManagedServiceParametersResponse) instance);
    }

    /**
     * Copy abstract value type {@code _GetManagedServiceParametersResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetManagedServiceParametersResponse instance) {
      Objects.requireNonNull(instance, "instance");
      putAllParameters(instance.getParameters());
      return this;
    }

    /**
     * Put one entry to the {@link GetManagedServiceParametersResponse#getParameters() parameters} map.
     * @param key The key in the parameters map
     * @param value The associated value in the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonAnySetter
    public final Builder parameter(String key, Object value) {
      this.parameters.put(
          Objects.requireNonNull(key, "parameters key"),
          Objects.requireNonNull(value, "parameters value"));
      return this;
    }

    /**
     * Put one entry to the {@link GetManagedServiceParametersResponse#getParameters() parameters} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.parameters.put(
          Objects.requireNonNull(k, "parameters key"),
          Objects.requireNonNull(v, "parameters value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetManagedServiceParametersResponse#getParameters() parameters} map. Nulls are not permitted
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("parameters")
    public final Builder parameters(Map<String, ? extends Object> entries) {
      this.parameters.clear();
      return putAllParameters(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetManagedServiceParametersResponse#getParameters() parameters} map. Nulls are not permitted
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllParameters(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.parameters.put(
            Objects.requireNonNull(k, "parameters key"),
            Objects.requireNonNull(v, "parameters value"));
      }
      return this;
    }

    /**
     * Builds a new {@link GetManagedServiceParametersResponse GetManagedServiceParametersResponse}.
     * @return An immutable instance of GetManagedServiceParametersResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetManagedServiceParametersResponse build() {
      return new GetManagedServiceParametersResponse(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
