package org.cloudfoundry.client.v3.serviceofferings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Broker Catalog information for a Service Offering
 */
@Generated(from = "_BrokerCatalog", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class BrokerCatalog extends org.cloudfoundry.client.v3.serviceofferings._BrokerCatalog {
  private final String brokerCatalogId;
  private final Features features;
  private final @Nullable Map<String, Object> metadata;

  private BrokerCatalog(BrokerCatalog.Builder builder) {
    this.brokerCatalogId = builder.brokerCatalogId;
    this.features = builder.features;
    this.metadata = builder.metadata == null ? null : createUnmodifiableMap(false, false, builder.metadata);
  }

  /**
   * The identifier that the service broker provided for this service offering
   */
  @JsonProperty("id")
  @Override
  public String getBrokerCatalogId() {
    return brokerCatalogId;
  }

  /**
   * Broker-related features of the service offering
   */
  @JsonProperty("features")
  @Override
  public Features getFeatures() {
    return features;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Map<String, Object> getMetadata() {
    return metadata;
  }

  /**
   * This instance is equal to all instances of {@code BrokerCatalog} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BrokerCatalog
        && equalTo((BrokerCatalog) another);
  }

  private boolean equalTo(BrokerCatalog another) {
    return brokerCatalogId.equals(another.brokerCatalogId)
        && features.equals(another.features)
        && Objects.equals(metadata, another.metadata);
  }

  /**
   * Computes a hash code from attributes: {@code brokerCatalogId}, {@code features}, {@code metadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + brokerCatalogId.hashCode();
    h += (h << 5) + features.hashCode();
    h += (h << 5) + Objects.hashCode(metadata);
    return h;
  }

  /**
   * Prints the immutable value {@code BrokerCatalog} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BrokerCatalog{"
        + "brokerCatalogId=" + brokerCatalogId
        + ", features=" + features
        + ", metadata=" + metadata
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_BrokerCatalog", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.serviceofferings._BrokerCatalog {
    String brokerCatalogId;
    Features features;
    Map<String, Object> metadata = null;
    @JsonProperty("id")
    public void setBrokerCatalogId(String brokerCatalogId) {
      this.brokerCatalogId = brokerCatalogId;
    }
    @JsonProperty("features")
    public void setFeatures(Features features) {
      this.features = features;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Map<String, Object> metadata) {
      this.metadata = metadata;
    }
    @Override
    public String getBrokerCatalogId() { throw new UnsupportedOperationException(); }
    @Override
    public Features getFeatures() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static BrokerCatalog fromJson(Json json) {
    BrokerCatalog.Builder builder = BrokerCatalog.builder();
    if (json.brokerCatalogId != null) {
      builder.brokerCatalogId(json.brokerCatalogId);
    }
    if (json.features != null) {
      builder.features(json.features);
    }
    if (json.metadata != null) {
      builder.putAllMetadata(json.metadata);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link BrokerCatalog BrokerCatalog}.
   * <pre>
   * BrokerCatalog.builder()
   *    .brokerCatalogId(String) // required {@link BrokerCatalog#getBrokerCatalogId() brokerCatalogId}
   *    .features(org.cloudfoundry.client.v3.serviceofferings.Features) // required {@link BrokerCatalog#getFeatures() features}
   *    .metadata(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link BrokerCatalog#getMetadata() metadata}
   *    .build();
   * </pre>
   * @return A new BrokerCatalog builder
   */
  public static BrokerCatalog.Builder builder() {
    return new BrokerCatalog.Builder();
  }

  /**
   * Builds instances of type {@link BrokerCatalog BrokerCatalog}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_BrokerCatalog", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_BROKER_CATALOG_ID = 0x1L;
    private static final long INIT_BIT_FEATURES = 0x2L;
    private long initBits = 0x3L;

    private String brokerCatalogId;
    private Features features;
    private Map<String, Object> metadata = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BrokerCatalog} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BrokerCatalog instance) {
      return from((_BrokerCatalog) instance);
    }

    /**
     * Copy abstract value type {@code _BrokerCatalog} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_BrokerCatalog instance) {
      Objects.requireNonNull(instance, "instance");
      brokerCatalogId(instance.getBrokerCatalogId());
      features(instance.getFeatures());
      Map<String, Object> metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        putAllMetadata(metadataValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link BrokerCatalog#getBrokerCatalogId() brokerCatalogId} attribute.
     * @param brokerCatalogId The value for brokerCatalogId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder brokerCatalogId(String brokerCatalogId) {
      this.brokerCatalogId = Objects.requireNonNull(brokerCatalogId, "brokerCatalogId");
      initBits &= ~INIT_BIT_BROKER_CATALOG_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link BrokerCatalog#getFeatures() features} attribute.
     * @param features The value for features 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("features")
    public final Builder features(Features features) {
      this.features = Objects.requireNonNull(features, "features");
      initBits &= ~INIT_BIT_FEATURES;
      return this;
    }

    /**
     * Put one entry to the {@link BrokerCatalog#getMetadata() metadata} map.
     * @param key The key in the metadata map
     * @param value The associated value in the metadata map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(String key, Object value) {
      if (this.metadata == null) {
        this.metadata = new LinkedHashMap<String, Object>();
      }
      this.metadata.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link BrokerCatalog#getMetadata() metadata} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(Map.Entry<String, ? extends Object> entry) {
      if (this.metadata == null) {
        this.metadata = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.metadata.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link BrokerCatalog#getMetadata() metadata} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the metadata map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.metadata = null;
        return this;
      }
      this.metadata = new LinkedHashMap<String, Object>();
      return putAllMetadata(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link BrokerCatalog#getMetadata() metadata} map. Nulls are not permitted
     * @param entries The entries that will be added to the metadata map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllMetadata(Map<String, ? extends Object> entries) {
      if (this.metadata == null) {
        this.metadata = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.metadata.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link BrokerCatalog BrokerCatalog}.
     * @return An immutable instance of BrokerCatalog
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BrokerCatalog build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new BrokerCatalog(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BROKER_CATALOG_ID) != 0) attributes.add("brokerCatalogId");
      if ((initBits & INIT_BIT_FEATURES) != 0) attributes.add("features");
      return "Cannot build BrokerCatalog, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
