package org.cloudfoundry.client.v3.serviceplans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.ToOneRelationship;
import org.immutables.value.Generated;

/**
 * The Service Plan relationships
 */
@Generated(from = "_ServicePlanRelationships", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ServicePlanRelationships
    extends org.cloudfoundry.client.v3.serviceplans._ServicePlanRelationships {
  private final ToOneRelationship serviceOffering;
  private final @Nullable ToOneRelationship space;

  private ServicePlanRelationships(ServicePlanRelationships.Builder builder) {
    this.serviceOffering = builder.serviceOffering;
    this.space = builder.space;
  }

  /**
   * The space relationship
   */
  @JsonProperty("service_offering")
  @Override
  public ToOneRelationship getServiceOffering() {
    return serviceOffering;
  }

  /**
   * The space relationship
   */
  @JsonProperty("space")
  @Override
  public @Nullable ToOneRelationship getSpace() {
    return space;
  }

  /**
   * This instance is equal to all instances of {@code ServicePlanRelationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServicePlanRelationships
        && equalTo((ServicePlanRelationships) another);
  }

  private boolean equalTo(ServicePlanRelationships another) {
    return serviceOffering.equals(another.serviceOffering)
        && Objects.equals(space, another.space);
  }

  /**
   * Computes a hash code from attributes: {@code serviceOffering}, {@code space}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + serviceOffering.hashCode();
    h += (h << 5) + Objects.hashCode(space);
    return h;
  }

  /**
   * Prints the immutable value {@code ServicePlanRelationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServicePlanRelationships{"
        + "serviceOffering=" + serviceOffering
        + ", space=" + space
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ServicePlanRelationships", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.serviceplans._ServicePlanRelationships {
    ToOneRelationship serviceOffering;
    ToOneRelationship space;
    @JsonProperty("service_offering")
    public void setServiceOffering(ToOneRelationship serviceOffering) {
      this.serviceOffering = serviceOffering;
    }
    @JsonProperty("space")
    public void setSpace(@Nullable ToOneRelationship space) {
      this.space = space;
    }
    @Override
    public ToOneRelationship getServiceOffering() { throw new UnsupportedOperationException(); }
    @Override
    public ToOneRelationship getSpace() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ServicePlanRelationships fromJson(Json json) {
    ServicePlanRelationships.Builder builder = ServicePlanRelationships.builder();
    if (json.serviceOffering != null) {
      builder.serviceOffering(json.serviceOffering);
    }
    if (json.space != null) {
      builder.space(json.space);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ServicePlanRelationships ServicePlanRelationships}.
   * <pre>
   * ServicePlanRelationships.builder()
   *    .serviceOffering(org.cloudfoundry.client.v3.ToOneRelationship) // required {@link ServicePlanRelationships#getServiceOffering() serviceOffering}
   *    .space(org.cloudfoundry.client.v3.ToOneRelationship | null) // nullable {@link ServicePlanRelationships#getSpace() space}
   *    .build();
   * </pre>
   * @return A new ServicePlanRelationships builder
   */
  public static ServicePlanRelationships.Builder builder() {
    return new ServicePlanRelationships.Builder();
  }

  /**
   * Builds instances of type {@link ServicePlanRelationships ServicePlanRelationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ServicePlanRelationships", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SERVICE_OFFERING = 0x1L;
    private long initBits = 0x1L;

    private ToOneRelationship serviceOffering;
    private ToOneRelationship space;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServicePlanRelationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServicePlanRelationships instance) {
      return from((_ServicePlanRelationships) instance);
    }

    /**
     * Copy abstract value type {@code _ServicePlanRelationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServicePlanRelationships instance) {
      Objects.requireNonNull(instance, "instance");
      serviceOffering(instance.getServiceOffering());
      ToOneRelationship spaceValue = instance.getSpace();
      if (spaceValue != null) {
        space(spaceValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanRelationships#getServiceOffering() serviceOffering} attribute.
     * @param serviceOffering The value for serviceOffering 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_offering")
    public final Builder serviceOffering(ToOneRelationship serviceOffering) {
      this.serviceOffering = Objects.requireNonNull(serviceOffering, "serviceOffering");
      initBits &= ~INIT_BIT_SERVICE_OFFERING;
      return this;
    }

    /**
     * Initializes the value for the {@link ServicePlanRelationships#getSpace() space} attribute.
     * @param space The value for space (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space")
    public final Builder space(@Nullable ToOneRelationship space) {
      this.space = space;
      return this;
    }

    /**
     * Builds a new {@link ServicePlanRelationships ServicePlanRelationships}.
     * @return An immutable instance of ServicePlanRelationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServicePlanRelationships build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ServicePlanRelationships(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVICE_OFFERING) != 0) attributes.add("serviceOffering");
      return "Cannot build ServicePlanRelationships, some of required attributes are not set " + attributes;
    }
  }
}
