package org.cloudfoundry.client.v3.stacks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Stacks operation.
 */
@Generated(from = "_ListStacksRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListStacksRequest extends org.cloudfoundry.client.v3.stacks._ListStacksRequest {
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;
  private final @Nullable String labelSelector;
  private final List<String> names;

  private ListStacksRequest(ListStacksRequest.Builder builder) {
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
    this.labelSelector = builder.labelSelector;
    this.names = createUnmodifiableList(true, builder.names);
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * The metadata query
   */
  @Override
  public @Nullable String getLabelSelector() {
    return labelSelector;
  }

  /**
   * The names
   */
  @Override
  public List<String> getNames() {
    return names;
  }

  /**
   * This instance is equal to all instances of {@code ListStacksRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListStacksRequest
        && equalTo((ListStacksRequest) another);
  }

  private boolean equalTo(ListStacksRequest another) {
    return Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage)
        && Objects.equals(labelSelector, another.labelSelector)
        && names.equals(another.names);
  }

  /**
   * Computes a hash code from attributes: {@code orderBy}, {@code page}, {@code perPage}, {@code labelSelector}, {@code names}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    h += (h << 5) + Objects.hashCode(labelSelector);
    h += (h << 5) + names.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListStacksRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListStacksRequest{"
        + "orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + ", labelSelector=" + labelSelector
        + ", names=" + names
        + "}";
  }

  /**
   * Creates a builder for {@link ListStacksRequest ListStacksRequest}.
   * <pre>
   * ListStacksRequest.builder()
   *    .orderBy(String | null) // nullable {@link ListStacksRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListStacksRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListStacksRequest#getPerPage() perPage}
   *    .labelSelector(String | null) // nullable {@link ListStacksRequest#getLabelSelector() labelSelector}
   *    .name|addAllNames(String) // {@link ListStacksRequest#getNames() names} elements
   *    .build();
   * </pre>
   * @return A new ListStacksRequest builder
   */
  public static ListStacksRequest.Builder builder() {
    return new ListStacksRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListStacksRequest ListStacksRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListStacksRequest", generator = "Immutables")
  public static final class Builder {
    private String orderBy;
    private Integer page;
    private Integer perPage;
    private String labelSelector;
    private List<String> names = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListStacksRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListStacksRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListStacksRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListStacksRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v3.stacks._ListStacksRequest) {
        org.cloudfoundry.client.v3.stacks._ListStacksRequest instance = (org.cloudfoundry.client.v3.stacks._ListStacksRequest) object;
        String labelSelectorValue = instance.getLabelSelector();
        if (labelSelectorValue != null) {
          labelSelector(labelSelectorValue);
        }
        addAllNames(instance.getNames());
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListStacksRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListStacksRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListStacksRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Initializes the value for the {@link ListStacksRequest#getLabelSelector() labelSelector} attribute.
     * @param labelSelector The value for labelSelector (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder labelSelector(@Nullable String labelSelector) {
      this.labelSelector = labelSelector;
      return this;
    }

    /**
     * Adds one element to {@link ListStacksRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link ListStacksRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(String... elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListStacksRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(Iterable<String> elements) {
      this.names.clear();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link ListStacksRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListStacksRequest ListStacksRequest}.
     * @return An immutable instance of ListStacksRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListStacksRequest build() {
      return new ListStacksRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
