package org.cloudfoundry.uaa.serverinformation;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The payload for the server information prompts
 */
@Generated(from = "_Prompts", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Prompts extends org.cloudfoundry.uaa.serverinformation._Prompts {
  private final @Nullable List<String> passcode;
  private final @Nullable List<String> password;
  private final @Nullable List<String> username;

  private Prompts(Prompts.Builder builder) {
    this.passcode = builder.passcode == null ? null : createUnmodifiableList(true, builder.passcode);
    this.password = builder.password == null ? null : createUnmodifiableList(true, builder.password);
    this.username = builder.username == null ? null : createUnmodifiableList(true, builder.username);
  }

  /**
   * If a SAML identity provider is configured, this prompt contains a URL to where the user can initiate the SAML authentication flow
   */
  @JsonProperty("passcode")
  @Override
  public @Nullable List<String> getPasscode() {
    return passcode;
  }

  /**
   * Information about the password prompt
   */
  @JsonProperty("password")
  @Override
  public @Nullable List<String> getPassword() {
    return password;
  }

  /**
   * Information about the username prompt
   */
  @JsonProperty("username")
  @Override
  public @Nullable List<String> getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code Prompts} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Prompts
        && equalTo((Prompts) another);
  }

  private boolean equalTo(Prompts another) {
    return Objects.equals(passcode, another.passcode)
        && Objects.equals(password, another.password)
        && Objects.equals(username, another.username);
  }

  /**
   * Computes a hash code from attributes: {@code passcode}, {@code password}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(passcode);
    h += (h << 5) + Objects.hashCode(password);
    h += (h << 5) + Objects.hashCode(username);
    return h;
  }

  /**
   * Prints the immutable value {@code Prompts} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Prompts{"
        + "passcode=" + passcode
        + ", password=" + password
        + ", username=" + username
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Prompts", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.serverinformation._Prompts {
    List<String> passcode = null;
    List<String> password = null;
    List<String> username = null;
    @JsonProperty("passcode")
    public void setPasscode(@Nullable List<String> passcode) {
      this.passcode = passcode;
    }
    @JsonProperty("password")
    public void setPassword(@Nullable List<String> password) {
      this.password = password;
    }
    @JsonProperty("username")
    public void setUsername(@Nullable List<String> username) {
      this.username = username;
    }
    @Override
    public List<String> getPasscode() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getPassword() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getUsername() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Prompts fromJson(Json json) {
    Prompts.Builder builder = Prompts.builder();
    if (json.passcode != null) {
      builder.addAllPasscode(json.passcode);
    }
    if (json.password != null) {
      builder.addAllPassword(json.password);
    }
    if (json.username != null) {
      builder.addAllUsername(json.username);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Prompts Prompts}.
   * <pre>
   * Prompts.builder()
   *    .passcode(List&amp;lt;String&amp;gt; | null) // nullable {@link Prompts#getPasscode() passcode}
   *    .password(List&amp;lt;String&amp;gt; | null) // nullable {@link Prompts#getPassword() password}
   *    .username(List&amp;lt;String&amp;gt; | null) // nullable {@link Prompts#getUsername() username}
   *    .build();
   * </pre>
   * @return A new Prompts builder
   */
  public static Prompts.Builder builder() {
    return new Prompts.Builder();
  }

  /**
   * Builds instances of type {@link Prompts Prompts}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Prompts", generator = "Immutables")
  public static final class Builder {
    private List<String> passcode = null;
    private List<String> password = null;
    private List<String> username = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Prompts} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Prompts instance) {
      return from((_Prompts) instance);
    }

    /**
     * Copy abstract value type {@code _Prompts} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Prompts instance) {
      Objects.requireNonNull(instance, "instance");
      List<String> passcodeValue = instance.getPasscode();
      if (passcodeValue != null) {
        addAllPasscode(passcodeValue);
      }
      List<String> passwordValue = instance.getPassword();
      if (passwordValue != null) {
        addAllPassword(passwordValue);
      }
      List<String> usernameValue = instance.getUsername();
      if (usernameValue != null) {
        addAllUsername(usernameValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link Prompts#getPasscode() passcode} list.
     * @param element A passcode element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder passcode(String element) {
      if (this.passcode == null) {
        this.passcode = new ArrayList<String>();
      }
      this.passcode.add(Objects.requireNonNull(element, "passcode element"));
      return this;
    }

    /**
     * Adds elements to {@link Prompts#getPasscode() passcode} list.
     * @param elements An array of passcode elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder passcode(String... elements) {
      if (this.passcode == null) {
        this.passcode = new ArrayList<String>();
      }
      for (String element : elements) {
        this.passcode.add(Objects.requireNonNull(element, "passcode element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Prompts#getPasscode() passcode} list.
     * @param elements An iterable of passcode elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("passcode")
    public final Builder passcode(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.passcode = null;
        return this;
      }
      this.passcode = new ArrayList<String>();
      return addAllPasscode(elements);
    }

    /**
     * Adds elements to {@link Prompts#getPasscode() passcode} list.
     * @param elements An iterable of passcode elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPasscode(Iterable<String> elements) {
      Objects.requireNonNull(elements, "passcode element");
      if (this.passcode == null) {
        this.passcode = new ArrayList<String>();
      }
      for (String element : elements) {
        this.passcode.add(Objects.requireNonNull(element, "passcode element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link Prompts#getPassword() password} list.
     * @param element A password element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(String element) {
      if (this.password == null) {
        this.password = new ArrayList<String>();
      }
      this.password.add(Objects.requireNonNull(element, "password element"));
      return this;
    }

    /**
     * Adds elements to {@link Prompts#getPassword() password} list.
     * @param elements An array of password elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(String... elements) {
      if (this.password == null) {
        this.password = new ArrayList<String>();
      }
      for (String element : elements) {
        this.password.add(Objects.requireNonNull(element, "password element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Prompts#getPassword() password} list.
     * @param elements An iterable of password elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("password")
    public final Builder password(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.password = null;
        return this;
      }
      this.password = new ArrayList<String>();
      return addAllPassword(elements);
    }

    /**
     * Adds elements to {@link Prompts#getPassword() password} list.
     * @param elements An iterable of password elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPassword(Iterable<String> elements) {
      Objects.requireNonNull(elements, "password element");
      if (this.password == null) {
        this.password = new ArrayList<String>();
      }
      for (String element : elements) {
        this.password.add(Objects.requireNonNull(element, "password element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link Prompts#getUsername() username} list.
     * @param element A username element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String element) {
      if (this.username == null) {
        this.username = new ArrayList<String>();
      }
      this.username.add(Objects.requireNonNull(element, "username element"));
      return this;
    }

    /**
     * Adds elements to {@link Prompts#getUsername() username} list.
     * @param elements An array of username elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String... elements) {
      if (this.username == null) {
        this.username = new ArrayList<String>();
      }
      for (String element : elements) {
        this.username.add(Objects.requireNonNull(element, "username element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Prompts#getUsername() username} list.
     * @param elements An iterable of username elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("username")
    public final Builder username(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.username = null;
        return this;
      }
      this.username = new ArrayList<String>();
      return addAllUsername(elements);
    }

    /**
     * Adds elements to {@link Prompts#getUsername() username} list.
     * @param elements An iterable of username elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllUsername(Iterable<String> elements) {
      Objects.requireNonNull(elements, "username element");
      if (this.username == null) {
        this.username = new ArrayList<String>();
      }
      for (String element : elements) {
        this.username.add(Objects.requireNonNull(element, "username element"));
      }
      return this;
    }

    /**
     * Builds a new {@link Prompts Prompts}.
     * @return An immutable instance of Prompts
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Prompts build() {
      return new Prompts(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
