/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Pagination;
import org.cloudfoundry.client.v3.applications._ListApplicationProcessesResponse;
import org.cloudfoundry.client.v3.processes.ProcessResource;
import org.immutables.value.Generated;

@Generated(from="_ListApplicationProcessesResponse", generator="Immutables")
public final class ListApplicationProcessesResponse
extends _ListApplicationProcessesResponse {
    @Nullable
    private final Pagination pagination;
    @Nullable
    private final List<ProcessResource> resources;

    private ListApplicationProcessesResponse(Builder builder) {
        this.pagination = builder.pagination;
        this.resources = builder.resources == null ? null : ListApplicationProcessesResponse.createUnmodifiableList(true, builder.resources);
    }

    @Override
    @JsonProperty(value="pagination")
    @Nullable
    public Pagination getPagination() {
        return this.pagination;
    }

    @Override
    @JsonProperty(value="resources")
    @Nullable
    public List<ProcessResource> getResources() {
        return this.resources;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListApplicationProcessesResponse && this.equalTo((ListApplicationProcessesResponse)another);
    }

    private boolean equalTo(ListApplicationProcessesResponse another) {
        return Objects.equals(this.pagination, another.pagination) && Objects.equals(this.resources, another.resources);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.pagination);
        h += (h << 5) + Objects.hashCode(this.resources);
        return h;
    }

    public String toString() {
        return "ListApplicationProcessesResponse{pagination=" + this.pagination + ", resources=" + this.resources + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ListApplicationProcessesResponse fromJson(Json json) {
        Builder builder = ListApplicationProcessesResponse.builder();
        if (json.pagination != null) {
            builder.pagination(json.pagination);
        }
        if (json.resources != null) {
            builder.addAllResources(json.resources);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListApplicationProcessesResponse", generator="Immutables")
    public static final class Builder {
        private Pagination pagination;
        private List<ProcessResource> resources = null;

        private Builder() {
        }

        public final Builder from(ListApplicationProcessesResponse instance) {
            return this.from((_ListApplicationProcessesResponse)instance);
        }

        final Builder from(_ListApplicationProcessesResponse instance) {
            List resourcesValue;
            Objects.requireNonNull(instance, "instance");
            Pagination paginationValue = instance.getPagination();
            if (paginationValue != null) {
                this.pagination(paginationValue);
            }
            if ((resourcesValue = instance.getResources()) != null) {
                this.addAllResources(resourcesValue);
            }
            return this;
        }

        @JsonProperty(value="pagination")
        public final Builder pagination(@Nullable Pagination pagination) {
            this.pagination = pagination;
            return this;
        }

        public final Builder resource(ProcessResource element) {
            if (this.resources == null) {
                this.resources = new ArrayList<ProcessResource>();
            }
            this.resources.add(Objects.requireNonNull(element, "resources element"));
            return this;
        }

        public final Builder resources(ProcessResource ... elements) {
            if (this.resources == null) {
                this.resources = new ArrayList<ProcessResource>();
            }
            for (ProcessResource element : elements) {
                this.resources.add(Objects.requireNonNull(element, "resources element"));
            }
            return this;
        }

        @JsonProperty(value="resources")
        public final Builder resources(@Nullable Iterable<? extends ProcessResource> elements) {
            if (elements == null) {
                this.resources = null;
                return this;
            }
            this.resources = new ArrayList<ProcessResource>();
            return this.addAllResources(elements);
        }

        public final Builder addAllResources(Iterable<? extends ProcessResource> elements) {
            Objects.requireNonNull(elements, "resources element");
            if (this.resources == null) {
                this.resources = new ArrayList<ProcessResource>();
            }
            for (ProcessResource processResource : elements) {
                this.resources.add(Objects.requireNonNull(processResource, "resources element"));
            }
            return this;
        }

        public ListApplicationProcessesResponse build() {
            return new ListApplicationProcessesResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_ListApplicationProcessesResponse", generator="Immutables")
    static final class Json
    extends _ListApplicationProcessesResponse {
        Pagination pagination;
        List<ProcessResource> resources = null;

        Json() {
        }

        @JsonProperty(value="pagination")
        public void setPagination(@Nullable Pagination pagination) {
            this.pagination = pagination;
        }

        @JsonProperty(value="resources")
        public void setResources(@Nullable List<ProcessResource> resources) {
            this.resources = resources;
        }

        @Override
        public Pagination getPagination() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ProcessResource> getResources() {
            throw new UnsupportedOperationException();
        }
    }
}

