/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.organizations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum OrganizationStatus {
    ACTIVE("ACTIVE"),
    SUSPENDED("SUSPENDED");

    private final String value;

    private OrganizationStatus(String value) {
        this.value = value;
    }

    @JsonCreator
    public static OrganizationStatus from(String s) {
        switch (s.toLowerCase()) {
            case "active": {
                return ACTIVE;
            }
            case "suspended": {
                return SUSPENDED;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown organization status: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

