/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.servicebindings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.LastOperation;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.cloudfoundry.client.v3.servicebindings.ServiceBinding;
import org.cloudfoundry.client.v3.servicebindings.ServiceBindingRelationships;
import org.cloudfoundry.client.v3.servicebindings.ServiceBindingType;
import org.cloudfoundry.client.v3.servicebindings._GetServiceBindingResponse;
import org.immutables.value.Generated;

@Generated(from="_GetServiceBindingResponse", generator="Immutables")
public final class GetServiceBindingResponse
extends _GetServiceBindingResponse {
    private final String createdAt;
    private final String id;
    private final Map<String, Link> links;
    @Nullable
    private final String updatedAt;
    @Nullable
    private final String name;
    private final ServiceBindingType type;
    @Nullable
    private final LastOperation lastOperation;
    private final ServiceBindingRelationships relationships;
    @Nullable
    private final Metadata metadata;

    private GetServiceBindingResponse(Builder builder) {
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.links = GetServiceBindingResponse.createUnmodifiableMap(false, false, builder.links);
        this.updatedAt = builder.updatedAt;
        this.name = builder.name;
        this.type = builder.type;
        this.lastOperation = builder.lastOperation;
        this.relationships = builder.relationships;
        this.metadata = builder.metadata;
    }

    @Override
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="guid")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="links")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="updated_at")
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="type")
    public ServiceBindingType getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="last_operation")
    @Nullable
    public LastOperation getLastOperation() {
        return this.lastOperation;
    }

    @Override
    @JsonProperty(value="relationships")
    public ServiceBindingRelationships getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetServiceBindingResponse && this.equalTo((GetServiceBindingResponse)another);
    }

    private boolean equalTo(GetServiceBindingResponse another) {
        return this.createdAt.equals(another.createdAt) && this.id.equals(another.id) && this.links.equals(another.links) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.name, another.name) && this.type.equals((Object)another.type) && Objects.equals(this.lastOperation, another.lastOperation) && this.relationships.equals(another.relationships) && Objects.equals(this.metadata, another.metadata);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.lastOperation);
        h += (h << 5) + this.relationships.hashCode();
        h += (h << 5) + Objects.hashCode(this.metadata);
        return h;
    }

    public String toString() {
        return "GetServiceBindingResponse{createdAt=" + this.createdAt + ", id=" + this.id + ", links=" + this.links + ", updatedAt=" + this.updatedAt + ", name=" + this.name + ", type=" + (Object)((Object)this.type) + ", lastOperation=" + this.lastOperation + ", relationships=" + this.relationships + ", metadata=" + this.metadata + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static GetServiceBindingResponse fromJson(Json json) {
        Builder builder = GetServiceBindingResponse.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.lastOperation != null) {
            builder.lastOperation(json.lastOperation);
        }
        if (json.relationships != null) {
            builder.relationships(json.relationships);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_GetServiceBindingResponse", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CREATED_AT = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private static final long INIT_BIT_RELATIONSHIPS = 8L;
        private long initBits = 15L;
        private String createdAt;
        private String id;
        private Map<String, Link> links = new LinkedHashMap<String, Link>();
        private String updatedAt;
        private String name;
        private ServiceBindingType type;
        private LastOperation lastOperation;
        private ServiceBindingRelationships relationships;
        private Metadata metadata;

        private Builder() {
        }

        public final Builder from(ServiceBinding instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Resource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetServiceBindingResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_GetServiceBindingResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Resource instance;
            if (object instanceof ServiceBinding) {
                instance = (ServiceBinding)object;
                String nameValue = ((ServiceBinding)instance).getName();
                if (nameValue != null) {
                    this.name(nameValue);
                }
                this.relationships(((ServiceBinding)instance).getRelationships());
                Metadata metadataValue = ((ServiceBinding)instance).getMetadata();
                if (metadataValue != null) {
                    this.metadata(metadataValue);
                }
                this.type(((ServiceBinding)instance).getType());
                LastOperation lastOperationValue = ((ServiceBinding)instance).getLastOperation();
                if (lastOperationValue != null) {
                    this.lastOperation(lastOperationValue);
                }
            }
            if (object instanceof Resource) {
                instance = (Resource)object;
                this.createdAt(instance.getCreatedAt());
                this.putAllLinks(instance.getLinks());
                this.id(instance.getId());
                String updatedAtValue = instance.getUpdatedAt();
                if (updatedAtValue != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
        }

        @JsonProperty(value="created_at")
        public final Builder createdAt(String createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder link(String key, Link value) {
            this.links.put(key, value);
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(k, v);
            return this;
        }

        @JsonProperty(value="links")
        public final Builder links(Map<String, ? extends Link> entries) {
            this.links.clear();
            return this.putAllLinks(entries);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> entries) {
            for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
                String k = e.getKey();
                Link v = e.getValue();
                this.links.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="updated_at")
        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(ServiceBindingType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="last_operation")
        public final Builder lastOperation(@Nullable LastOperation lastOperation) {
            this.lastOperation = lastOperation;
            return this;
        }

        @JsonProperty(value="relationships")
        public final Builder relationships(ServiceBindingRelationships relationships) {
            this.relationships = Objects.requireNonNull(relationships, "relationships");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="metadata")
        public final Builder metadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public GetServiceBindingResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetServiceBindingResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("relationships");
            }
            return "Cannot build GetServiceBindingResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_GetServiceBindingResponse", generator="Immutables")
    static final class Json
    extends _GetServiceBindingResponse {
        String createdAt;
        String id;
        Map<String, Link> links = Collections.emptyMap();
        String updatedAt;
        String name;
        ServiceBindingType type;
        LastOperation lastOperation;
        ServiceBindingRelationships relationships;
        Metadata metadata;

        Json() {
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="guid")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="links")
        public void setLinks(Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="type")
        public void setType(ServiceBindingType type) {
            this.type = type;
        }

        @JsonProperty(value="last_operation")
        public void setLastOperation(@Nullable LastOperation lastOperation) {
            this.lastOperation = lastOperation;
        }

        @JsonProperty(value="relationships")
        public void setRelationships(ServiceBindingRelationships relationships) {
            this.relationships = relationships;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServiceBindingType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LastOperation getLastOperation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServiceBindingRelationships getRelationships() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

