/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.LastOperation;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.MaintenanceInfo;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.Resource;
import org.cloudfoundry.client.v3.serviceinstances.ServiceInstance;
import org.cloudfoundry.client.v3.serviceinstances.ServiceInstanceRelationships;
import org.cloudfoundry.client.v3.serviceinstances.ServiceInstanceType;
import org.cloudfoundry.client.v3.serviceinstances._GetServiceInstanceResponse;
import org.immutables.value.Generated;

@Generated(from="_GetServiceInstanceResponse", generator="Immutables")
public final class GetServiceInstanceResponse
extends _GetServiceInstanceResponse {
    private final String createdAt;
    private final String id;
    private final Map<String, Link> links;
    @Nullable
    private final String updatedAt;
    @Nullable
    private final String dashboardUrl;
    @Nullable
    private final LastOperation lastOperation;
    @Nullable
    private final MaintenanceInfo maintenanceInfo;
    @Nullable
    private final Metadata metadata;
    private final String name;
    @Nullable
    private final ServiceInstanceRelationships relationships;
    @Nullable
    private final String routeServiceUrl;
    @Nullable
    private final String syslogDrainUrl;
    @Nullable
    private final List<String> tags;
    @Nullable
    private final ServiceInstanceType type;
    @Nullable
    private final Boolean updateAvailable;

    private GetServiceInstanceResponse(Builder builder) {
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.links = GetServiceInstanceResponse.createUnmodifiableMap(false, false, builder.links);
        this.updatedAt = builder.updatedAt;
        this.dashboardUrl = builder.dashboardUrl;
        this.lastOperation = builder.lastOperation;
        this.maintenanceInfo = builder.maintenanceInfo;
        this.metadata = builder.metadata;
        this.name = builder.name;
        this.relationships = builder.relationships;
        this.routeServiceUrl = builder.routeServiceUrl;
        this.syslogDrainUrl = builder.syslogDrainUrl;
        this.tags = builder.tags == null ? null : GetServiceInstanceResponse.createUnmodifiableList(true, builder.tags);
        this.type = builder.type;
        this.updateAvailable = builder.updateAvailable;
    }

    @Override
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="guid")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="links")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="updated_at")
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="dashboard_url")
    @Nullable
    public String getDashboardUrl() {
        return this.dashboardUrl;
    }

    @Override
    @JsonProperty(value="last_operation")
    @Nullable
    public LastOperation getLastOperation() {
        return this.lastOperation;
    }

    @Override
    @JsonProperty(value="maintenance_info")
    @Nullable
    public MaintenanceInfo getMaintenanceInfo() {
        return this.maintenanceInfo;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="relationships")
    @Nullable
    public ServiceInstanceRelationships getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonProperty(value="route_service_url")
    @Nullable
    public String getRouteServiceUrl() {
        return this.routeServiceUrl;
    }

    @Override
    @JsonProperty(value="syslog_drain_url")
    @Nullable
    public String getSyslogDrainUrl() {
        return this.syslogDrainUrl;
    }

    @Override
    @JsonProperty(value="tags")
    @Nullable
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="type")
    @Nullable
    public ServiceInstanceType getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="upgrade_available")
    @Nullable
    public Boolean getUpdateAvailable() {
        return this.updateAvailable;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetServiceInstanceResponse && this.equalTo((GetServiceInstanceResponse)another);
    }

    private boolean equalTo(GetServiceInstanceResponse another) {
        return this.createdAt.equals(another.createdAt) && this.id.equals(another.id) && this.links.equals(another.links) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.dashboardUrl, another.dashboardUrl) && Objects.equals(this.lastOperation, another.lastOperation) && Objects.equals(this.maintenanceInfo, another.maintenanceInfo) && Objects.equals(this.metadata, another.metadata) && this.name.equals(another.name) && Objects.equals(this.relationships, another.relationships) && Objects.equals(this.routeServiceUrl, another.routeServiceUrl) && Objects.equals(this.syslogDrainUrl, another.syslogDrainUrl) && Objects.equals(this.tags, another.tags) && Objects.equals((Object)this.type, (Object)another.type) && Objects.equals(this.updateAvailable, another.updateAvailable);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.dashboardUrl);
        h += (h << 5) + Objects.hashCode(this.lastOperation);
        h += (h << 5) + Objects.hashCode(this.maintenanceInfo);
        h += (h << 5) + Objects.hashCode(this.metadata);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.relationships);
        h += (h << 5) + Objects.hashCode(this.routeServiceUrl);
        h += (h << 5) + Objects.hashCode(this.syslogDrainUrl);
        h += (h << 5) + Objects.hashCode(this.tags);
        h += (h << 5) + Objects.hashCode((Object)this.type);
        h += (h << 5) + Objects.hashCode(this.updateAvailable);
        return h;
    }

    public String toString() {
        return "GetServiceInstanceResponse{createdAt=" + this.createdAt + ", id=" + this.id + ", links=" + this.links + ", updatedAt=" + this.updatedAt + ", dashboardUrl=" + this.dashboardUrl + ", lastOperation=" + this.lastOperation + ", maintenanceInfo=" + this.maintenanceInfo + ", metadata=" + this.metadata + ", name=" + this.name + ", relationships=" + this.relationships + ", routeServiceUrl=" + this.routeServiceUrl + ", syslogDrainUrl=" + this.syslogDrainUrl + ", tags=" + this.tags + ", type=" + (Object)((Object)this.type) + ", updateAvailable=" + this.updateAvailable + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static GetServiceInstanceResponse fromJson(Json json) {
        Builder builder = GetServiceInstanceResponse.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.dashboardUrl != null) {
            builder.dashboardUrl(json.dashboardUrl);
        }
        if (json.lastOperation != null) {
            builder.lastOperation(json.lastOperation);
        }
        if (json.maintenanceInfo != null) {
            builder.maintenanceInfo(json.maintenanceInfo);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.relationships != null) {
            builder.relationships(json.relationships);
        }
        if (json.routeServiceUrl != null) {
            builder.routeServiceUrl(json.routeServiceUrl);
        }
        if (json.syslogDrainUrl != null) {
            builder.syslogDrainUrl(json.syslogDrainUrl);
        }
        if (json.tags != null) {
            builder.addAllTags(json.tags);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.updateAvailable != null) {
            builder.updateAvailable(json.updateAvailable);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_GetServiceInstanceResponse", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CREATED_AT = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private long initBits = 7L;
        private String createdAt;
        private String id;
        private Map<String, Link> links = new LinkedHashMap<String, Link>();
        private String updatedAt;
        private String dashboardUrl;
        private LastOperation lastOperation;
        private MaintenanceInfo maintenanceInfo;
        private Metadata metadata;
        private String name;
        private ServiceInstanceRelationships relationships;
        private String routeServiceUrl;
        private String syslogDrainUrl;
        private List<String> tags = null;
        private ServiceInstanceType type;
        private Boolean updateAvailable;

        private Builder() {
        }

        public final Builder from(ServiceInstance instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Resource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetServiceInstanceResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_GetServiceInstanceResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Resource instance;
            if (object instanceof ServiceInstance) {
                List<String> tagsValue;
                String syslogDrainUrlValue;
                MaintenanceInfo maintenanceInfoValue;
                Boolean updateAvailableValue;
                String routeServiceUrlValue;
                LastOperation lastOperationValue;
                Metadata metadataValue;
                String dashboardUrlValue;
                instance = (ServiceInstance)object;
                ServiceInstanceRelationships relationshipsValue = ((ServiceInstance)instance).getRelationships();
                if (relationshipsValue != null) {
                    this.relationships(relationshipsValue);
                }
                if ((dashboardUrlValue = ((ServiceInstance)instance).getDashboardUrl()) != null) {
                    this.dashboardUrl(dashboardUrlValue);
                }
                if ((metadataValue = ((ServiceInstance)instance).getMetadata()) != null) {
                    this.metadata(metadataValue);
                }
                if ((lastOperationValue = ((ServiceInstance)instance).getLastOperation()) != null) {
                    this.lastOperation(lastOperationValue);
                }
                this.name(((ServiceInstance)instance).getName());
                ServiceInstanceType typeValue = ((ServiceInstance)instance).getType();
                if (typeValue != null) {
                    this.type(typeValue);
                }
                if ((routeServiceUrlValue = ((ServiceInstance)instance).getRouteServiceUrl()) != null) {
                    this.routeServiceUrl(routeServiceUrlValue);
                }
                if ((updateAvailableValue = ((ServiceInstance)instance).getUpdateAvailable()) != null) {
                    this.updateAvailable(updateAvailableValue);
                }
                if ((maintenanceInfoValue = ((ServiceInstance)instance).getMaintenanceInfo()) != null) {
                    this.maintenanceInfo(maintenanceInfoValue);
                }
                if ((syslogDrainUrlValue = ((ServiceInstance)instance).getSyslogDrainUrl()) != null) {
                    this.syslogDrainUrl(syslogDrainUrlValue);
                }
                if ((tagsValue = ((ServiceInstance)instance).getTags()) != null) {
                    this.addAllTags(tagsValue);
                }
            }
            if (object instanceof Resource) {
                instance = (Resource)object;
                this.createdAt(instance.getCreatedAt());
                this.putAllLinks(instance.getLinks());
                this.id(instance.getId());
                String updatedAtValue = instance.getUpdatedAt();
                if (updatedAtValue != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
        }

        @JsonProperty(value="created_at")
        public final Builder createdAt(String createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder link(String key, Link value) {
            this.links.put(key, value);
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(k, v);
            return this;
        }

        @JsonProperty(value="links")
        public final Builder links(Map<String, ? extends Link> entries) {
            this.links.clear();
            return this.putAllLinks(entries);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> entries) {
            for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
                String k = e.getKey();
                Link v = e.getValue();
                this.links.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="updated_at")
        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty(value="dashboard_url")
        public final Builder dashboardUrl(@Nullable String dashboardUrl) {
            this.dashboardUrl = dashboardUrl;
            return this;
        }

        @JsonProperty(value="last_operation")
        public final Builder lastOperation(@Nullable LastOperation lastOperation) {
            this.lastOperation = lastOperation;
            return this;
        }

        @JsonProperty(value="maintenance_info")
        public final Builder maintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
            this.maintenanceInfo = maintenanceInfo;
            return this;
        }

        @JsonProperty(value="metadata")
        public final Builder metadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="relationships")
        public final Builder relationships(@Nullable ServiceInstanceRelationships relationships) {
            this.relationships = relationships;
            return this;
        }

        @JsonProperty(value="route_service_url")
        public final Builder routeServiceUrl(@Nullable String routeServiceUrl) {
            this.routeServiceUrl = routeServiceUrl;
            return this;
        }

        @JsonProperty(value="syslog_drain_url")
        public final Builder syslogDrainUrl(@Nullable String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
            return this;
        }

        public final Builder tag(String element) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.add(Objects.requireNonNull(element, "tags element"));
            return this;
        }

        public final Builder tags(String ... elements) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        @JsonProperty(value="tags")
        public final Builder tags(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.tags = null;
                return this;
            }
            this.tags = new ArrayList<String>();
            return this.addAllTags(elements);
        }

        public final Builder addAllTags(Iterable<String> elements) {
            Objects.requireNonNull(elements, "tags element");
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(@Nullable ServiceInstanceType type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="upgrade_available")
        public final Builder updateAvailable(@Nullable Boolean updateAvailable) {
            this.updateAvailable = updateAvailable;
            return this;
        }

        public GetServiceInstanceResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetServiceInstanceResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build GetServiceInstanceResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_GetServiceInstanceResponse", generator="Immutables")
    static final class Json
    extends _GetServiceInstanceResponse {
        String createdAt;
        String id;
        Map<String, Link> links = Collections.emptyMap();
        String updatedAt;
        String dashboardUrl;
        LastOperation lastOperation;
        MaintenanceInfo maintenanceInfo;
        Metadata metadata;
        String name;
        ServiceInstanceRelationships relationships;
        String routeServiceUrl;
        String syslogDrainUrl;
        List<String> tags = null;
        ServiceInstanceType type;
        Boolean updateAvailable;

        Json() {
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="guid")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="links")
        public void setLinks(Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="dashboard_url")
        public void setDashboardUrl(@Nullable String dashboardUrl) {
            this.dashboardUrl = dashboardUrl;
        }

        @JsonProperty(value="last_operation")
        public void setLastOperation(@Nullable LastOperation lastOperation) {
            this.lastOperation = lastOperation;
        }

        @JsonProperty(value="maintenance_info")
        public void setMaintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
            this.maintenanceInfo = maintenanceInfo;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="relationships")
        public void setRelationships(@Nullable ServiceInstanceRelationships relationships) {
            this.relationships = relationships;
        }

        @JsonProperty(value="route_service_url")
        public void setRouteServiceUrl(@Nullable String routeServiceUrl) {
            this.routeServiceUrl = routeServiceUrl;
        }

        @JsonProperty(value="syslog_drain_url")
        public void setSyslogDrainUrl(@Nullable String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
        }

        @JsonProperty(value="tags")
        public void setTags(@Nullable List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="type")
        public void setType(@Nullable ServiceInstanceType type) {
            this.type = type;
        }

        @JsonProperty(value="upgrade_available")
        public void setUpdateAvailable(@Nullable Boolean updateAvailable) {
            this.updateAvailable = updateAvailable;
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDashboardUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LastOperation getLastOperation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MaintenanceInfo getMaintenanceInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServiceInstanceRelationships getRelationships() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRouteServiceUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSyslogDrainUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServiceInstanceType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getUpdateAvailable() {
            throw new UnsupportedOperationException();
        }
    }
}

