/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum RefreshTokenFormat {
    JWT("jwt"),
    OPAQUE("opaque");

    private final String value;

    private RefreshTokenFormat(String value) {
        this.value = value;
    }

    @JsonCreator
    public static RefreshTokenFormat from(String s) {
        switch (s.toLowerCase()) {
            case "jwt": {
                return JWT;
            }
            case "opaque": {
                return OPAQUE;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown refresh token format: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

