package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request options for the restart application instance operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_RestartApplicationInstanceRequest", generator = "Immutables")
public final class RestartApplicationInstanceRequest
    extends org.cloudfoundry.operations.applications._RestartApplicationInstanceRequest {
  private final Integer instanceIndex;
  private final String name;

  private RestartApplicationInstanceRequest(RestartApplicationInstanceRequest.Builder builder) {
    this.instanceIndex = builder.instanceIndex;
    this.name = builder.name;
  }

  /**
   * The index of the instance
   */
  @Override
  public Integer getInstanceIndex() {
    return instanceIndex;
  }

  /**
   * The name of the application
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code RestartApplicationInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RestartApplicationInstanceRequest
        && equalTo((RestartApplicationInstanceRequest) another);
  }

  private boolean equalTo(RestartApplicationInstanceRequest another) {
    return instanceIndex.equals(another.instanceIndex)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code instanceIndex}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + instanceIndex.hashCode();
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RestartApplicationInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RestartApplicationInstanceRequest{"
        + "instanceIndex=" + instanceIndex
        + ", name=" + name
        + "}";
  }

  /**
   * Creates a builder for {@link RestartApplicationInstanceRequest RestartApplicationInstanceRequest}.
   * @return A new RestartApplicationInstanceRequest builder
   */
  public static RestartApplicationInstanceRequest.Builder builder() {
    return new RestartApplicationInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link RestartApplicationInstanceRequest RestartApplicationInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_INSTANCE_INDEX = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private long initBits = 0x3L;

    private Integer instanceIndex;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RestartApplicationInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RestartApplicationInstanceRequest instance) {
      return from((_RestartApplicationInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RestartApplicationInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RestartApplicationInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      instanceIndex(instance.getInstanceIndex());
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link RestartApplicationInstanceRequest#getInstanceIndex() instanceIndex} attribute.
     * @param instanceIndex The value for instanceIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceIndex(Integer instanceIndex) {
      this.instanceIndex = Objects.requireNonNull(instanceIndex, "instanceIndex");
      initBits &= ~INIT_BIT_INSTANCE_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link RestartApplicationInstanceRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link RestartApplicationInstanceRequest RestartApplicationInstanceRequest}.
     * @return An immutable instance of RestartApplicationInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RestartApplicationInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RestartApplicationInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_INSTANCE_INDEX) != 0) attributes.add("instanceIndex");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build RestartApplicationInstanceRequest, some of required attributes are not set " + attributes;
    }
  }
}
