package org.cloudfoundry.operations.routes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request options for the map route operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_MapRouteRequest", generator = "Immutables")
public final class MapRouteRequest extends org.cloudfoundry.operations.routes._MapRouteRequest {
  private final String applicationName;
  private final String domain;
  private final @Nullable String host;
  private final @Nullable String path;
  private final @Nullable Integer port;
  private final @Nullable Boolean randomPort;

  private MapRouteRequest(MapRouteRequest.Builder builder) {
    this.applicationName = builder.applicationName;
    this.domain = builder.domain;
    this.host = builder.host;
    this.path = builder.path;
    this.port = builder.port;
    this.randomPort = builder.randomPort;
  }

  /**
   * The name of the application to have a route added to it
   */
  @Override
  public String getApplicationName() {
    return applicationName;
  }

  /**
   * The domain of the route
   */
  @Override
  public String getDomain() {
    return domain;
  }

  /**
   * The host of the route
   */
  @Override
  public @Nullable String getHost() {
    return host;
  }

  /**
   * The path of the route.
   * <p>
   * Note: the path is specified without a leading "/"
   */
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * The port of the route
   */
  @Override
  public @Nullable Integer getPort() {
    return port;
  }

  /**
   * Generate a random port
   */
  @Override
  public @Nullable Boolean getRandomPort() {
    return randomPort;
  }

  /**
   * This instance is equal to all instances of {@code MapRouteRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof MapRouteRequest
        && equalTo((MapRouteRequest) another);
  }

  private boolean equalTo(MapRouteRequest another) {
    return applicationName.equals(another.applicationName)
        && domain.equals(another.domain)
        && Objects.equals(host, another.host)
        && Objects.equals(path, another.path)
        && Objects.equals(port, another.port)
        && Objects.equals(randomPort, another.randomPort);
  }

  /**
   * Computes a hash code from attributes: {@code applicationName}, {@code domain}, {@code host}, {@code path}, {@code port}, {@code randomPort}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationName.hashCode();
    h += (h << 5) + domain.hashCode();
    h += (h << 5) + Objects.hashCode(host);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(port);
    h += (h << 5) + Objects.hashCode(randomPort);
    return h;
  }

  /**
   * Prints the immutable value {@code MapRouteRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MapRouteRequest{"
        + "applicationName=" + applicationName
        + ", domain=" + domain
        + ", host=" + host
        + ", path=" + path
        + ", port=" + port
        + ", randomPort=" + randomPort
        + "}";
  }


  private static MapRouteRequest validate(MapRouteRequest instance) {
    instance.checkSetup();
    instance.checkPorts();
    return instance;
  }

  /**
   * Creates a builder for {@link MapRouteRequest MapRouteRequest}.
   * @return A new MapRouteRequest builder
   */
  public static MapRouteRequest.Builder builder() {
    return new MapRouteRequest.Builder();
  }

  /**
   * Builds instances of type {@link MapRouteRequest MapRouteRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_NAME = 0x1L;
    private static final long INIT_BIT_DOMAIN = 0x2L;
    private long initBits = 0x3L;

    private String applicationName;
    private String domain;
    private String host;
    private String path;
    private Integer port;
    private Boolean randomPort;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MapRouteRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MapRouteRequest instance) {
      return from((_MapRouteRequest) instance);
    }

    /**
     * Copy abstract value type {@code _MapRouteRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_MapRouteRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationName(instance.getApplicationName());
      domain(instance.getDomain());
      String hostValue = instance.getHost();
      if (hostValue != null) {
        host(hostValue);
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      Integer portValue = instance.getPort();
      if (portValue != null) {
        port(portValue);
      }
      Boolean randomPortValue = instance.getRandomPort();
      if (randomPortValue != null) {
        randomPort(randomPortValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link MapRouteRequest#getApplicationName() applicationName} attribute.
     * @param applicationName The value for applicationName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationName(String applicationName) {
      this.applicationName = Objects.requireNonNull(applicationName, "applicationName");
      initBits &= ~INIT_BIT_APPLICATION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link MapRouteRequest#getDomain() domain} attribute.
     * @param domain The value for domain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domain(String domain) {
      this.domain = Objects.requireNonNull(domain, "domain");
      initBits &= ~INIT_BIT_DOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link MapRouteRequest#getHost() host} attribute.
     * @param host The value for host (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(@Nullable String host) {
      this.host = host;
      return this;
    }

    /**
     * Initializes the value for the {@link MapRouteRequest#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link MapRouteRequest#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(@Nullable Integer port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the value for the {@link MapRouteRequest#getRandomPort() randomPort} attribute.
     * @param randomPort The value for randomPort (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder randomPort(@Nullable Boolean randomPort) {
      this.randomPort = randomPort;
      return this;
    }

    /**
     * Builds a new {@link MapRouteRequest MapRouteRequest}.
     * @return An immutable instance of MapRouteRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public MapRouteRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return MapRouteRequest.validate(new MapRouteRequest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_NAME) != 0) attributes.add("applicationName");
      if ((initBits & INIT_BIT_DOMAIN) != 0) attributes.add("domain");
      return "Cannot build MapRouteRequest, some of required attributes are not set " + attributes;
    }
  }
}
