package org.cloudfoundry.operations.services;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request options for the delete service instance operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_DeleteServiceInstanceRequest", generator = "Immutables")
public final class DeleteServiceInstanceRequest
    extends org.cloudfoundry.operations.services._DeleteServiceInstanceRequest {
  private final Duration completionTimeout;
  private final String name;

  private DeleteServiceInstanceRequest(DeleteServiceInstanceRequest.Builder builder) {
    this.name = builder.name;
    this.completionTimeout = builder.completionTimeout != null
        ? builder.completionTimeout
        : Objects.requireNonNull(super.getCompletionTimeout(), "completionTimeout");
  }

  /**
   * How long to wait for deletion
   */
  @Override
  public Duration getCompletionTimeout() {
    return completionTimeout;
  }

  /**
   * The name of the service instance
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code DeleteServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteServiceInstanceRequest
        && equalTo((DeleteServiceInstanceRequest) another);
  }

  private boolean equalTo(DeleteServiceInstanceRequest another) {
    return completionTimeout.equals(another.completionTimeout)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code completionTimeout}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + completionTimeout.hashCode();
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteServiceInstanceRequest{"
        + "completionTimeout=" + completionTimeout
        + ", name=" + name
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteServiceInstanceRequest DeleteServiceInstanceRequest}.
   * @return A new DeleteServiceInstanceRequest builder
   */
  public static DeleteServiceInstanceRequest.Builder builder() {
    return new DeleteServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteServiceInstanceRequest DeleteServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private Duration completionTimeout;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteServiceInstanceRequest instance) {
      return from((_DeleteServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      completionTimeout(instance.getCompletionTimeout());
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteServiceInstanceRequest#getCompletionTimeout() completionTimeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DeleteServiceInstanceRequest#getCompletionTimeout() completionTimeout}.</em>
     * @param completionTimeout The value for completionTimeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder completionTimeout(Duration completionTimeout) {
      this.completionTimeout = Objects.requireNonNull(completionTimeout, "completionTimeout");
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteServiceInstanceRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link DeleteServiceInstanceRequest DeleteServiceInstanceRequest}.
     * @return An immutable instance of DeleteServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build DeleteServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }
}
