package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request options for the unbind service instance operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_UnbindRouteServiceInstanceRequest", generator = "Immutables")
public final class UnbindRouteServiceInstanceRequest
    extends org.cloudfoundry.operations.services._UnbindRouteServiceInstanceRequest {
  private final String domainName;
  private final @Nullable String hostname;
  private final @Nullable String path;
  private final String serviceInstanceName;

  private UnbindRouteServiceInstanceRequest(UnbindRouteServiceInstanceRequest.Builder builder) {
    this.domainName = builder.domainName;
    this.hostname = builder.hostname;
    this.path = builder.path;
    this.serviceInstanceName = builder.serviceInstanceName;
  }

  /**
   * The domain for the bound route
   */
  @Override
  public String getDomainName() {
    return domainName;
  }

  /**
   * The hostname for the bound route
   */
  @Override
  public @Nullable String getHostname() {
    return hostname;
  }

  /**
   * The path for the bound route
   */
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * The name of the service instance to bind
   */
  @Override
  public String getServiceInstanceName() {
    return serviceInstanceName;
  }

  /**
   * This instance is equal to all instances of {@code UnbindRouteServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UnbindRouteServiceInstanceRequest
        && equalTo((UnbindRouteServiceInstanceRequest) another);
  }

  private boolean equalTo(UnbindRouteServiceInstanceRequest another) {
    return domainName.equals(another.domainName)
        && Objects.equals(hostname, another.hostname)
        && Objects.equals(path, another.path)
        && serviceInstanceName.equals(another.serviceInstanceName);
  }

  /**
   * Computes a hash code from attributes: {@code domainName}, {@code hostname}, {@code path}, {@code serviceInstanceName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + domainName.hashCode();
    h += (h << 5) + Objects.hashCode(hostname);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + serviceInstanceName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UnbindRouteServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UnbindRouteServiceInstanceRequest{"
        + "domainName=" + domainName
        + ", hostname=" + hostname
        + ", path=" + path
        + ", serviceInstanceName=" + serviceInstanceName
        + "}";
  }

  /**
   * Creates a builder for {@link UnbindRouteServiceInstanceRequest UnbindRouteServiceInstanceRequest}.
   * @return A new UnbindRouteServiceInstanceRequest builder
   */
  public static UnbindRouteServiceInstanceRequest.Builder builder() {
    return new UnbindRouteServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link UnbindRouteServiceInstanceRequest UnbindRouteServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN_NAME = 0x1L;
    private static final long INIT_BIT_SERVICE_INSTANCE_NAME = 0x2L;
    private long initBits = 0x3L;

    private String domainName;
    private String hostname;
    private String path;
    private String serviceInstanceName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UnbindRouteServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UnbindRouteServiceInstanceRequest instance) {
      return from((_UnbindRouteServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UnbindRouteServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UnbindRouteServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      domainName(instance.getDomainName());
      String hostnameValue = instance.getHostname();
      if (hostnameValue != null) {
        hostname(hostnameValue);
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      serviceInstanceName(instance.getServiceInstanceName());
      return this;
    }

    /**
     * Initializes the value for the {@link UnbindRouteServiceInstanceRequest#getDomainName() domainName} attribute.
     * @param domainName The value for domainName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainName(String domainName) {
      this.domainName = Objects.requireNonNull(domainName, "domainName");
      initBits &= ~INIT_BIT_DOMAIN_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UnbindRouteServiceInstanceRequest#getHostname() hostname} attribute.
     * @param hostname The value for hostname (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder hostname(@Nullable String hostname) {
      this.hostname = hostname;
      return this;
    }

    /**
     * Initializes the value for the {@link UnbindRouteServiceInstanceRequest#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link UnbindRouteServiceInstanceRequest#getServiceInstanceName() serviceInstanceName} attribute.
     * @param serviceInstanceName The value for serviceInstanceName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceName(String serviceInstanceName) {
      this.serviceInstanceName = Objects.requireNonNull(serviceInstanceName, "serviceInstanceName");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_NAME;
      return this;
    }

    /**
     * Builds a new {@link UnbindRouteServiceInstanceRequest UnbindRouteServiceInstanceRequest}.
     * @return An immutable instance of UnbindRouteServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UnbindRouteServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UnbindRouteServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DOMAIN_NAME) != 0) attributes.add("domainName");
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_NAME) != 0) attributes.add("serviceInstanceName");
      return "Cannot build UnbindRouteServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }
}
