/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.applications._CopySourceApplicationRequest;
import org.immutables.value.Generated;

@Generated(from="_CopySourceApplicationRequest", generator="Immutables")
public final class CopySourceApplicationRequest
extends _CopySourceApplicationRequest {
    private final String name;
    @Nullable
    private final Boolean restart;
    private final Duration stagingTimeout;
    private final Duration startupTimeout;
    private final String targetName;
    @Nullable
    private final String targetOrganization;
    @Nullable
    private final String targetSpace;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private CopySourceApplicationRequest(Builder builder) {
        this.name = builder.name;
        this.restart = builder.restart;
        this.targetName = builder.targetName;
        this.targetOrganization = builder.targetOrganization;
        this.targetSpace = builder.targetSpace;
        if (builder.stagingTimeout != null) {
            this.initShim.stagingTimeout(builder.stagingTimeout);
        }
        if (builder.startupTimeout != null) {
            this.initShim.startupTimeout(builder.startupTimeout);
        }
        this.stagingTimeout = this.initShim.getStagingTimeout();
        this.startupTimeout = this.initShim.getStartupTimeout();
        this.initShim = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Boolean getRestart() {
        return this.restart;
    }

    @Override
    public Duration getStagingTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getStagingTimeout() : this.stagingTimeout;
    }

    @Override
    public Duration getStartupTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getStartupTimeout() : this.startupTimeout;
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    @Nullable
    public String getTargetOrganization() {
        return this.targetOrganization;
    }

    @Override
    @Nullable
    public String getTargetSpace() {
        return this.targetSpace;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CopySourceApplicationRequest && this.equalTo((CopySourceApplicationRequest)another);
    }

    private boolean equalTo(CopySourceApplicationRequest another) {
        return this.name.equals(another.name) && Objects.equals(this.restart, another.restart) && this.stagingTimeout.equals(another.stagingTimeout) && this.startupTimeout.equals(another.startupTimeout) && this.targetName.equals(another.targetName) && Objects.equals(this.targetOrganization, another.targetOrganization) && Objects.equals(this.targetSpace, another.targetSpace);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.restart);
        h += (h << 5) + this.stagingTimeout.hashCode();
        h += (h << 5) + this.startupTimeout.hashCode();
        h += (h << 5) + this.targetName.hashCode();
        h += (h << 5) + Objects.hashCode(this.targetOrganization);
        h += (h << 5) + Objects.hashCode(this.targetSpace);
        return h;
    }

    public String toString() {
        return "CopySourceApplicationRequest{name=" + this.name + ", restart=" + this.restart + ", stagingTimeout=" + this.stagingTimeout + ", startupTimeout=" + this.startupTimeout + ", targetName=" + this.targetName + ", targetOrganization=" + this.targetOrganization + ", targetSpace=" + this.targetSpace + "}";
    }

    private static CopySourceApplicationRequest validate(CopySourceApplicationRequest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_TARGET_NAME = 2L;
        private long initBits = 3L;
        private String name;
        private Boolean restart;
        private Duration stagingTimeout;
        private Duration startupTimeout;
        private String targetName;
        private String targetOrganization;
        private String targetSpace;

        private Builder() {
        }

        public final Builder from(CopySourceApplicationRequest instance) {
            return this.from((_CopySourceApplicationRequest)instance);
        }

        final Builder from(_CopySourceApplicationRequest instance) {
            String targetSpaceValue;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            Boolean restartValue = instance.getRestart();
            if (restartValue != null) {
                this.restart(restartValue);
            }
            this.stagingTimeout(instance.getStagingTimeout());
            this.startupTimeout(instance.getStartupTimeout());
            this.targetName(instance.getTargetName());
            String targetOrganizationValue = instance.getTargetOrganization();
            if (targetOrganizationValue != null) {
                this.targetOrganization(targetOrganizationValue);
            }
            if ((targetSpaceValue = instance.getTargetSpace()) != null) {
                this.targetSpace(targetSpaceValue);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder restart(@Nullable Boolean restart) {
            this.restart = restart;
            return this;
        }

        public final Builder stagingTimeout(Duration stagingTimeout) {
            this.stagingTimeout = Objects.requireNonNull(stagingTimeout, "stagingTimeout");
            return this;
        }

        public final Builder startupTimeout(Duration startupTimeout) {
            this.startupTimeout = Objects.requireNonNull(startupTimeout, "startupTimeout");
            return this;
        }

        public final Builder targetName(String targetName) {
            this.targetName = Objects.requireNonNull(targetName, "targetName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder targetOrganization(@Nullable String targetOrganization) {
            this.targetOrganization = targetOrganization;
            return this;
        }

        public final Builder targetSpace(@Nullable String targetSpace) {
            this.targetSpace = targetSpace;
            return this;
        }

        public CopySourceApplicationRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return CopySourceApplicationRequest.validate(new CopySourceApplicationRequest(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("targetName");
            }
            return "Cannot build CopySourceApplicationRequest, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte stagingTimeoutBuildStage = 0;
        private Duration stagingTimeout;
        private byte startupTimeoutBuildStage = 0;
        private Duration startupTimeout;

        private InitShim() {
        }

        Duration getStagingTimeout() {
            if (this.stagingTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.stagingTimeoutBuildStage == 0) {
                this.stagingTimeoutBuildStage = (byte)-1;
                this.stagingTimeout = Objects.requireNonNull(CopySourceApplicationRequest.super.getStagingTimeout(), "stagingTimeout");
                this.stagingTimeoutBuildStage = 1;
            }
            return this.stagingTimeout;
        }

        void stagingTimeout(Duration stagingTimeout) {
            this.stagingTimeout = stagingTimeout;
            this.stagingTimeoutBuildStage = 1;
        }

        Duration getStartupTimeout() {
            if (this.startupTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.startupTimeoutBuildStage == 0) {
                this.startupTimeoutBuildStage = (byte)-1;
                this.startupTimeout = Objects.requireNonNull(CopySourceApplicationRequest.super.getStartupTimeout(), "startupTimeout");
                this.startupTimeoutBuildStage = 1;
            }
            return this.startupTimeout;
        }

        void startupTimeout(Duration startupTimeout) {
            this.startupTimeout = startupTimeout;
            this.startupTimeoutBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.stagingTimeoutBuildStage == -1) {
                attributes.add("stagingTimeout");
            }
            if (this.startupTimeoutBuildStage == -1) {
                attributes.add("startupTimeout");
            }
            return "Cannot build CopySourceApplicationRequest, attribute initializers form cycle " + attributes;
        }
    }
}

