/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.organizations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.operations.organizations.OrganizationQuota;
import org.cloudfoundry.operations.organizations._OrganizationDetail;
import org.cloudfoundry.operations.spaceadmin.SpaceQuota;
import org.immutables.value.Generated;

@Generated(from="_OrganizationDetail", generator="Immutables")
public final class OrganizationDetail
extends _OrganizationDetail {
    private final List<String> domains;
    private final String id;
    private final String name;
    private final OrganizationQuota quota;
    private final List<SpaceQuota> spaceQuotas;
    private final List<String> spaces;

    private OrganizationDetail(Builder builder) {
        this.domains = OrganizationDetail.createUnmodifiableList(true, builder.domains);
        this.id = builder.id;
        this.name = builder.name;
        this.quota = builder.quota;
        this.spaceQuotas = OrganizationDetail.createUnmodifiableList(true, builder.spaceQuotas);
        this.spaces = OrganizationDetail.createUnmodifiableList(true, builder.spaces);
    }

    @Override
    public List<String> getDomains() {
        return this.domains;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OrganizationQuota getQuota() {
        return this.quota;
    }

    @Override
    public List<SpaceQuota> getSpaceQuotas() {
        return this.spaceQuotas;
    }

    @Override
    public List<String> getSpaces() {
        return this.spaces;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OrganizationDetail && this.equalTo((OrganizationDetail)another);
    }

    private boolean equalTo(OrganizationDetail another) {
        return this.domains.equals(another.domains) && this.id.equals(another.id) && this.name.equals(another.name) && this.quota.equals(another.quota) && this.spaceQuotas.equals(another.spaceQuotas) && this.spaces.equals(another.spaces);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.domains.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.quota.hashCode();
        h += (h << 5) + this.spaceQuotas.hashCode();
        h += (h << 5) + this.spaces.hashCode();
        return h;
    }

    public String toString() {
        return "OrganizationDetail{domains=" + this.domains + ", id=" + this.id + ", name=" + this.name + ", quota=" + this.quota + ", spaceQuotas=" + this.spaceQuotas + ", spaces=" + this.spaces + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_QUOTA = 4L;
        private long initBits = 7L;
        private List<String> domains = new ArrayList<String>();
        private String id;
        private String name;
        private OrganizationQuota quota;
        private List<SpaceQuota> spaceQuotas = new ArrayList<SpaceQuota>();
        private List<String> spaces = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(OrganizationDetail instance) {
            return this.from((_OrganizationDetail)instance);
        }

        final Builder from(_OrganizationDetail instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllDomains(instance.getDomains());
            this.id(instance.getId());
            this.name(instance.getName());
            this.quota(instance.getQuota());
            this.addAllSpaceQuotas(instance.getSpaceQuotas());
            this.addAllSpaces(instance.getSpaces());
            return this;
        }

        public final Builder domain(String element) {
            this.domains.add(Objects.requireNonNull(element, "domains element"));
            return this;
        }

        public final Builder domains(String ... elements) {
            for (String element : elements) {
                this.domains.add(Objects.requireNonNull(element, "domains element"));
            }
            return this;
        }

        public final Builder domains(Iterable<String> elements) {
            this.domains.clear();
            return this.addAllDomains(elements);
        }

        public final Builder addAllDomains(Iterable<String> elements) {
            for (String element : elements) {
                this.domains.add(Objects.requireNonNull(element, "domains element"));
            }
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder quota(OrganizationQuota quota) {
            this.quota = Objects.requireNonNull(quota, "quota");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder spaceQuota(SpaceQuota element) {
            this.spaceQuotas.add(Objects.requireNonNull(element, "spaceQuotas element"));
            return this;
        }

        public final Builder spaceQuotas(SpaceQuota ... elements) {
            for (SpaceQuota element : elements) {
                this.spaceQuotas.add(Objects.requireNonNull(element, "spaceQuotas element"));
            }
            return this;
        }

        public final Builder spaceQuotas(Iterable<? extends SpaceQuota> elements) {
            this.spaceQuotas.clear();
            return this.addAllSpaceQuotas(elements);
        }

        public final Builder addAllSpaceQuotas(Iterable<? extends SpaceQuota> elements) {
            for (SpaceQuota spaceQuota : elements) {
                this.spaceQuotas.add(Objects.requireNonNull(spaceQuota, "spaceQuotas element"));
            }
            return this;
        }

        public final Builder space(String element) {
            this.spaces.add(Objects.requireNonNull(element, "spaces element"));
            return this;
        }

        public final Builder spaces(String ... elements) {
            for (String element : elements) {
                this.spaces.add(Objects.requireNonNull(element, "spaces element"));
            }
            return this;
        }

        public final Builder spaces(Iterable<String> elements) {
            this.spaces.clear();
            return this.addAllSpaces(elements);
        }

        public final Builder addAllSpaces(Iterable<String> elements) {
            for (String element : elements) {
                this.spaces.add(Objects.requireNonNull(element, "spaces element"));
            }
            return this;
        }

        public OrganizationDetail build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new OrganizationDetail(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("quota");
            }
            return "Cannot build OrganizationDetail, some of required attributes are not set " + attributes;
        }
    }
}

