package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request options for the run application task operation
 */
@Generated(from = "_RunApplicationTaskRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class RunApplicationTaskRequest
    extends org.cloudfoundry.operations.applications._RunApplicationTaskRequest {
  private final String applicationName;
  private final String command;
  private final @Nullable Integer disk;
  private final @Nullable Integer memory;
  private final @Nullable String taskName;

  private RunApplicationTaskRequest(RunApplicationTaskRequest.Builder builder) {
    this.applicationName = builder.applicationName;
    this.command = builder.command;
    this.disk = builder.disk;
    this.memory = builder.memory;
    this.taskName = builder.taskName;
  }

  /**
   * The name of the application
   */
  @Override
  public String getApplicationName() {
    return applicationName;
  }

  /**
   * The command for the task
   */
  @Override
  public String getCommand() {
    return command;
  }

  /**
   * The disk limit in megabytes
   */
  @Override
  public @Nullable Integer getDisk() {
    return disk;
  }

  /**
   * The memory limit in megabytes
   */
  @Override
  public @Nullable Integer getMemory() {
    return memory;
  }

  /**
   * The name of the task
   */
  @Override
  public @Nullable String getTaskName() {
    return taskName;
  }

  /**
   * This instance is equal to all instances of {@code RunApplicationTaskRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RunApplicationTaskRequest
        && equalTo((RunApplicationTaskRequest) another);
  }

  private boolean equalTo(RunApplicationTaskRequest another) {
    return applicationName.equals(another.applicationName)
        && command.equals(another.command)
        && Objects.equals(disk, another.disk)
        && Objects.equals(memory, another.memory)
        && Objects.equals(taskName, another.taskName);
  }

  /**
   * Computes a hash code from attributes: {@code applicationName}, {@code command}, {@code disk}, {@code memory}, {@code taskName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationName.hashCode();
    h += (h << 5) + command.hashCode();
    h += (h << 5) + Objects.hashCode(disk);
    h += (h << 5) + Objects.hashCode(memory);
    h += (h << 5) + Objects.hashCode(taskName);
    return h;
  }

  /**
   * Prints the immutable value {@code RunApplicationTaskRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RunApplicationTaskRequest{"
        + "applicationName=" + applicationName
        + ", command=" + command
        + ", disk=" + disk
        + ", memory=" + memory
        + ", taskName=" + taskName
        + "}";
  }

  /**
   * Creates a builder for {@link RunApplicationTaskRequest RunApplicationTaskRequest}.
   * @return A new RunApplicationTaskRequest builder
   */
  public static RunApplicationTaskRequest.Builder builder() {
    return new RunApplicationTaskRequest.Builder();
  }

  /**
   * Builds instances of type {@link RunApplicationTaskRequest RunApplicationTaskRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_RunApplicationTaskRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_NAME = 0x1L;
    private static final long INIT_BIT_COMMAND = 0x2L;
    private long initBits = 0x3L;

    private String applicationName;
    private String command;
    private Integer disk;
    private Integer memory;
    private String taskName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RunApplicationTaskRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RunApplicationTaskRequest instance) {
      return from((_RunApplicationTaskRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RunApplicationTaskRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RunApplicationTaskRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationName(instance.getApplicationName());
      command(instance.getCommand());
      Integer diskValue = instance.getDisk();
      if (diskValue != null) {
        disk(diskValue);
      }
      Integer memoryValue = instance.getMemory();
      if (memoryValue != null) {
        memory(memoryValue);
      }
      String taskNameValue = instance.getTaskName();
      if (taskNameValue != null) {
        taskName(taskNameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link RunApplicationTaskRequest#getApplicationName() applicationName} attribute.
     * @param applicationName The value for applicationName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationName(String applicationName) {
      this.applicationName = Objects.requireNonNull(applicationName, "applicationName");
      initBits &= ~INIT_BIT_APPLICATION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link RunApplicationTaskRequest#getCommand() command} attribute.
     * @param command The value for command 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder command(String command) {
      this.command = Objects.requireNonNull(command, "command");
      initBits &= ~INIT_BIT_COMMAND;
      return this;
    }

    /**
     * Initializes the value for the {@link RunApplicationTaskRequest#getDisk() disk} attribute.
     * @param disk The value for disk (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder disk(@Nullable Integer disk) {
      this.disk = disk;
      return this;
    }

    /**
     * Initializes the value for the {@link RunApplicationTaskRequest#getMemory() memory} attribute.
     * @param memory The value for memory (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memory(@Nullable Integer memory) {
      this.memory = memory;
      return this;
    }

    /**
     * Initializes the value for the {@link RunApplicationTaskRequest#getTaskName() taskName} attribute.
     * @param taskName The value for taskName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder taskName(@Nullable String taskName) {
      this.taskName = taskName;
      return this;
    }

    /**
     * Builds a new {@link RunApplicationTaskRequest RunApplicationTaskRequest}.
     * @return An immutable instance of RunApplicationTaskRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RunApplicationTaskRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RunApplicationTaskRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_NAME) != 0) attributes.add("applicationName");
      if ((initBits & INIT_BIT_COMMAND) != 0) attributes.add("command");
      return "Cannot build RunApplicationTaskRequest, some of required attributes are not set " + attributes;
    }
  }
}
