package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request options for the set environment variable of an application operation
 */
@Generated(from = "_SetEnvironmentVariableApplicationRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class SetEnvironmentVariableApplicationRequest
    extends org.cloudfoundry.operations.applications._SetEnvironmentVariableApplicationRequest {
  private final String name;
  private final String variableName;
  private final String variableValue;

  private SetEnvironmentVariableApplicationRequest(SetEnvironmentVariableApplicationRequest.Builder builder) {
    this.name = builder.name;
    this.variableName = builder.variableName;
    this.variableValue = builder.variableValue;
  }

  /**
   * The application name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The variable name
   */
  @Override
  public String getVariableName() {
    return variableName;
  }

  /**
   * The variable value
   */
  @Override
  public String getVariableValue() {
    return variableValue;
  }

  /**
   * This instance is equal to all instances of {@code SetEnvironmentVariableApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SetEnvironmentVariableApplicationRequest
        && equalTo((SetEnvironmentVariableApplicationRequest) another);
  }

  private boolean equalTo(SetEnvironmentVariableApplicationRequest another) {
    return name.equals(another.name)
        && variableName.equals(another.variableName)
        && variableValue.equals(another.variableValue);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code variableName}, {@code variableValue}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + variableName.hashCode();
    h += (h << 5) + variableValue.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SetEnvironmentVariableApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SetEnvironmentVariableApplicationRequest{"
        + "name=" + name
        + ", variableName=" + variableName
        + ", variableValue=" + variableValue
        + "}";
  }

  /**
   * Creates a builder for {@link SetEnvironmentVariableApplicationRequest SetEnvironmentVariableApplicationRequest}.
   * @return A new SetEnvironmentVariableApplicationRequest builder
   */
  public static SetEnvironmentVariableApplicationRequest.Builder builder() {
    return new SetEnvironmentVariableApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link SetEnvironmentVariableApplicationRequest SetEnvironmentVariableApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_SetEnvironmentVariableApplicationRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_VARIABLE_NAME = 0x2L;
    private static final long INIT_BIT_VARIABLE_VALUE = 0x4L;
    private long initBits = 0x7L;

    private String name;
    private String variableName;
    private String variableValue;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SetEnvironmentVariableApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SetEnvironmentVariableApplicationRequest instance) {
      return from((_SetEnvironmentVariableApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _SetEnvironmentVariableApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SetEnvironmentVariableApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      variableName(instance.getVariableName());
      variableValue(instance.getVariableValue());
      return this;
    }

    /**
     * Initializes the value for the {@link SetEnvironmentVariableApplicationRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link SetEnvironmentVariableApplicationRequest#getVariableName() variableName} attribute.
     * @param variableName The value for variableName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder variableName(String variableName) {
      this.variableName = Objects.requireNonNull(variableName, "variableName");
      initBits &= ~INIT_BIT_VARIABLE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link SetEnvironmentVariableApplicationRequest#getVariableValue() variableValue} attribute.
     * @param variableValue The value for variableValue 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder variableValue(String variableValue) {
      this.variableValue = Objects.requireNonNull(variableValue, "variableValue");
      initBits &= ~INIT_BIT_VARIABLE_VALUE;
      return this;
    }

    /**
     * Builds a new {@link SetEnvironmentVariableApplicationRequest SetEnvironmentVariableApplicationRequest}.
     * @return An immutable instance of SetEnvironmentVariableApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SetEnvironmentVariableApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new SetEnvironmentVariableApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_VARIABLE_NAME) != 0) attributes.add("variableName");
      if ((initBits & INIT_BIT_VARIABLE_VALUE) != 0) attributes.add("variableValue");
      return "Cannot build SetEnvironmentVariableApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
