package org.cloudfoundry.operations.networkpolicies;

import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request options for the list network policies operation
 */
@Generated(from = "_ListNetworkPoliciesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListNetworkPoliciesRequest
    extends org.cloudfoundry.operations.networkpolicies._ListNetworkPoliciesRequest {
  private final @Nullable String source;

  private ListNetworkPoliciesRequest(ListNetworkPoliciesRequest.Builder builder) {
    this.source = builder.source;
  }

  /**
   * Name of the source to filter on
   */
  @Override
  public @Nullable String getSource() {
    return source;
  }

  /**
   * This instance is equal to all instances of {@code ListNetworkPoliciesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListNetworkPoliciesRequest
        && equalTo((ListNetworkPoliciesRequest) another);
  }

  private boolean equalTo(ListNetworkPoliciesRequest another) {
    return Objects.equals(source, another.source);
  }

  /**
   * Computes a hash code from attributes: {@code source}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(source);
    return h;
  }

  /**
   * Prints the immutable value {@code ListNetworkPoliciesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListNetworkPoliciesRequest{"
        + "source=" + source
        + "}";
  }

  /**
   * Creates a builder for {@link ListNetworkPoliciesRequest ListNetworkPoliciesRequest}.
   * @return A new ListNetworkPoliciesRequest builder
   */
  public static ListNetworkPoliciesRequest.Builder builder() {
    return new ListNetworkPoliciesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListNetworkPoliciesRequest ListNetworkPoliciesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListNetworkPoliciesRequest", generator = "Immutables")
  public static final class Builder {
    private String source;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListNetworkPoliciesRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListNetworkPoliciesRequest instance) {
      return from((_ListNetworkPoliciesRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ListNetworkPoliciesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListNetworkPoliciesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String sourceValue = instance.getSource();
      if (sourceValue != null) {
        source(sourceValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListNetworkPoliciesRequest#getSource() source} attribute.
     * @param source The value for source (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder source(@Nullable String source) {
      this.source = source;
      return this;
    }

    /**
     * Builds a new {@link ListNetworkPoliciesRequest ListNetworkPoliciesRequest}.
     * @return An immutable instance of ListNetworkPoliciesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListNetworkPoliciesRequest build() {
      return new ListNetworkPoliciesRequest(this);
    }
  }
}
