package org.cloudfoundry.operations.useradmin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request options for the list organization users operation
 */
@Generated(from = "_ListOrganizationUsersRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListOrganizationUsersRequest
    extends org.cloudfoundry.operations.useradmin._ListOrganizationUsersRequest {
  private final String organizationName;

  private ListOrganizationUsersRequest(ListOrganizationUsersRequest.Builder builder) {
    this.organizationName = builder.organizationName;
  }

  /**
   * Organization name to list
   */
  @Override
  public String getOrganizationName() {
    return organizationName;
  }

  /**
   * This instance is equal to all instances of {@code ListOrganizationUsersRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListOrganizationUsersRequest
        && equalTo((ListOrganizationUsersRequest) another);
  }

  private boolean equalTo(ListOrganizationUsersRequest another) {
    return organizationName.equals(another.organizationName);
  }

  /**
   * Computes a hash code from attributes: {@code organizationName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + organizationName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListOrganizationUsersRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListOrganizationUsersRequest{"
        + "organizationName=" + organizationName
        + "}";
  }

  /**
   * Creates a builder for {@link ListOrganizationUsersRequest ListOrganizationUsersRequest}.
   * @return A new ListOrganizationUsersRequest builder
   */
  public static ListOrganizationUsersRequest.Builder builder() {
    return new ListOrganizationUsersRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListOrganizationUsersRequest ListOrganizationUsersRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListOrganizationUsersRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_NAME = 0x1L;
    private long initBits = 0x1L;

    private String organizationName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListOrganizationUsersRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListOrganizationUsersRequest instance) {
      return from((_ListOrganizationUsersRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ListOrganizationUsersRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListOrganizationUsersRequest instance) {
      Objects.requireNonNull(instance, "instance");
      organizationName(instance.getOrganizationName());
      return this;
    }

    /**
     * Initializes the value for the {@link ListOrganizationUsersRequest#getOrganizationName() organizationName} attribute.
     * @param organizationName The value for organizationName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationName(String organizationName) {
      this.organizationName = Objects.requireNonNull(organizationName, "organizationName");
      initBits &= ~INIT_BIT_ORGANIZATION_NAME;
      return this;
    }

    /**
     * Builds a new {@link ListOrganizationUsersRequest ListOrganizationUsersRequest}.
     * @return An immutable instance of ListOrganizationUsersRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListOrganizationUsersRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListOrganizationUsersRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_NAME) != 0) attributes.add("organizationName");
      return "Cannot build ListOrganizationUsersRequest, some of required attributes are not set " + attributes;
    }
  }
}
