/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.cloudfoundry.operations.applications._PushApplicationRequest;
import org.immutables.value.Generated;

@Generated(from="_PushApplicationRequest", generator="Immutables")
public final class PushApplicationRequest
extends _PushApplicationRequest {
    @Nullable
    private final Path application;
    @Nullable
    private final String buildpack;
    @Nullable
    private final String command;
    @Nullable
    private final Integer diskQuota;
    @Nullable
    private final String dockerImage;
    @Nullable
    private final String dockerPassword;
    @Nullable
    private final String dockerUsername;
    @Nullable
    private final String domain;
    @Nullable
    private final ApplicationHealthCheck healthCheckType;
    @Nullable
    private final String host;
    @Nullable
    private final Integer instances;
    @Nullable
    private final Integer memory;
    private final String name;
    @Nullable
    private final Boolean noHostname;
    @Nullable
    private final Boolean noRoute;
    @Nullable
    private final Boolean noStart;
    @Nullable
    private final Path path;
    @Nullable
    private final Boolean randomRoute;
    @Nullable
    private final String routePath;
    @Nullable
    private final String stack;
    private final Duration stagingTimeout;
    private final Duration startupTimeout;
    @Nullable
    private final Integer timeout;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private PushApplicationRequest(Builder builder) {
        this.application = builder.application;
        this.buildpack = builder.buildpack;
        this.command = builder.command;
        this.diskQuota = builder.diskQuota;
        this.dockerImage = builder.dockerImage;
        this.dockerPassword = builder.dockerPassword;
        this.dockerUsername = builder.dockerUsername;
        this.domain = builder.domain;
        this.healthCheckType = builder.healthCheckType;
        this.host = builder.host;
        this.instances = builder.instances;
        this.memory = builder.memory;
        this.name = builder.name;
        this.noHostname = builder.noHostname;
        this.noRoute = builder.noRoute;
        this.noStart = builder.noStart;
        this.path = builder.path;
        this.randomRoute = builder.randomRoute;
        this.routePath = builder.routePath;
        this.stack = builder.stack;
        this.timeout = builder.timeout;
        if (builder.stagingTimeout != null) {
            this.initShim.stagingTimeout(builder.stagingTimeout);
        }
        if (builder.startupTimeout != null) {
            this.initShim.startupTimeout(builder.startupTimeout);
        }
        this.stagingTimeout = this.initShim.getStagingTimeout();
        this.startupTimeout = this.initShim.getStartupTimeout();
        this.initShim = null;
    }

    @Override
    @Deprecated
    @Nullable
    public Path getApplication() {
        return this.application;
    }

    @Override
    @Nullable
    public String getBuildpack() {
        return this.buildpack;
    }

    @Override
    @Nullable
    public String getCommand() {
        return this.command;
    }

    @Override
    @Nullable
    public Integer getDiskQuota() {
        return this.diskQuota;
    }

    @Override
    @Nullable
    public String getDockerImage() {
        return this.dockerImage;
    }

    @Override
    @Nullable
    public String getDockerPassword() {
        return this.dockerPassword;
    }

    @Override
    @Nullable
    public String getDockerUsername() {
        return this.dockerUsername;
    }

    @Override
    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Override
    @Nullable
    public ApplicationHealthCheck getHealthCheckType() {
        return this.healthCheckType;
    }

    @Override
    @Nullable
    public String getHost() {
        return this.host;
    }

    @Override
    @Nullable
    public Integer getInstances() {
        return this.instances;
    }

    @Override
    @Nullable
    public Integer getMemory() {
        return this.memory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Boolean getNoHostname() {
        return this.noHostname;
    }

    @Override
    @Nullable
    public Boolean getNoRoute() {
        return this.noRoute;
    }

    @Override
    @Nullable
    public Boolean getNoStart() {
        return this.noStart;
    }

    @Override
    @Nullable
    public Path getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public Boolean getRandomRoute() {
        return this.randomRoute;
    }

    @Override
    @Nullable
    public String getRoutePath() {
        return this.routePath;
    }

    @Override
    @Nullable
    public String getStack() {
        return this.stack;
    }

    @Override
    public Duration getStagingTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getStagingTimeout() : this.stagingTimeout;
    }

    @Override
    public Duration getStartupTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getStartupTimeout() : this.startupTimeout;
    }

    @Override
    @Nullable
    public Integer getTimeout() {
        return this.timeout;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PushApplicationRequest && this.equalTo((PushApplicationRequest)another);
    }

    private boolean equalTo(PushApplicationRequest another) {
        return Objects.equals(this.application, another.application) && Objects.equals(this.buildpack, another.buildpack) && Objects.equals(this.command, another.command) && Objects.equals(this.diskQuota, another.diskQuota) && Objects.equals(this.dockerImage, another.dockerImage) && Objects.equals(this.dockerPassword, another.dockerPassword) && Objects.equals(this.dockerUsername, another.dockerUsername) && Objects.equals(this.domain, another.domain) && Objects.equals((Object)this.healthCheckType, (Object)another.healthCheckType) && Objects.equals(this.host, another.host) && Objects.equals(this.instances, another.instances) && Objects.equals(this.memory, another.memory) && this.name.equals(another.name) && Objects.equals(this.noHostname, another.noHostname) && Objects.equals(this.noRoute, another.noRoute) && Objects.equals(this.noStart, another.noStart) && Objects.equals(this.path, another.path) && Objects.equals(this.randomRoute, another.randomRoute) && Objects.equals(this.routePath, another.routePath) && Objects.equals(this.stack, another.stack) && this.stagingTimeout.equals(another.stagingTimeout) && this.startupTimeout.equals(another.startupTimeout) && Objects.equals(this.timeout, another.timeout);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.application);
        h += (h << 5) + Objects.hashCode(this.buildpack);
        h += (h << 5) + Objects.hashCode(this.command);
        h += (h << 5) + Objects.hashCode(this.diskQuota);
        h += (h << 5) + Objects.hashCode(this.dockerImage);
        h += (h << 5) + Objects.hashCode(this.dockerPassword);
        h += (h << 5) + Objects.hashCode(this.dockerUsername);
        h += (h << 5) + Objects.hashCode(this.domain);
        h += (h << 5) + Objects.hashCode((Object)this.healthCheckType);
        h += (h << 5) + Objects.hashCode(this.host);
        h += (h << 5) + Objects.hashCode(this.instances);
        h += (h << 5) + Objects.hashCode(this.memory);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.noHostname);
        h += (h << 5) + Objects.hashCode(this.noRoute);
        h += (h << 5) + Objects.hashCode(this.noStart);
        h += (h << 5) + Objects.hashCode(this.path);
        h += (h << 5) + Objects.hashCode(this.randomRoute);
        h += (h << 5) + Objects.hashCode(this.routePath);
        h += (h << 5) + Objects.hashCode(this.stack);
        h += (h << 5) + this.stagingTimeout.hashCode();
        h += (h << 5) + this.startupTimeout.hashCode();
        h += (h << 5) + Objects.hashCode(this.timeout);
        return h;
    }

    public String toString() {
        return "PushApplicationRequest{application=" + this.application + ", buildpack=" + this.buildpack + ", command=" + this.command + ", diskQuota=" + this.diskQuota + ", dockerImage=" + this.dockerImage + ", dockerPassword=" + this.dockerPassword + ", dockerUsername=" + this.dockerUsername + ", domain=" + this.domain + ", healthCheckType=" + (Object)((Object)this.healthCheckType) + ", host=" + this.host + ", instances=" + this.instances + ", memory=" + this.memory + ", name=" + this.name + ", noHostname=" + this.noHostname + ", noRoute=" + this.noRoute + ", noStart=" + this.noStart + ", path=" + this.path + ", randomRoute=" + this.randomRoute + ", routePath=" + this.routePath + ", stack=" + this.stack + ", stagingTimeout=" + this.stagingTimeout + ", startupTimeout=" + this.startupTimeout + ", timeout=" + this.timeout + "}";
    }

    private static PushApplicationRequest validate(PushApplicationRequest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_PushApplicationRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private Path application;
        private String buildpack;
        private String command;
        private Integer diskQuota;
        private String dockerImage;
        private String dockerPassword;
        private String dockerUsername;
        private String domain;
        private ApplicationHealthCheck healthCheckType;
        private String host;
        private Integer instances;
        private Integer memory;
        private String name;
        private Boolean noHostname;
        private Boolean noRoute;
        private Boolean noStart;
        private Path path;
        private Boolean randomRoute;
        private String routePath;
        private String stack;
        private Duration stagingTimeout;
        private Duration startupTimeout;
        private Integer timeout;

        private Builder() {
        }

        public final Builder from(PushApplicationRequest instance) {
            return this.from((_PushApplicationRequest)instance);
        }

        final Builder from(_PushApplicationRequest instance) {
            String stackValue;
            String routePathValue;
            Boolean randomRouteValue;
            Path pathValue;
            Boolean noStartValue;
            Boolean noRouteValue;
            Integer memoryValue;
            Integer instancesValue;
            String hostValue;
            ApplicationHealthCheck healthCheckTypeValue;
            String domainValue;
            String dockerUsernameValue;
            String dockerPasswordValue;
            String dockerImageValue;
            Integer diskQuotaValue;
            String commandValue;
            String buildpackValue;
            Objects.requireNonNull(instance, "instance");
            Path applicationValue = instance.getApplication();
            if (applicationValue != null) {
                this.application(applicationValue);
            }
            if ((buildpackValue = instance.getBuildpack()) != null) {
                this.buildpack(buildpackValue);
            }
            if ((commandValue = instance.getCommand()) != null) {
                this.command(commandValue);
            }
            if ((diskQuotaValue = instance.getDiskQuota()) != null) {
                this.diskQuota(diskQuotaValue);
            }
            if ((dockerImageValue = instance.getDockerImage()) != null) {
                this.dockerImage(dockerImageValue);
            }
            if ((dockerPasswordValue = instance.getDockerPassword()) != null) {
                this.dockerPassword(dockerPasswordValue);
            }
            if ((dockerUsernameValue = instance.getDockerUsername()) != null) {
                this.dockerUsername(dockerUsernameValue);
            }
            if ((domainValue = instance.getDomain()) != null) {
                this.domain(domainValue);
            }
            if ((healthCheckTypeValue = instance.getHealthCheckType()) != null) {
                this.healthCheckType(healthCheckTypeValue);
            }
            if ((hostValue = instance.getHost()) != null) {
                this.host(hostValue);
            }
            if ((instancesValue = instance.getInstances()) != null) {
                this.instances(instancesValue);
            }
            if ((memoryValue = instance.getMemory()) != null) {
                this.memory(memoryValue);
            }
            this.name(instance.getName());
            Boolean noHostnameValue = instance.getNoHostname();
            if (noHostnameValue != null) {
                this.noHostname(noHostnameValue);
            }
            if ((noRouteValue = instance.getNoRoute()) != null) {
                this.noRoute(noRouteValue);
            }
            if ((noStartValue = instance.getNoStart()) != null) {
                this.noStart(noStartValue);
            }
            if ((pathValue = instance.getPath()) != null) {
                this.path(pathValue);
            }
            if ((randomRouteValue = instance.getRandomRoute()) != null) {
                this.randomRoute(randomRouteValue);
            }
            if ((routePathValue = instance.getRoutePath()) != null) {
                this.routePath(routePathValue);
            }
            if ((stackValue = instance.getStack()) != null) {
                this.stack(stackValue);
            }
            this.stagingTimeout(instance.getStagingTimeout());
            this.startupTimeout(instance.getStartupTimeout());
            Integer timeoutValue = instance.getTimeout();
            if (timeoutValue != null) {
                this.timeout(timeoutValue);
            }
            return this;
        }

        @Deprecated
        public final Builder application(@Nullable Path application) {
            this.application = application;
            return this;
        }

        public final Builder buildpack(@Nullable String buildpack) {
            this.buildpack = buildpack;
            return this;
        }

        public final Builder command(@Nullable String command) {
            this.command = command;
            return this;
        }

        public final Builder diskQuota(@Nullable Integer diskQuota) {
            this.diskQuota = diskQuota;
            return this;
        }

        public final Builder dockerImage(@Nullable String dockerImage) {
            this.dockerImage = dockerImage;
            return this;
        }

        public final Builder dockerPassword(@Nullable String dockerPassword) {
            this.dockerPassword = dockerPassword;
            return this;
        }

        public final Builder dockerUsername(@Nullable String dockerUsername) {
            this.dockerUsername = dockerUsername;
            return this;
        }

        public final Builder domain(@Nullable String domain) {
            this.domain = domain;
            return this;
        }

        public final Builder healthCheckType(@Nullable ApplicationHealthCheck healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final Builder host(@Nullable String host) {
            this.host = host;
            return this;
        }

        public final Builder instances(@Nullable Integer instances) {
            this.instances = instances;
            return this;
        }

        public final Builder memory(@Nullable Integer memory) {
            this.memory = memory;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder noHostname(@Nullable Boolean noHostname) {
            this.noHostname = noHostname;
            return this;
        }

        public final Builder noRoute(@Nullable Boolean noRoute) {
            this.noRoute = noRoute;
            return this;
        }

        public final Builder noStart(@Nullable Boolean noStart) {
            this.noStart = noStart;
            return this;
        }

        public final Builder path(@Nullable Path path) {
            this.path = path;
            return this;
        }

        public final Builder randomRoute(@Nullable Boolean randomRoute) {
            this.randomRoute = randomRoute;
            return this;
        }

        public final Builder routePath(@Nullable String routePath) {
            this.routePath = routePath;
            return this;
        }

        public final Builder stack(@Nullable String stack) {
            this.stack = stack;
            return this;
        }

        public final Builder stagingTimeout(Duration stagingTimeout) {
            this.stagingTimeout = Objects.requireNonNull(stagingTimeout, "stagingTimeout");
            return this;
        }

        public final Builder startupTimeout(Duration startupTimeout) {
            this.startupTimeout = Objects.requireNonNull(startupTimeout, "startupTimeout");
            return this;
        }

        public final Builder timeout(@Nullable Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public PushApplicationRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return PushApplicationRequest.validate(new PushApplicationRequest(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build PushApplicationRequest, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="_PushApplicationRequest", generator="Immutables")
    private final class InitShim {
        private byte stagingTimeoutBuildStage = 0;
        private Duration stagingTimeout;
        private byte startupTimeoutBuildStage = 0;
        private Duration startupTimeout;

        private InitShim() {
        }

        Duration getStagingTimeout() {
            if (this.stagingTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.stagingTimeoutBuildStage == 0) {
                this.stagingTimeoutBuildStage = (byte)-1;
                this.stagingTimeout = Objects.requireNonNull(PushApplicationRequest.super.getStagingTimeout(), "stagingTimeout");
                this.stagingTimeoutBuildStage = 1;
            }
            return this.stagingTimeout;
        }

        void stagingTimeout(Duration stagingTimeout) {
            this.stagingTimeout = stagingTimeout;
            this.stagingTimeoutBuildStage = 1;
        }

        Duration getStartupTimeout() {
            if (this.startupTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.startupTimeoutBuildStage == 0) {
                this.startupTimeoutBuildStage = (byte)-1;
                this.startupTimeout = Objects.requireNonNull(PushApplicationRequest.super.getStartupTimeout(), "startupTimeout");
                this.startupTimeoutBuildStage = 1;
            }
            return this.startupTimeout;
        }

        void startupTimeout(Duration startupTimeout) {
            this.startupTimeout = startupTimeout;
            this.startupTimeoutBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.stagingTimeoutBuildStage == -1) {
                attributes.add("stagingTimeout");
            }
            if (this.startupTimeoutBuildStage == -1) {
                attributes.add("startupTimeout");
            }
            return "Cannot build PushApplicationRequest, attribute initializers form cycle " + attributes;
        }
    }
}

