/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.applications._ScaleApplicationRequest;

public final class ScaleApplicationRequest
extends _ScaleApplicationRequest {
    @Nullable
    private final Integer diskLimit;
    @Nullable
    private final Integer instances;
    @Nullable
    private final Integer memoryLimit;
    private final String name;
    private final Duration stagingTimeout;
    private final Duration startupTimeout;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ScaleApplicationRequest(Builder builder) {
        this.diskLimit = builder.diskLimit;
        this.instances = builder.instances;
        this.memoryLimit = builder.memoryLimit;
        this.name = builder.name;
        if (builder.stagingTimeout != null) {
            this.initShim.stagingTimeout(builder.stagingTimeout);
        }
        if (builder.startupTimeout != null) {
            this.initShim.startupTimeout(builder.startupTimeout);
        }
        this.stagingTimeout = this.initShim.getStagingTimeout();
        this.startupTimeout = this.initShim.getStartupTimeout();
        this.initShim = null;
    }

    @Override
    @Nullable
    public Integer getDiskLimit() {
        return this.diskLimit;
    }

    @Override
    @Nullable
    public Integer getInstances() {
        return this.instances;
    }

    @Override
    @Nullable
    public Integer getMemoryLimit() {
        return this.memoryLimit;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Duration getStagingTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getStagingTimeout() : this.stagingTimeout;
    }

    @Override
    public Duration getStartupTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getStartupTimeout() : this.startupTimeout;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ScaleApplicationRequest && this.equalTo((ScaleApplicationRequest)another);
    }

    private boolean equalTo(ScaleApplicationRequest another) {
        return Objects.equals(this.diskLimit, another.diskLimit) && Objects.equals(this.instances, another.instances) && Objects.equals(this.memoryLimit, another.memoryLimit) && this.name.equals(another.name) && this.stagingTimeout.equals(another.stagingTimeout) && this.startupTimeout.equals(another.startupTimeout);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.diskLimit);
        h += (h << 5) + Objects.hashCode(this.instances);
        h += (h << 5) + Objects.hashCode(this.memoryLimit);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.stagingTimeout.hashCode();
        h += (h << 5) + this.startupTimeout.hashCode();
        return h;
    }

    public String toString() {
        return "ScaleApplicationRequest{diskLimit=" + this.diskLimit + ", instances=" + this.instances + ", memoryLimit=" + this.memoryLimit + ", name=" + this.name + ", stagingTimeout=" + this.stagingTimeout + ", startupTimeout=" + this.startupTimeout + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private Integer diskLimit;
        private Integer instances;
        private Integer memoryLimit;
        private String name;
        private Duration stagingTimeout;
        private Duration startupTimeout;

        private Builder() {
        }

        public final Builder from(ScaleApplicationRequest instance) {
            return this.from((_ScaleApplicationRequest)instance);
        }

        final Builder from(_ScaleApplicationRequest instance) {
            Integer memoryLimitValue;
            Integer instancesValue;
            Objects.requireNonNull(instance, "instance");
            Integer diskLimitValue = instance.getDiskLimit();
            if (diskLimitValue != null) {
                this.diskLimit(diskLimitValue);
            }
            if ((instancesValue = instance.getInstances()) != null) {
                this.instances(instancesValue);
            }
            if ((memoryLimitValue = instance.getMemoryLimit()) != null) {
                this.memoryLimit(memoryLimitValue);
            }
            this.name(instance.getName());
            this.stagingTimeout(instance.getStagingTimeout());
            this.startupTimeout(instance.getStartupTimeout());
            return this;
        }

        public final Builder diskLimit(@Nullable Integer diskLimit) {
            this.diskLimit = diskLimit;
            return this;
        }

        public final Builder instances(@Nullable Integer instances) {
            this.instances = instances;
            return this;
        }

        public final Builder memoryLimit(@Nullable Integer memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder stagingTimeout(Duration stagingTimeout) {
            this.stagingTimeout = Objects.requireNonNull(stagingTimeout, "stagingTimeout");
            return this;
        }

        public final Builder startupTimeout(Duration startupTimeout) {
            this.startupTimeout = Objects.requireNonNull(startupTimeout, "startupTimeout");
            return this;
        }

        public ScaleApplicationRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ScaleApplicationRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build ScaleApplicationRequest, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private Duration stagingTimeout;
        private int stagingTimeoutBuildStage;
        private Duration startupTimeout;
        private int startupTimeoutBuildStage;

        private InitShim() {
        }

        Duration getStagingTimeout() {
            if (this.stagingTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.stagingTimeoutBuildStage == 0) {
                this.stagingTimeoutBuildStage = -1;
                this.stagingTimeout = Objects.requireNonNull(ScaleApplicationRequest.super.getStagingTimeout(), "stagingTimeout");
                this.stagingTimeoutBuildStage = 1;
            }
            return this.stagingTimeout;
        }

        void stagingTimeout(Duration stagingTimeout) {
            this.stagingTimeout = stagingTimeout;
            this.stagingTimeoutBuildStage = 1;
        }

        Duration getStartupTimeout() {
            if (this.startupTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.startupTimeoutBuildStage == 0) {
                this.startupTimeoutBuildStage = -1;
                this.startupTimeout = Objects.requireNonNull(ScaleApplicationRequest.super.getStartupTimeout(), "startupTimeout");
                this.startupTimeoutBuildStage = 1;
            }
            return this.startupTimeout;
        }

        void startupTimeout(Duration startupTimeout) {
            this.startupTimeout = startupTimeout;
            this.startupTimeoutBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.stagingTimeoutBuildStage == -1) {
                attributes.add("stagingTimeout");
            }
            if (this.startupTimeoutBuildStage == -1) {
                attributes.add("startupTimeout");
            }
            return "Cannot build ScaleApplicationRequest, attribute initializers form cycle" + attributes;
        }
    }
}

