package org.cloudfoundry.operations.useradmin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request options for the unset organization role operation
 */
@Generated(from = "_UnsetOrganizationRoleRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UnsetOrganizationRoleRequest
    extends org.cloudfoundry.operations.useradmin._UnsetOrganizationRoleRequest {
  private final String organizationName;
  private final OrganizationRole organizationRole;
  private final String username;

  private UnsetOrganizationRoleRequest(UnsetOrganizationRoleRequest.Builder builder) {
    this.organizationName = builder.organizationName;
    this.organizationRole = builder.organizationRole;
    this.username = builder.username;
  }

  /**
   * Organization name
   */
  @Override
  public String getOrganizationName() {
    return organizationName;
  }

  /**
   * Role
   */
  @Override
  public OrganizationRole getOrganizationRole() {
    return organizationRole;
  }

  /**
   * Username
   */
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code UnsetOrganizationRoleRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UnsetOrganizationRoleRequest
        && equalTo((UnsetOrganizationRoleRequest) another);
  }

  private boolean equalTo(UnsetOrganizationRoleRequest another) {
    return organizationName.equals(another.organizationName)
        && organizationRole.equals(another.organizationRole)
        && username.equals(another.username);
  }

  /**
   * Computes a hash code from attributes: {@code organizationName}, {@code organizationRole}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + organizationName.hashCode();
    h += (h << 5) + organizationRole.hashCode();
    h += (h << 5) + username.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UnsetOrganizationRoleRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UnsetOrganizationRoleRequest{"
        + "organizationName=" + organizationName
        + ", organizationRole=" + organizationRole
        + ", username=" + username
        + "}";
  }

  /**
   * Creates a builder for {@link UnsetOrganizationRoleRequest UnsetOrganizationRoleRequest}.
   * <pre>
   * UnsetOrganizationRoleRequest.builder()
   *    .organizationName(String) // required {@link UnsetOrganizationRoleRequest#getOrganizationName() organizationName}
   *    .organizationRole(org.cloudfoundry.operations.useradmin.OrganizationRole) // required {@link UnsetOrganizationRoleRequest#getOrganizationRole() organizationRole}
   *    .username(String) // required {@link UnsetOrganizationRoleRequest#getUsername() username}
   *    .build();
   * </pre>
   * @return A new UnsetOrganizationRoleRequest builder
   */
  public static UnsetOrganizationRoleRequest.Builder builder() {
    return new UnsetOrganizationRoleRequest.Builder();
  }

  /**
   * Builds instances of type {@link UnsetOrganizationRoleRequest UnsetOrganizationRoleRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UnsetOrganizationRoleRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_NAME = 0x1L;
    private static final long INIT_BIT_ORGANIZATION_ROLE = 0x2L;
    private static final long INIT_BIT_USERNAME = 0x4L;
    private long initBits = 0x7L;

    private String organizationName;
    private OrganizationRole organizationRole;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UnsetOrganizationRoleRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UnsetOrganizationRoleRequest instance) {
      return from((_UnsetOrganizationRoleRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UnsetOrganizationRoleRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UnsetOrganizationRoleRequest instance) {
      Objects.requireNonNull(instance, "instance");
      organizationName(instance.getOrganizationName());
      organizationRole(instance.getOrganizationRole());
      username(instance.getUsername());
      return this;
    }

    /**
     * Initializes the value for the {@link UnsetOrganizationRoleRequest#getOrganizationName() organizationName} attribute.
     * @param organizationName The value for organizationName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationName(String organizationName) {
      this.organizationName = Objects.requireNonNull(organizationName, "organizationName");
      initBits &= ~INIT_BIT_ORGANIZATION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UnsetOrganizationRoleRequest#getOrganizationRole() organizationRole} attribute.
     * @param organizationRole The value for organizationRole 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationRole(OrganizationRole organizationRole) {
      this.organizationRole = Objects.requireNonNull(organizationRole, "organizationRole");
      initBits &= ~INIT_BIT_ORGANIZATION_ROLE;
      return this;
    }

    /**
     * Initializes the value for the {@link UnsetOrganizationRoleRequest#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Builds a new {@link UnsetOrganizationRoleRequest UnsetOrganizationRoleRequest}.
     * @return An immutable instance of UnsetOrganizationRoleRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UnsetOrganizationRoleRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UnsetOrganizationRoleRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_NAME) != 0) attributes.add("organizationName");
      if ((initBits & INIT_BIT_ORGANIZATION_ROLE) != 0) attributes.add("organizationRole");
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      return "Cannot build UnsetOrganizationRoleRequest, some of required attributes are not set " + attributes;
    }
  }
}
