/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.applications.ApplicationManifest;
import org.cloudfoundry.operations.applications._PushApplicationManifestRequest;
import org.immutables.value.Generated;

@Generated(from="_PushApplicationManifestRequest", generator="Immutables")
public final class PushApplicationManifestRequest
extends _PushApplicationManifestRequest {
    @Nullable
    private final String dockerPassword;
    @Nullable
    private final String dockerUsername;
    private final List<ApplicationManifest> manifests;
    @Nullable
    private final Boolean noStart;
    private final Duration stagingTimeout;
    private final Duration startupTimeout;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private PushApplicationManifestRequest(Builder builder) {
        this.dockerPassword = builder.dockerPassword;
        this.dockerUsername = builder.dockerUsername;
        this.manifests = PushApplicationManifestRequest.createUnmodifiableList(true, builder.manifests);
        this.noStart = builder.noStart;
        if (builder.stagingTimeout != null) {
            this.initShim.stagingTimeout(builder.stagingTimeout);
        }
        if (builder.startupTimeout != null) {
            this.initShim.startupTimeout(builder.startupTimeout);
        }
        this.stagingTimeout = this.initShim.getStagingTimeout();
        this.startupTimeout = this.initShim.getStartupTimeout();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String getDockerPassword() {
        return this.dockerPassword;
    }

    @Override
    @Nullable
    public String getDockerUsername() {
        return this.dockerUsername;
    }

    @Override
    public List<ApplicationManifest> getManifests() {
        return this.manifests;
    }

    @Override
    @Nullable
    public Boolean getNoStart() {
        return this.noStart;
    }

    @Override
    public Duration getStagingTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getStagingTimeout() : this.stagingTimeout;
    }

    @Override
    public Duration getStartupTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getStartupTimeout() : this.startupTimeout;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PushApplicationManifestRequest && this.equalTo((PushApplicationManifestRequest)another);
    }

    private boolean equalTo(PushApplicationManifestRequest another) {
        return Objects.equals(this.dockerPassword, another.dockerPassword) && Objects.equals(this.dockerUsername, another.dockerUsername) && this.manifests.equals(another.manifests) && Objects.equals(this.noStart, another.noStart) && this.stagingTimeout.equals(another.stagingTimeout) && this.startupTimeout.equals(another.startupTimeout);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.dockerPassword);
        h += (h << 5) + Objects.hashCode(this.dockerUsername);
        h += (h << 5) + this.manifests.hashCode();
        h += (h << 5) + Objects.hashCode(this.noStart);
        h += (h << 5) + this.stagingTimeout.hashCode();
        h += (h << 5) + this.startupTimeout.hashCode();
        return h;
    }

    public String toString() {
        return "PushApplicationManifestRequest{dockerPassword=" + this.dockerPassword + ", dockerUsername=" + this.dockerUsername + ", manifests=" + this.manifests + ", noStart=" + this.noStart + ", stagingTimeout=" + this.stagingTimeout + ", startupTimeout=" + this.startupTimeout + "}";
    }

    private static PushApplicationManifestRequest validate(PushApplicationManifestRequest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_PushApplicationManifestRequest", generator="Immutables")
    public static final class Builder {
        private String dockerPassword;
        private String dockerUsername;
        private List<ApplicationManifest> manifests = new ArrayList<ApplicationManifest>();
        private Boolean noStart;
        private Duration stagingTimeout;
        private Duration startupTimeout;

        private Builder() {
        }

        public final Builder from(PushApplicationManifestRequest instance) {
            return this.from((_PushApplicationManifestRequest)instance);
        }

        final Builder from(_PushApplicationManifestRequest instance) {
            String dockerUsernameValue;
            Objects.requireNonNull(instance, "instance");
            String dockerPasswordValue = instance.getDockerPassword();
            if (dockerPasswordValue != null) {
                this.dockerPassword(dockerPasswordValue);
            }
            if ((dockerUsernameValue = instance.getDockerUsername()) != null) {
                this.dockerUsername(dockerUsernameValue);
            }
            this.addAllManifests(instance.getManifests());
            Boolean noStartValue = instance.getNoStart();
            if (noStartValue != null) {
                this.noStart(noStartValue);
            }
            this.stagingTimeout(instance.getStagingTimeout());
            this.startupTimeout(instance.getStartupTimeout());
            return this;
        }

        public final Builder dockerPassword(@Nullable String dockerPassword) {
            this.dockerPassword = dockerPassword;
            return this;
        }

        public final Builder dockerUsername(@Nullable String dockerUsername) {
            this.dockerUsername = dockerUsername;
            return this;
        }

        public final Builder manifest(ApplicationManifest element) {
            this.manifests.add(Objects.requireNonNull(element, "manifests element"));
            return this;
        }

        public final Builder manifests(ApplicationManifest ... elements) {
            for (ApplicationManifest element : elements) {
                this.manifests.add(Objects.requireNonNull(element, "manifests element"));
            }
            return this;
        }

        public final Builder manifests(Iterable<? extends ApplicationManifest> elements) {
            this.manifests.clear();
            return this.addAllManifests(elements);
        }

        public final Builder addAllManifests(Iterable<? extends ApplicationManifest> elements) {
            for (ApplicationManifest applicationManifest : elements) {
                this.manifests.add(Objects.requireNonNull(applicationManifest, "manifests element"));
            }
            return this;
        }

        public final Builder noStart(@Nullable Boolean noStart) {
            this.noStart = noStart;
            return this;
        }

        public final Builder stagingTimeout(Duration stagingTimeout) {
            this.stagingTimeout = Objects.requireNonNull(stagingTimeout, "stagingTimeout");
            return this;
        }

        public final Builder startupTimeout(Duration startupTimeout) {
            this.startupTimeout = Objects.requireNonNull(startupTimeout, "startupTimeout");
            return this;
        }

        public PushApplicationManifestRequest build() {
            return PushApplicationManifestRequest.validate(new PushApplicationManifestRequest(this));
        }
    }

    @Generated(from="_PushApplicationManifestRequest", generator="Immutables")
    private final class InitShim {
        private byte stagingTimeoutBuildStage = 0;
        private Duration stagingTimeout;
        private byte startupTimeoutBuildStage = 0;
        private Duration startupTimeout;

        private InitShim() {
        }

        Duration getStagingTimeout() {
            if (this.stagingTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.stagingTimeoutBuildStage == 0) {
                this.stagingTimeoutBuildStage = (byte)-1;
                this.stagingTimeout = Objects.requireNonNull(PushApplicationManifestRequest.super.getStagingTimeout(), "stagingTimeout");
                this.stagingTimeoutBuildStage = 1;
            }
            return this.stagingTimeout;
        }

        void stagingTimeout(Duration stagingTimeout) {
            this.stagingTimeout = stagingTimeout;
            this.stagingTimeoutBuildStage = 1;
        }

        Duration getStartupTimeout() {
            if (this.startupTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.startupTimeoutBuildStage == 0) {
                this.startupTimeoutBuildStage = (byte)-1;
                this.startupTimeout = Objects.requireNonNull(PushApplicationManifestRequest.super.getStartupTimeout(), "startupTimeout");
                this.startupTimeoutBuildStage = 1;
            }
            return this.startupTimeout;
        }

        void startupTimeout(Duration startupTimeout) {
            this.startupTimeout = startupTimeout;
            this.startupTimeoutBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.stagingTimeoutBuildStage == -1) {
                attributes.add("stagingTimeout");
            }
            if (this.startupTimeoutBuildStage == -1) {
                attributes.add("startupTimeout");
            }
            return "Cannot build PushApplicationManifestRequest, attribute initializers form cycle " + attributes;
        }
    }
}

