/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.services;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.MaintenanceInfo;
import org.cloudfoundry.operations.services._UpdateServiceInstanceRequest;
import org.immutables.value.Generated;

@Generated(from="_UpdateServiceInstanceRequest", generator="Immutables")
public final class UpdateServiceInstanceRequest
extends _UpdateServiceInstanceRequest {
    private final Duration completionTimeout;
    @Nullable
    private final MaintenanceInfo maintenanceInfo;
    @Nullable
    private final Map<String, Object> parameters;
    @Nullable
    private final String planName;
    private final String serviceInstanceName;
    @Nullable
    private final List<String> tags;

    private UpdateServiceInstanceRequest(Builder builder) {
        this.maintenanceInfo = builder.maintenanceInfo;
        this.parameters = builder.parameters == null ? null : UpdateServiceInstanceRequest.createUnmodifiableMap(false, false, builder.parameters);
        this.planName = builder.planName;
        this.serviceInstanceName = builder.serviceInstanceName;
        this.tags = builder.tags == null ? null : UpdateServiceInstanceRequest.createUnmodifiableList(true, builder.tags);
        this.completionTimeout = builder.completionTimeout != null ? builder.completionTimeout : Objects.requireNonNull(super.getCompletionTimeout(), "completionTimeout");
    }

    @Override
    public Duration getCompletionTimeout() {
        return this.completionTimeout;
    }

    @Override
    @Nullable
    public MaintenanceInfo getMaintenanceInfo() {
        return this.maintenanceInfo;
    }

    @Override
    @Nullable
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    @Nullable
    public String getPlanName() {
        return this.planName;
    }

    @Override
    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    @Override
    @Nullable
    public List<String> getTags() {
        return this.tags;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateServiceInstanceRequest && this.equalTo((UpdateServiceInstanceRequest)another);
    }

    private boolean equalTo(UpdateServiceInstanceRequest another) {
        return this.completionTimeout.equals(another.completionTimeout) && Objects.equals(this.maintenanceInfo, another.maintenanceInfo) && Objects.equals(this.parameters, another.parameters) && Objects.equals(this.planName, another.planName) && this.serviceInstanceName.equals(another.serviceInstanceName) && Objects.equals(this.tags, another.tags);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.completionTimeout.hashCode();
        h += (h << 5) + Objects.hashCode(this.maintenanceInfo);
        h += (h << 5) + Objects.hashCode(this.parameters);
        h += (h << 5) + Objects.hashCode(this.planName);
        h += (h << 5) + this.serviceInstanceName.hashCode();
        h += (h << 5) + Objects.hashCode(this.tags);
        return h;
    }

    public String toString() {
        return "UpdateServiceInstanceRequest{completionTimeout=" + this.completionTimeout + ", maintenanceInfo=" + this.maintenanceInfo + ", parameters=" + this.parameters + ", planName=" + this.planName + ", serviceInstanceName=" + this.serviceInstanceName + ", tags=" + this.tags + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_UpdateServiceInstanceRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SERVICE_INSTANCE_NAME = 1L;
        private long initBits = 1L;
        private Duration completionTimeout;
        private MaintenanceInfo maintenanceInfo;
        private Map<String, Object> parameters = null;
        private String planName;
        private String serviceInstanceName;
        private List<String> tags = null;

        private Builder() {
        }

        public final Builder from(UpdateServiceInstanceRequest instance) {
            return this.from((_UpdateServiceInstanceRequest)instance);
        }

        final Builder from(_UpdateServiceInstanceRequest instance) {
            String planNameValue;
            Map<String, Object> parametersValue;
            Objects.requireNonNull(instance, "instance");
            this.completionTimeout(instance.getCompletionTimeout());
            MaintenanceInfo maintenanceInfoValue = instance.getMaintenanceInfo();
            if (maintenanceInfoValue != null) {
                this.maintenanceInfo(maintenanceInfoValue);
            }
            if ((parametersValue = instance.getParameters()) != null) {
                this.putAllParameters(parametersValue);
            }
            if ((planNameValue = instance.getPlanName()) != null) {
                this.planName(planNameValue);
            }
            this.serviceInstanceName(instance.getServiceInstanceName());
            List<String> tagsValue = instance.getTags();
            if (tagsValue != null) {
                this.addAllTags(tagsValue);
            }
            return this;
        }

        public final Builder completionTimeout(Duration completionTimeout) {
            this.completionTimeout = Objects.requireNonNull(completionTimeout, "completionTimeout");
            return this;
        }

        public final Builder maintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
            this.maintenanceInfo = maintenanceInfo;
            return this;
        }

        public final Builder parameter(String key, Object value) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            this.parameters.put(key, value);
            return this;
        }

        public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.parameters.put(k, v);
            return this;
        }

        public final Builder parameters(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.parameters = null;
                return this;
            }
            this.parameters = new LinkedHashMap<String, Object>();
            return this.putAllParameters(entries);
        }

        public final Builder putAllParameters(Map<String, ? extends Object> entries) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.parameters.put(k, v);
            }
            return this;
        }

        public final Builder planName(@Nullable String planName) {
            this.planName = planName;
            return this;
        }

        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = Objects.requireNonNull(serviceInstanceName, "serviceInstanceName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder tag(String element) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.add(Objects.requireNonNull(element, "tags element"));
            return this;
        }

        public final Builder tags(String ... elements) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        public final Builder tags(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.tags = null;
                return this;
            }
            this.tags = new ArrayList<String>();
            return this.addAllTags(elements);
        }

        public final Builder addAllTags(Iterable<String> elements) {
            Objects.requireNonNull(elements, "tags element");
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        public UpdateServiceInstanceRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateServiceInstanceRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("serviceInstanceName");
            }
            return "Cannot build UpdateServiceInstanceRequest, some of required attributes are not set " + attributes;
        }
    }
}

