package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request options for the get application manifest operation
 */
@Generated(from = "_GetApplicationManifestRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetApplicationManifestRequest
    extends org.cloudfoundry.operations.applications._GetApplicationManifestRequest {
  private final String name;

  private GetApplicationManifestRequest(GetApplicationManifestRequest.Builder builder) {
    this.name = builder.name;
  }

  /**
   * The application name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code GetApplicationManifestRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetApplicationManifestRequest
        && equalTo(0, (GetApplicationManifestRequest) another);
  }

  private boolean equalTo(int synthetic, GetApplicationManifestRequest another) {
    return name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetApplicationManifestRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetApplicationManifestRequest{"
        + "name=" + name
        + "}";
  }

  /**
   * Creates a builder for {@link GetApplicationManifestRequest GetApplicationManifestRequest}.
   * <pre>
   * GetApplicationManifestRequest.builder()
   *    .name(String) // required {@link GetApplicationManifestRequest#getName() name}
   *    .build();
   * </pre>
   * @return A new GetApplicationManifestRequest builder
   */
  public static GetApplicationManifestRequest.Builder builder() {
    return new GetApplicationManifestRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetApplicationManifestRequest GetApplicationManifestRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetApplicationManifestRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetApplicationManifestRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetApplicationManifestRequest instance) {
      return from((_GetApplicationManifestRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetApplicationManifestRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetApplicationManifestRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link GetApplicationManifestRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link GetApplicationManifestRequest GetApplicationManifestRequest}.
     * @return An immutable instance of GetApplicationManifestRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetApplicationManifestRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetApplicationManifestRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build GetApplicationManifestRequest, some of required attributes are not set " + attributes;
    }
  }
}
