package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request options for the rename application operation
 */
@Generated(from = "_RenameApplicationRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class RenameApplicationRequest
    extends org.cloudfoundry.operations.applications._RenameApplicationRequest {
  private final String name;
  private final String newName;

  private RenameApplicationRequest(RenameApplicationRequest.Builder builder) {
    this.name = builder.name;
    this.newName = builder.newName;
  }

  /**
   * The name of the application
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The new name of the application
   */
  @Override
  public String getNewName() {
    return newName;
  }

  /**
   * This instance is equal to all instances of {@code RenameApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RenameApplicationRequest
        && equalTo(0, (RenameApplicationRequest) another);
  }

  private boolean equalTo(int synthetic, RenameApplicationRequest another) {
    return name.equals(another.name)
        && newName.equals(another.newName);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code newName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + newName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RenameApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RenameApplicationRequest{"
        + "name=" + name
        + ", newName=" + newName
        + "}";
  }

  /**
   * Creates a builder for {@link RenameApplicationRequest RenameApplicationRequest}.
   * <pre>
   * RenameApplicationRequest.builder()
   *    .name(String) // required {@link RenameApplicationRequest#getName() name}
   *    .newName(String) // required {@link RenameApplicationRequest#getNewName() newName}
   *    .build();
   * </pre>
   * @return A new RenameApplicationRequest builder
   */
  public static RenameApplicationRequest.Builder builder() {
    return new RenameApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link RenameApplicationRequest RenameApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_RenameApplicationRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_NEW_NAME = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private String newName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RenameApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RenameApplicationRequest instance) {
      return from((_RenameApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RenameApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RenameApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      newName(instance.getNewName());
      return this;
    }

    /**
     * Initializes the value for the {@link RenameApplicationRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link RenameApplicationRequest#getNewName() newName} attribute.
     * @param newName The value for newName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder newName(String newName) {
      this.newName = Objects.requireNonNull(newName, "newName");
      initBits &= ~INIT_BIT_NEW_NAME;
      return this;
    }

    /**
     * Builds a new {@link RenameApplicationRequest RenameApplicationRequest}.
     * @return An immutable instance of RenameApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RenameApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RenameApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_NEW_NAME) != 0) attributes.add("newName");
      return "Cannot build RenameApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
