package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.MaintenanceInfo;
import org.immutables.value.Generated;

/**
 * A service instance
 */
@Generated(from = "_ServiceInstanceSummary", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ServiceInstanceSummary extends org.cloudfoundry.operations.services._ServiceInstanceSummary {
  private final List<String> applications;
  private final String id;
  private final @Nullable String lastOperation;
  private final @Nullable MaintenanceInfo maintenanceInfo;
  private final String name;
  private final @Nullable String plan;
  private final @Nullable String service;
  private final @Nullable List<String> tags;
  private final ServiceInstanceType type;

  private ServiceInstanceSummary(ServiceInstanceSummary.Builder builder) {
    this.applications = createUnmodifiableList(true, builder.applications);
    this.id = builder.id;
    this.lastOperation = builder.lastOperation;
    this.maintenanceInfo = builder.maintenanceInfo;
    this.name = builder.name;
    this.plan = builder.plan;
    this.service = builder.service;
    this.tags = builder.tags == null ? null : createUnmodifiableList(true, builder.tags);
    this.type = builder.type;
  }

  /**
   * The bound applications
   */
  @Override
  public List<String> getApplications() {
    return applications;
  }

  /**
   * The service instance id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The last operation for the service
   */
  @Override
  public @Nullable String getLastOperation() {
    return lastOperation;
  }

  /**
   * The maintenance info
   */
  @Override
  public @Nullable MaintenanceInfo getMaintenanceInfo() {
    return maintenanceInfo;
  }

  /**
   * The service instance name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The managed service plan
   */
  @Override
  public @Nullable String getPlan() {
    return plan;
  }

  /**
   * The name of the managed service
   */
  @Override
  public @Nullable String getService() {
    return service;
  }

  /**
   * The tags
   */
  @Override
  public @Nullable List<String> getTags() {
    return tags;
  }

  /**
   * The type of the service instance
   */
  @Override
  public ServiceInstanceType getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code ServiceInstanceSummary} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceInstanceSummary
        && equalTo(0, (ServiceInstanceSummary) another);
  }

  private boolean equalTo(int synthetic, ServiceInstanceSummary another) {
    return applications.equals(another.applications)
        && id.equals(another.id)
        && Objects.equals(lastOperation, another.lastOperation)
        && Objects.equals(maintenanceInfo, another.maintenanceInfo)
        && name.equals(another.name)
        && Objects.equals(plan, another.plan)
        && Objects.equals(service, another.service)
        && Objects.equals(tags, another.tags)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code applications}, {@code id}, {@code lastOperation}, {@code maintenanceInfo}, {@code name}, {@code plan}, {@code service}, {@code tags}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applications.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(lastOperation);
    h += (h << 5) + Objects.hashCode(maintenanceInfo);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(plan);
    h += (h << 5) + Objects.hashCode(service);
    h += (h << 5) + Objects.hashCode(tags);
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceInstanceSummary} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceInstanceSummary{"
        + "applications=" + applications
        + ", id=" + id
        + ", lastOperation=" + lastOperation
        + ", maintenanceInfo=" + maintenanceInfo
        + ", name=" + name
        + ", plan=" + plan
        + ", service=" + service
        + ", tags=" + tags
        + ", type=" + type
        + "}";
  }

  /**
   * Creates a builder for {@link ServiceInstanceSummary ServiceInstanceSummary}.
   * <pre>
   * ServiceInstanceSummary.builder()
   *    .application|addAllApplications(String) // {@link ServiceInstanceSummary#getApplications() applications} elements
   *    .id(String) // required {@link ServiceInstanceSummary#getId() id}
   *    .lastOperation(String | null) // nullable {@link ServiceInstanceSummary#getLastOperation() lastOperation}
   *    .maintenanceInfo(org.cloudfoundry.client.v2.MaintenanceInfo | null) // nullable {@link ServiceInstanceSummary#getMaintenanceInfo() maintenanceInfo}
   *    .name(String) // required {@link ServiceInstanceSummary#getName() name}
   *    .plan(String | null) // nullable {@link ServiceInstanceSummary#getPlan() plan}
   *    .service(String | null) // nullable {@link ServiceInstanceSummary#getService() service}
   *    .tags(List&amp;lt;String&amp;gt; | null) // nullable {@link ServiceInstanceSummary#getTags() tags}
   *    .type(org.cloudfoundry.operations.services.ServiceInstanceType) // required {@link ServiceInstanceSummary#getType() type}
   *    .build();
   * </pre>
   * @return A new ServiceInstanceSummary builder
   */
  public static ServiceInstanceSummary.Builder builder() {
    return new ServiceInstanceSummary.Builder();
  }

  /**
   * Builds instances of type {@link ServiceInstanceSummary ServiceInstanceSummary}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ServiceInstanceSummary", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private long initBits = 0x7L;

    private List<String> applications = new ArrayList<String>();
    private String id;
    private String lastOperation;
    private MaintenanceInfo maintenanceInfo;
    private String name;
    private String plan;
    private String service;
    private List<String> tags = null;
    private ServiceInstanceType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.operations.services.AbstractServiceInstanceSummary} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractServiceInstanceSummary instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceInstanceSummary} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceInstanceSummary instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ServiceInstanceSummary} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ServiceInstanceSummary instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof AbstractServiceInstanceSummary) {
        AbstractServiceInstanceSummary instance = (AbstractServiceInstanceSummary) object;
        String serviceValue = instance.getService();
        if (serviceValue != null) {
          service(serviceValue);
        }
        String lastOperationValue = instance.getLastOperation();
        if (lastOperationValue != null) {
          lastOperation(lastOperationValue);
        }
        name(instance.getName());
        id(instance.getId());
        type(instance.getType());
        MaintenanceInfo maintenanceInfoValue = instance.getMaintenanceInfo();
        if (maintenanceInfoValue != null) {
          maintenanceInfo(maintenanceInfoValue);
        }
        String planValue = instance.getPlan();
        if (planValue != null) {
          plan(planValue);
        }
        List<String> tagsValue = instance.getTags();
        if (tagsValue != null) {
          addAllTags(tagsValue);
        }
        addAllApplications(instance.getApplications());
      }
    }

    /**
     * Adds one element to {@link ServiceInstanceSummary#getApplications() applications} list.
     * @param element A applications element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder application(String element) {
      this.applications.add(Objects.requireNonNull(element, "applications element"));
      return this;
    }

    /**
     * Adds elements to {@link ServiceInstanceSummary#getApplications() applications} list.
     * @param elements An array of applications elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applications(String... elements) {
      for (String element : elements) {
        this.applications.add(Objects.requireNonNull(element, "applications element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ServiceInstanceSummary#getApplications() applications} list.
     * @param elements An iterable of applications elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applications(Iterable<String> elements) {
      this.applications.clear();
      return addAllApplications(elements);
    }

    /**
     * Adds elements to {@link ServiceInstanceSummary#getApplications() applications} list.
     * @param elements An iterable of applications elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplications(Iterable<String> elements) {
      for (String element : elements) {
        this.applications.add(Objects.requireNonNull(element, "applications element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceInstanceSummary#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceInstanceSummary#getLastOperation() lastOperation} attribute.
     * @param lastOperation The value for lastOperation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lastOperation(@Nullable String lastOperation) {
      this.lastOperation = lastOperation;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceInstanceSummary#getMaintenanceInfo() maintenanceInfo} attribute.
     * @param maintenanceInfo The value for maintenanceInfo (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder maintenanceInfo(@Nullable MaintenanceInfo maintenanceInfo) {
      this.maintenanceInfo = maintenanceInfo;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceInstanceSummary#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceInstanceSummary#getPlan() plan} attribute.
     * @param plan The value for plan (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder plan(@Nullable String plan) {
      this.plan = plan;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceInstanceSummary#getService() service} attribute.
     * @param service The value for service (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder service(@Nullable String service) {
      this.service = service;
      return this;
    }

    /**
     * Adds one element to {@link ServiceInstanceSummary#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(String element) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      this.tags.add(Objects.requireNonNull(element, "tags element"));
      return this;
    }

    /**
     * Adds elements to {@link ServiceInstanceSummary#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(String... elements) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ServiceInstanceSummary#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.tags = null;
        return this;
      }
      this.tags = new ArrayList<String>();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link ServiceInstanceSummary#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTags(Iterable<String> elements) {
      Objects.requireNonNull(elements, "tags element");
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceInstanceSummary#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(ServiceInstanceType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ServiceInstanceSummary ServiceInstanceSummary}.
     * @return An immutable instance of ServiceInstanceSummary
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceInstanceSummary build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ServiceInstanceSummary(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build ServiceInstanceSummary, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
