package org.cloudfoundry.operations.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request options for the rename organization operation
 */
@Generated(from = "_RenameOrganizationRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class RenameOrganizationRequest
    extends org.cloudfoundry.operations.organizations._RenameOrganizationRequest {
  private final String name;
  private final String newName;

  private RenameOrganizationRequest(RenameOrganizationRequest.Builder builder) {
    this.name = builder.name;
    this.newName = builder.newName;
  }

  /**
   * The name of the organization
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The new name of the organization
   */
  @Override
  public String getNewName() {
    return newName;
  }

  /**
   * This instance is equal to all instances of {@code RenameOrganizationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RenameOrganizationRequest
        && equalTo(0, (RenameOrganizationRequest) another);
  }

  private boolean equalTo(int synthetic, RenameOrganizationRequest another) {
    return name.equals(another.name)
        && newName.equals(another.newName);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code newName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + newName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RenameOrganizationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RenameOrganizationRequest{"
        + "name=" + name
        + ", newName=" + newName
        + "}";
  }

  /**
   * Creates a builder for {@link RenameOrganizationRequest RenameOrganizationRequest}.
   * <pre>
   * RenameOrganizationRequest.builder()
   *    .name(String) // required {@link RenameOrganizationRequest#getName() name}
   *    .newName(String) // required {@link RenameOrganizationRequest#getNewName() newName}
   *    .build();
   * </pre>
   * @return A new RenameOrganizationRequest builder
   */
  public static RenameOrganizationRequest.Builder builder() {
    return new RenameOrganizationRequest.Builder();
  }

  /**
   * Builds instances of type {@link RenameOrganizationRequest RenameOrganizationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_RenameOrganizationRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_NEW_NAME = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private String newName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RenameOrganizationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RenameOrganizationRequest instance) {
      return from((_RenameOrganizationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _RenameOrganizationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RenameOrganizationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      newName(instance.getNewName());
      return this;
    }

    /**
     * Initializes the value for the {@link RenameOrganizationRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link RenameOrganizationRequest#getNewName() newName} attribute.
     * @param newName The value for newName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder newName(String newName) {
      this.newName = Objects.requireNonNull(newName, "newName");
      initBits &= ~INIT_BIT_NEW_NAME;
      return this;
    }

    /**
     * Builds a new {@link RenameOrganizationRequest RenameOrganizationRequest}.
     * @return An immutable instance of RenameOrganizationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RenameOrganizationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new RenameOrganizationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_NEW_NAME) != 0) attributes.add("newName");
      return "Cannot build RenameOrganizationRequest, some of required attributes are not set " + attributes;
    }
  }
}
