package org.cloudfoundry.operations.routes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request options for the check route operation
 */
@Generated(from = "_CheckRouteRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CheckRouteRequest extends org.cloudfoundry.operations.routes._CheckRouteRequest {
  private final String domain;
  private final @Nullable String host;
  private final @Nullable String path;

  private CheckRouteRequest(CheckRouteRequest.Builder builder) {
    this.domain = builder.domain;
    this.host = builder.host;
    this.path = builder.path;
  }

  /**
   * The domain of the route
   */
  @Override
  public String getDomain() {
    return domain;
  }

  /**
   * The host of the route
   */
  @Override
  public @Nullable String getHost() {
    return host;
  }

  /**
   * The path of the route.
   * <p>
   * Note: the path is specified without a leading "/"
   */
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * This instance is equal to all instances of {@code CheckRouteRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CheckRouteRequest
        && equalTo(0, (CheckRouteRequest) another);
  }

  private boolean equalTo(int synthetic, CheckRouteRequest another) {
    return domain.equals(another.domain)
        && Objects.equals(host, another.host)
        && Objects.equals(path, another.path);
  }

  /**
   * Computes a hash code from attributes: {@code domain}, {@code host}, {@code path}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + domain.hashCode();
    h += (h << 5) + Objects.hashCode(host);
    h += (h << 5) + Objects.hashCode(path);
    return h;
  }

  /**
   * Prints the immutable value {@code CheckRouteRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CheckRouteRequest{"
        + "domain=" + domain
        + ", host=" + host
        + ", path=" + path
        + "}";
  }

  /**
   * Creates a builder for {@link CheckRouteRequest CheckRouteRequest}.
   * <pre>
   * CheckRouteRequest.builder()
   *    .domain(String) // required {@link CheckRouteRequest#getDomain() domain}
   *    .host(String | null) // nullable {@link CheckRouteRequest#getHost() host}
   *    .path(String | null) // nullable {@link CheckRouteRequest#getPath() path}
   *    .build();
   * </pre>
   * @return A new CheckRouteRequest builder
   */
  public static CheckRouteRequest.Builder builder() {
    return new CheckRouteRequest.Builder();
  }

  /**
   * Builds instances of type {@link CheckRouteRequest CheckRouteRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CheckRouteRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN = 0x1L;
    private long initBits = 0x1L;

    private String domain;
    private String host;
    private String path;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CheckRouteRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CheckRouteRequest instance) {
      return from((_CheckRouteRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CheckRouteRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CheckRouteRequest instance) {
      Objects.requireNonNull(instance, "instance");
      domain(instance.getDomain());
      String hostValue = instance.getHost();
      if (hostValue != null) {
        host(hostValue);
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRouteRequest#getDomain() domain} attribute.
     * @param domain The value for domain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domain(String domain) {
      this.domain = Objects.requireNonNull(domain, "domain");
      initBits &= ~INIT_BIT_DOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRouteRequest#getHost() host} attribute.
     * @param host The value for host (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(@Nullable String host) {
      this.host = host;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRouteRequest#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Builds a new {@link CheckRouteRequest CheckRouteRequest}.
     * @return An immutable instance of CheckRouteRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CheckRouteRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CheckRouteRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DOMAIN) != 0) attributes.add("domain");
      return "Cannot build CheckRouteRequest, some of required attributes are not set " + attributes;
    }
  }
}
