package org.cloudfoundry.operations.routes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request options for the unmap route operation
 */
@Generated(from = "_UnmapRouteRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UnmapRouteRequest extends org.cloudfoundry.operations.routes._UnmapRouteRequest {
  private final String applicationName;
  private final String domain;
  private final @Nullable String host;
  private final @Nullable String path;
  private final @Nullable Integer port;

  private UnmapRouteRequest(UnmapRouteRequest.Builder builder) {
    this.applicationName = builder.applicationName;
    this.domain = builder.domain;
    this.host = builder.host;
    this.path = builder.path;
    this.port = builder.port;
  }

  /**
   * The name of the application to remove a route from
   */
  @Override
  public String getApplicationName() {
    return applicationName;
  }

  /**
   * The domain of the route
   */
  @Override
  public String getDomain() {
    return domain;
  }

  /**
   * The host of the route
   */
  @Override
  public @Nullable String getHost() {
    return host;
  }

  /**
   * The path of the route
   */
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * The port of the route
   */
  @Override
  public @Nullable Integer getPort() {
    return port;
  }

  /**
   * This instance is equal to all instances of {@code UnmapRouteRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UnmapRouteRequest
        && equalTo(0, (UnmapRouteRequest) another);
  }

  private boolean equalTo(int synthetic, UnmapRouteRequest another) {
    return applicationName.equals(another.applicationName)
        && domain.equals(another.domain)
        && Objects.equals(host, another.host)
        && Objects.equals(path, another.path)
        && Objects.equals(port, another.port);
  }

  /**
   * Computes a hash code from attributes: {@code applicationName}, {@code domain}, {@code host}, {@code path}, {@code port}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationName.hashCode();
    h += (h << 5) + domain.hashCode();
    h += (h << 5) + Objects.hashCode(host);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(port);
    return h;
  }

  /**
   * Prints the immutable value {@code UnmapRouteRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UnmapRouteRequest{"
        + "applicationName=" + applicationName
        + ", domain=" + domain
        + ", host=" + host
        + ", path=" + path
        + ", port=" + port
        + "}";
  }

  private static UnmapRouteRequest validate(UnmapRouteRequest instance) {
    instance.checkSetup();
    return instance;
  }

  /**
   * Creates a builder for {@link UnmapRouteRequest UnmapRouteRequest}.
   * <pre>
   * UnmapRouteRequest.builder()
   *    .applicationName(String) // required {@link UnmapRouteRequest#getApplicationName() applicationName}
   *    .domain(String) // required {@link UnmapRouteRequest#getDomain() domain}
   *    .host(String | null) // nullable {@link UnmapRouteRequest#getHost() host}
   *    .path(String | null) // nullable {@link UnmapRouteRequest#getPath() path}
   *    .port(Integer | null) // nullable {@link UnmapRouteRequest#getPort() port}
   *    .build();
   * </pre>
   * @return A new UnmapRouteRequest builder
   */
  public static UnmapRouteRequest.Builder builder() {
    return new UnmapRouteRequest.Builder();
  }

  /**
   * Builds instances of type {@link UnmapRouteRequest UnmapRouteRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UnmapRouteRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_NAME = 0x1L;
    private static final long INIT_BIT_DOMAIN = 0x2L;
    private long initBits = 0x3L;

    private String applicationName;
    private String domain;
    private String host;
    private String path;
    private Integer port;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UnmapRouteRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UnmapRouteRequest instance) {
      return from((_UnmapRouteRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UnmapRouteRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UnmapRouteRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationName(instance.getApplicationName());
      domain(instance.getDomain());
      String hostValue = instance.getHost();
      if (hostValue != null) {
        host(hostValue);
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      Integer portValue = instance.getPort();
      if (portValue != null) {
        port(portValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UnmapRouteRequest#getApplicationName() applicationName} attribute.
     * @param applicationName The value for applicationName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationName(String applicationName) {
      this.applicationName = Objects.requireNonNull(applicationName, "applicationName");
      initBits &= ~INIT_BIT_APPLICATION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UnmapRouteRequest#getDomain() domain} attribute.
     * @param domain The value for domain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domain(String domain) {
      this.domain = Objects.requireNonNull(domain, "domain");
      initBits &= ~INIT_BIT_DOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link UnmapRouteRequest#getHost() host} attribute.
     * @param host The value for host (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(@Nullable String host) {
      this.host = host;
      return this;
    }

    /**
     * Initializes the value for the {@link UnmapRouteRequest#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link UnmapRouteRequest#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(@Nullable Integer port) {
      this.port = port;
      return this;
    }

    /**
     * Builds a new {@link UnmapRouteRequest UnmapRouteRequest}.
     * @return An immutable instance of UnmapRouteRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UnmapRouteRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return UnmapRouteRequest.validate(new UnmapRouteRequest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_NAME) != 0) attributes.add("applicationName");
      if ((initBits & INIT_BIT_DOMAIN) != 0) attributes.add("domain");
      return "Cannot build UnmapRouteRequest, some of required attributes are not set " + attributes;
    }
  }
}
