package org.cloudfoundry.operations.spaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.cloudfoundry.operations.spaceadmin.SpaceQuota;
import org.immutables.value.Generated;

/**
 * A Cloud Foundry Space Detail
 */
@Generated(from = "_SpaceDetail", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class SpaceDetail extends org.cloudfoundry.operations.spaces._SpaceDetail {
  private final List<String> applications;
  private final List<String> domains;
  private final String id;
  private final String name;
  private final String organization;
  private final List<SecurityGroup> securityGroups;
  private final List<String> services;
  private final SpaceQuota spaceQuota;

  private SpaceDetail(SpaceDetail.Builder builder) {
    this.applications = createUnmodifiableList(true, builder.applications);
    this.domains = createUnmodifiableList(true, builder.domains);
    this.id = builder.id;
    this.name = builder.name;
    this.organization = builder.organization;
    this.securityGroups = createUnmodifiableList(true, builder.securityGroups);
    this.services = createUnmodifiableList(true, builder.services);
    this.spaceQuota = builder.spaceQuota;
  }

  /**
   * The applications
   */
  @Override
  public List<String> getApplications() {
    return applications;
  }

  /**
   * The domains
   */
  @Override
  public List<String> getDomains() {
    return domains;
  }

  /**
   * The id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The organization
   */
  @Override
  public String getOrganization() {
    return organization;
  }

  /**
   * The security groups
   */
  @Override
  public List<SecurityGroup> getSecurityGroups() {
    return securityGroups;
  }

  /**
   * The services
   */
  @Override
  public List<String> getServices() {
    return services;
  }

  /**
   * The space quota
   */
  @Override
  public Optional<SpaceQuota> getSpaceQuota() {
    return Optional.ofNullable(spaceQuota);
  }

  /**
   * This instance is equal to all instances of {@code SpaceDetail} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SpaceDetail
        && equalTo(0, (SpaceDetail) another);
  }

  private boolean equalTo(int synthetic, SpaceDetail another) {
    return applications.equals(another.applications)
        && domains.equals(another.domains)
        && id.equals(another.id)
        && name.equals(another.name)
        && organization.equals(another.organization)
        && securityGroups.equals(another.securityGroups)
        && services.equals(another.services)
        && Objects.equals(spaceQuota, another.spaceQuota);
  }

  /**
   * Computes a hash code from attributes: {@code applications}, {@code domains}, {@code id}, {@code name}, {@code organization}, {@code securityGroups}, {@code services}, {@code spaceQuota}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applications.hashCode();
    h += (h << 5) + domains.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + organization.hashCode();
    h += (h << 5) + securityGroups.hashCode();
    h += (h << 5) + services.hashCode();
    h += (h << 5) + Objects.hashCode(spaceQuota);
    return h;
  }

  /**
   * Prints the immutable value {@code SpaceDetail} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SpaceDetail{");
    builder.append("applications=").append(applications);
    builder.append(", ");
    builder.append("domains=").append(domains);
    builder.append(", ");
    builder.append("id=").append(id);
    builder.append(", ");
    builder.append("name=").append(name);
    builder.append(", ");
    builder.append("organization=").append(organization);
    builder.append(", ");
    builder.append("securityGroups=").append(securityGroups);
    builder.append(", ");
    builder.append("services=").append(services);
    if (spaceQuota != null) {
      builder.append(", ");
      builder.append("spaceQuota=").append(spaceQuota);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates a builder for {@link SpaceDetail SpaceDetail}.
   * <pre>
   * SpaceDetail.builder()
   *    .application|addAllApplications(String) // {@link SpaceDetail#getApplications() applications} elements
   *    .domain|addAllDomains(String) // {@link SpaceDetail#getDomains() domains} elements
   *    .id(String) // required {@link SpaceDetail#getId() id}
   *    .name(String) // required {@link SpaceDetail#getName() name}
   *    .organization(String) // required {@link SpaceDetail#getOrganization() organization}
   *    .securityGroup|addAllSecurityGroups(SecurityGroup) // {@link SpaceDetail#getSecurityGroups() securityGroups} elements
   *    .service|addAllServices(String) // {@link SpaceDetail#getServices() services} elements
   *    .spaceQuota(org.cloudfoundry.operations.spaceadmin.SpaceQuota) // optional {@link SpaceDetail#getSpaceQuota() spaceQuota}
   *    .build();
   * </pre>
   * @return A new SpaceDetail builder
   */
  public static SpaceDetail.Builder builder() {
    return new SpaceDetail.Builder();
  }

  /**
   * Builds instances of type {@link SpaceDetail SpaceDetail}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_SpaceDetail", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_ORGANIZATION = 0x4L;
    private long initBits = 0x7L;

    private List<String> applications = new ArrayList<String>();
    private List<String> domains = new ArrayList<String>();
    private String id;
    private String name;
    private String organization;
    private List<SecurityGroup> securityGroups = new ArrayList<SecurityGroup>();
    private List<String> services = new ArrayList<String>();
    private SpaceQuota spaceQuota;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SpaceDetail} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SpaceDetail instance) {
      return from((_SpaceDetail) instance);
    }

    /**
     * Copy abstract value type {@code _SpaceDetail} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SpaceDetail instance) {
      Objects.requireNonNull(instance, "instance");
      addAllApplications(instance.getApplications());
      addAllDomains(instance.getDomains());
      id(instance.getId());
      name(instance.getName());
      organization(instance.getOrganization());
      addAllSecurityGroups(instance.getSecurityGroups());
      addAllServices(instance.getServices());
      Optional<SpaceQuota> spaceQuotaOptional = instance.getSpaceQuota();
      if (spaceQuotaOptional.isPresent()) {
        spaceQuota(spaceQuotaOptional);
      }
      return this;
    }

    /**
     * Adds one element to {@link SpaceDetail#getApplications() applications} list.
     * @param element A applications element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder application(String element) {
      this.applications.add(Objects.requireNonNull(element, "applications element"));
      return this;
    }

    /**
     * Adds elements to {@link SpaceDetail#getApplications() applications} list.
     * @param elements An array of applications elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applications(String... elements) {
      for (String element : elements) {
        this.applications.add(Objects.requireNonNull(element, "applications element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SpaceDetail#getApplications() applications} list.
     * @param elements An iterable of applications elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applications(Iterable<String> elements) {
      this.applications.clear();
      return addAllApplications(elements);
    }

    /**
     * Adds elements to {@link SpaceDetail#getApplications() applications} list.
     * @param elements An iterable of applications elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplications(Iterable<String> elements) {
      for (String element : elements) {
        this.applications.add(Objects.requireNonNull(element, "applications element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link SpaceDetail#getDomains() domains} list.
     * @param element A domains element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domain(String element) {
      this.domains.add(Objects.requireNonNull(element, "domains element"));
      return this;
    }

    /**
     * Adds elements to {@link SpaceDetail#getDomains() domains} list.
     * @param elements An array of domains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domains(String... elements) {
      for (String element : elements) {
        this.domains.add(Objects.requireNonNull(element, "domains element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SpaceDetail#getDomains() domains} list.
     * @param elements An iterable of domains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domains(Iterable<String> elements) {
      this.domains.clear();
      return addAllDomains(elements);
    }

    /**
     * Adds elements to {@link SpaceDetail#getDomains() domains} list.
     * @param elements An iterable of domains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDomains(Iterable<String> elements) {
      for (String element : elements) {
        this.domains.add(Objects.requireNonNull(element, "domains element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceDetail#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceDetail#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceDetail#getOrganization() organization} attribute.
     * @param organization The value for organization 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organization(String organization) {
      this.organization = Objects.requireNonNull(organization, "organization");
      initBits &= ~INIT_BIT_ORGANIZATION;
      return this;
    }

    /**
     * Adds one element to {@link SpaceDetail#getSecurityGroups() securityGroups} list.
     * @param element A securityGroups element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroup(SecurityGroup element) {
      this.securityGroups.add(Objects.requireNonNull(element, "securityGroups element"));
      return this;
    }

    /**
     * Adds elements to {@link SpaceDetail#getSecurityGroups() securityGroups} list.
     * @param elements An array of securityGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroups(SecurityGroup... elements) {
      for (SecurityGroup element : elements) {
        this.securityGroups.add(Objects.requireNonNull(element, "securityGroups element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SpaceDetail#getSecurityGroups() securityGroups} list.
     * @param elements An iterable of securityGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroups(Iterable<? extends SecurityGroup> elements) {
      this.securityGroups.clear();
      return addAllSecurityGroups(elements);
    }

    /**
     * Adds elements to {@link SpaceDetail#getSecurityGroups() securityGroups} list.
     * @param elements An iterable of securityGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSecurityGroups(Iterable<? extends SecurityGroup> elements) {
      for (SecurityGroup element : elements) {
        this.securityGroups.add(Objects.requireNonNull(element, "securityGroups element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link SpaceDetail#getServices() services} list.
     * @param element A services element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder service(String element) {
      this.services.add(Objects.requireNonNull(element, "services element"));
      return this;
    }

    /**
     * Adds elements to {@link SpaceDetail#getServices() services} list.
     * @param elements An array of services elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder services(String... elements) {
      for (String element : elements) {
        this.services.add(Objects.requireNonNull(element, "services element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SpaceDetail#getServices() services} list.
     * @param elements An iterable of services elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder services(Iterable<String> elements) {
      this.services.clear();
      return addAllServices(elements);
    }

    /**
     * Adds elements to {@link SpaceDetail#getServices() services} list.
     * @param elements An iterable of services elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServices(Iterable<String> elements) {
      for (String element : elements) {
        this.services.add(Objects.requireNonNull(element, "services element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link SpaceDetail#getSpaceQuota() spaceQuota} to spaceQuota.
     * @param spaceQuota The value for spaceQuota
     * @return {@code this} builder for chained invocation
     */
    public final Builder spaceQuota(SpaceQuota spaceQuota) {
      this.spaceQuota = Objects.requireNonNull(spaceQuota, "spaceQuota");
      return this;
    }

    /**
     * Initializes the optional value {@link SpaceDetail#getSpaceQuota() spaceQuota} to spaceQuota.
     * @param spaceQuota The value for spaceQuota
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceQuota(Optional<? extends SpaceQuota> spaceQuota) {
      this.spaceQuota = spaceQuota.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link SpaceDetail SpaceDetail}.
     * @return An immutable instance of SpaceDetail
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SpaceDetail build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new SpaceDetail(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_ORGANIZATION) != 0) attributes.add("organization");
      return "Cannot build SpaceDetail, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
