package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.processes.HealthCheckType;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _ManifestV3Process}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ManifestV3Process.builder()}.
 */
@Generated(from = "_ManifestV3Process", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ManifestV3Process extends org.cloudfoundry.operations.applications._ManifestV3Process {
  private final @Nullable String command;
  private final @Nullable String disk;
  private final @Nullable String healthCheckHttpEndpoint;
  private final @Nullable Integer healthCheckInvocationTimeout;
  private final @Nullable HealthCheckType healthCheckType;
  private final @Nullable Integer instances;
  private final @Nullable String memory;
  private final @Nullable Integer timeout;
  private final String type;

  private ManifestV3Process(ManifestV3Process.Builder builder) {
    this.command = builder.command;
    this.disk = builder.disk;
    this.healthCheckHttpEndpoint = builder.healthCheckHttpEndpoint;
    this.healthCheckInvocationTimeout = builder.healthCheckInvocationTimeout;
    this.healthCheckType = builder.healthCheckType;
    this.instances = builder.instances;
    this.memory = builder.memory;
    this.timeout = builder.timeout;
    this.type = builder.type;
  }

  /**
   * The command to launch this process
   */
  @Override
  public @Nullable String getCommand() {
    return command;
  }

  /**
   * The disk quota of this process
   */
  @Override
  public @Nullable String getDisk() {
    return disk;
  }

  /**
   * The HTTP health check endpoint
   */
  @Override
  public @Nullable String getHealthCheckHttpEndpoint() {
    return healthCheckHttpEndpoint;
  }

  /**
   * The timeout in seconds for individual health check requests for http and port health checks
   */
  @Override
  public @Nullable Integer getHealthCheckInvocationTimeout() {
    return healthCheckInvocationTimeout;
  }

  /**
   * Type of health check to perform
   */
  @Override
  public @Nullable HealthCheckType getHealthCheckType() {
    return healthCheckType;
  }

  /**
   * The number of instances of this process
   */
  @Override
  public @Nullable Integer getInstances() {
    return instances;
  }

  /**
   * The memory quota of this process
   */
  @Override
  public @Nullable String getMemory() {
    return memory;
  }

  /**
   * Time in seconds at which the health-check will report failure
   */
  @Override
  public @Nullable Integer getTimeout() {
    return timeout;
  }

  /**
   * The type of this process
   */
  @Override
  public String getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code ManifestV3Process} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ManifestV3Process
        && equalTo(0, (ManifestV3Process) another);
  }

  private boolean equalTo(int synthetic, ManifestV3Process another) {
    return Objects.equals(command, another.command)
        && Objects.equals(disk, another.disk)
        && Objects.equals(healthCheckHttpEndpoint, another.healthCheckHttpEndpoint)
        && Objects.equals(healthCheckInvocationTimeout, another.healthCheckInvocationTimeout)
        && Objects.equals(healthCheckType, another.healthCheckType)
        && Objects.equals(instances, another.instances)
        && Objects.equals(memory, another.memory)
        && Objects.equals(timeout, another.timeout)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code command}, {@code disk}, {@code healthCheckHttpEndpoint}, {@code healthCheckInvocationTimeout}, {@code healthCheckType}, {@code instances}, {@code memory}, {@code timeout}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(command);
    h += (h << 5) + Objects.hashCode(disk);
    h += (h << 5) + Objects.hashCode(healthCheckHttpEndpoint);
    h += (h << 5) + Objects.hashCode(healthCheckInvocationTimeout);
    h += (h << 5) + Objects.hashCode(healthCheckType);
    h += (h << 5) + Objects.hashCode(instances);
    h += (h << 5) + Objects.hashCode(memory);
    h += (h << 5) + Objects.hashCode(timeout);
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ManifestV3Process} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ManifestV3Process{"
        + "command=" + command
        + ", disk=" + disk
        + ", healthCheckHttpEndpoint=" + healthCheckHttpEndpoint
        + ", healthCheckInvocationTimeout=" + healthCheckInvocationTimeout
        + ", healthCheckType=" + healthCheckType
        + ", instances=" + instances
        + ", memory=" + memory
        + ", timeout=" + timeout
        + ", type=" + type
        + "}";
  }

  /**
   * Creates a builder for {@link ManifestV3Process ManifestV3Process}.
   * <pre>
   * ManifestV3Process.builder()
   *    .command(String | null) // nullable {@link ManifestV3Process#getCommand() command}
   *    .disk(String | null) // nullable {@link ManifestV3Process#getDisk() disk}
   *    .healthCheckHttpEndpoint(String | null) // nullable {@link ManifestV3Process#getHealthCheckHttpEndpoint() healthCheckHttpEndpoint}
   *    .healthCheckInvocationTimeout(Integer | null) // nullable {@link ManifestV3Process#getHealthCheckInvocationTimeout() healthCheckInvocationTimeout}
   *    .healthCheckType(org.cloudfoundry.client.v3.processes.HealthCheckType | null) // nullable {@link ManifestV3Process#getHealthCheckType() healthCheckType}
   *    .instances(Integer | null) // nullable {@link ManifestV3Process#getInstances() instances}
   *    .memory(String | null) // nullable {@link ManifestV3Process#getMemory() memory}
   *    .timeout(Integer | null) // nullable {@link ManifestV3Process#getTimeout() timeout}
   *    .type(String) // required {@link ManifestV3Process#getType() type}
   *    .build();
   * </pre>
   * @return A new ManifestV3Process builder
   */
  public static ManifestV3Process.Builder builder() {
    return new ManifestV3Process.Builder();
  }

  /**
   * Builds instances of type {@link ManifestV3Process ManifestV3Process}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ManifestV3Process", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private String command;
    private String disk;
    private String healthCheckHttpEndpoint;
    private Integer healthCheckInvocationTimeout;
    private HealthCheckType healthCheckType;
    private Integer instances;
    private String memory;
    private Integer timeout;
    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ManifestV3Process} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ManifestV3Process instance) {
      return from((_ManifestV3Process) instance);
    }

    /**
     * Copy abstract value type {@code _ManifestV3Process} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ManifestV3Process instance) {
      Objects.requireNonNull(instance, "instance");
      String commandValue = instance.getCommand();
      if (commandValue != null) {
        command(commandValue);
      }
      String diskValue = instance.getDisk();
      if (diskValue != null) {
        disk(diskValue);
      }
      String healthCheckHttpEndpointValue = instance.getHealthCheckHttpEndpoint();
      if (healthCheckHttpEndpointValue != null) {
        healthCheckHttpEndpoint(healthCheckHttpEndpointValue);
      }
      Integer healthCheckInvocationTimeoutValue = instance.getHealthCheckInvocationTimeout();
      if (healthCheckInvocationTimeoutValue != null) {
        healthCheckInvocationTimeout(healthCheckInvocationTimeoutValue);
      }
      HealthCheckType healthCheckTypeValue = instance.getHealthCheckType();
      if (healthCheckTypeValue != null) {
        healthCheckType(healthCheckTypeValue);
      }
      Integer instancesValue = instance.getInstances();
      if (instancesValue != null) {
        instances(instancesValue);
      }
      String memoryValue = instance.getMemory();
      if (memoryValue != null) {
        memory(memoryValue);
      }
      Integer timeoutValue = instance.getTimeout();
      if (timeoutValue != null) {
        timeout(timeoutValue);
      }
      type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Process#getCommand() command} attribute.
     * @param command The value for command (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder command(@Nullable String command) {
      this.command = command;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Process#getDisk() disk} attribute.
     * @param disk The value for disk (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder disk(@Nullable String disk) {
      this.disk = disk;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Process#getHealthCheckHttpEndpoint() healthCheckHttpEndpoint} attribute.
     * @param healthCheckHttpEndpoint The value for healthCheckHttpEndpoint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder healthCheckHttpEndpoint(@Nullable String healthCheckHttpEndpoint) {
      this.healthCheckHttpEndpoint = healthCheckHttpEndpoint;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Process#getHealthCheckInvocationTimeout() healthCheckInvocationTimeout} attribute.
     * @param healthCheckInvocationTimeout The value for healthCheckInvocationTimeout (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder healthCheckInvocationTimeout(@Nullable Integer healthCheckInvocationTimeout) {
      this.healthCheckInvocationTimeout = healthCheckInvocationTimeout;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Process#getHealthCheckType() healthCheckType} attribute.
     * @param healthCheckType The value for healthCheckType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder healthCheckType(@Nullable HealthCheckType healthCheckType) {
      this.healthCheckType = healthCheckType;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Process#getInstances() instances} attribute.
     * @param instances The value for instances (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instances(@Nullable Integer instances) {
      this.instances = instances;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Process#getMemory() memory} attribute.
     * @param memory The value for memory (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memory(@Nullable String memory) {
      this.memory = memory;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Process#getTimeout() timeout} attribute.
     * @param timeout The value for timeout (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timeout(@Nullable Integer timeout) {
      this.timeout = timeout;
      return this;
    }

    /**
     * Initializes the value for the {@link ManifestV3Process#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ManifestV3Process ManifestV3Process}.
     * @return An immutable instance of ManifestV3Process
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ManifestV3Process build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ManifestV3Process(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build ManifestV3Process, some of required attributes are not set " + attributes;
    }
  }
}
