package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request options for the bind service instance operation
 */
@Generated(from = "_BindRouteServiceInstanceRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class BindRouteServiceInstanceRequest
    extends org.cloudfoundry.operations.services._BindRouteServiceInstanceRequest {
  private final String domainName;
  private final @Nullable String hostname;
  private final @Nullable Map<String, Object> parameters;
  private final @Nullable String path;
  private final String serviceInstanceName;

  private BindRouteServiceInstanceRequest(BindRouteServiceInstanceRequest.Builder builder) {
    this.domainName = builder.domainName;
    this.hostname = builder.hostname;
    this.parameters = builder.parameters == null ? null : createUnmodifiableMap(false, false, builder.parameters);
    this.path = builder.path;
    this.serviceInstanceName = builder.serviceInstanceName;
  }

  /**
   * The domain for the bound route
   */
  @Override
  public String getDomainName() {
    return domainName;
  }

  /**
   * The hostname for the bound route
   */
  @Override
  public @Nullable String getHostname() {
    return hostname;
  }

  /**
   * The parameters for the bound route
   */
  @Override
  public @Nullable Map<String, Object> getParameters() {
    return parameters;
  }

  /**
   * The path for the bound route
   */
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * The name of the service instance to bind
   */
  @Override
  public String getServiceInstanceName() {
    return serviceInstanceName;
  }

  /**
   * This instance is equal to all instances of {@code BindRouteServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BindRouteServiceInstanceRequest
        && equalTo(0, (BindRouteServiceInstanceRequest) another);
  }

  private boolean equalTo(int synthetic, BindRouteServiceInstanceRequest another) {
    return domainName.equals(another.domainName)
        && Objects.equals(hostname, another.hostname)
        && Objects.equals(parameters, another.parameters)
        && Objects.equals(path, another.path)
        && serviceInstanceName.equals(another.serviceInstanceName);
  }

  /**
   * Computes a hash code from attributes: {@code domainName}, {@code hostname}, {@code parameters}, {@code path}, {@code serviceInstanceName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + domainName.hashCode();
    h += (h << 5) + Objects.hashCode(hostname);
    h += (h << 5) + Objects.hashCode(parameters);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + serviceInstanceName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BindRouteServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BindRouteServiceInstanceRequest{"
        + "domainName=" + domainName
        + ", hostname=" + hostname
        + ", parameters=" + parameters
        + ", path=" + path
        + ", serviceInstanceName=" + serviceInstanceName
        + "}";
  }

  /**
   * Creates a builder for {@link BindRouteServiceInstanceRequest BindRouteServiceInstanceRequest}.
   * <pre>
   * BindRouteServiceInstanceRequest.builder()
   *    .domainName(String) // required {@link BindRouteServiceInstanceRequest#getDomainName() domainName}
   *    .hostname(String | null) // nullable {@link BindRouteServiceInstanceRequest#getHostname() hostname}
   *    .parameters(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link BindRouteServiceInstanceRequest#getParameters() parameters}
   *    .path(String | null) // nullable {@link BindRouteServiceInstanceRequest#getPath() path}
   *    .serviceInstanceName(String) // required {@link BindRouteServiceInstanceRequest#getServiceInstanceName() serviceInstanceName}
   *    .build();
   * </pre>
   * @return A new BindRouteServiceInstanceRequest builder
   */
  public static BindRouteServiceInstanceRequest.Builder builder() {
    return new BindRouteServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link BindRouteServiceInstanceRequest BindRouteServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_BindRouteServiceInstanceRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN_NAME = 0x1L;
    private static final long INIT_BIT_SERVICE_INSTANCE_NAME = 0x2L;
    private long initBits = 0x3L;

    private String domainName;
    private String hostname;
    private Map<String, Object> parameters = null;
    private String path;
    private String serviceInstanceName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BindRouteServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BindRouteServiceInstanceRequest instance) {
      return from((_BindRouteServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _BindRouteServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_BindRouteServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      domainName(instance.getDomainName());
      String hostnameValue = instance.getHostname();
      if (hostnameValue != null) {
        hostname(hostnameValue);
      }
      Map<String, Object> parametersValue = instance.getParameters();
      if (parametersValue != null) {
        putAllParameters(parametersValue);
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      serviceInstanceName(instance.getServiceInstanceName());
      return this;
    }

    /**
     * Initializes the value for the {@link BindRouteServiceInstanceRequest#getDomainName() domainName} attribute.
     * @param domainName The value for domainName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domainName(String domainName) {
      this.domainName = Objects.requireNonNull(domainName, "domainName");
      initBits &= ~INIT_BIT_DOMAIN_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link BindRouteServiceInstanceRequest#getHostname() hostname} attribute.
     * @param hostname The value for hostname (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder hostname(@Nullable String hostname) {
      this.hostname = hostname;
      return this;
    }

    /**
     * Put one entry to the {@link BindRouteServiceInstanceRequest#getParameters() parameters} map.
     * @param key The key in the parameters map
     * @param value The associated value in the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(String key, Object value) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      this.parameters.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link BindRouteServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.parameters.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link BindRouteServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameters(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.parameters = null;
        return this;
      }
      this.parameters = new LinkedHashMap<String, Object>();
      return putAllParameters(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link BindRouteServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllParameters(Map<String, ? extends Object> entries) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.parameters.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link BindRouteServiceInstanceRequest#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link BindRouteServiceInstanceRequest#getServiceInstanceName() serviceInstanceName} attribute.
     * @param serviceInstanceName The value for serviceInstanceName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceName(String serviceInstanceName) {
      this.serviceInstanceName = Objects.requireNonNull(serviceInstanceName, "serviceInstanceName");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE_NAME;
      return this;
    }

    /**
     * Builds a new {@link BindRouteServiceInstanceRequest BindRouteServiceInstanceRequest}.
     * @return An immutable instance of BindRouteServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BindRouteServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new BindRouteServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DOMAIN_NAME) != 0) attributes.add("domainName");
      if ((initBits & INIT_BIT_SERVICE_INSTANCE_NAME) != 0) attributes.add("serviceInstanceName");
      return "Cannot build BindRouteServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
